/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.dto.TcvatDraftEditRecordEntity;

public class RecordDraftModifyDataService {
    private static final Log LOGGER = LogFactory.getLog(RecordDraftModifyDataService.class);

    public static void recordModify(String orgid, BigDecimal oldValue, BigDecimal newValue, String draftid, String drafttype, String draftnumber) {
        try {
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)DraftConstant.TCVAT_DRAFT_EDIT);
            adjustObj.set("adjusttype", (Object)"1");
            adjustObj.set("taxorg", (Object)orgid);
            adjustObj.set("tzszq", (Object)oldValue);
            adjustObj.set("tzszh", (Object)newValue);
            adjustObj.set("tzsm", (Object)"");
            adjustObj.set("draftid", (Object)draftid);
            adjustObj.set("drafttype", (Object)drafttype);
            adjustObj.set("draftnumber", (Object)draftnumber);
            adjustObj.set("creator", (Object)RequestContext.get().getUserId());
            adjustObj.set("createtime", (Object)new Date());
            adjustObj.set("isrefreshmodify", (Object)false);
            saveList.add(adjustObj);
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            LOGGER.error("DATA RECORD FAILURE", (Throwable)e);
        }
    }

    public static void recordModify(TcvatDraftEditRecordEntity entity) {
        try {
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)DraftConstant.TCVAT_DRAFT_EDIT);
            adjustObj.set("adjusttype", (Object)entity.getAdjustType());
            adjustObj.set("itemname", (Object)entity.getItemName());
            adjustObj.set("taxorg", (Object)entity.getOrgId());
            adjustObj.set("tzszq", (Object)entity.getOldValue());
            adjustObj.set("tzszh", (Object)entity.getNewValue());
            adjustObj.set("tzsm", (Object)entity.getTzsm());
            adjustObj.set("draftid", (Object)entity.getDraftId());
            adjustObj.set("drafttype", (Object)entity.getDraftType());
            adjustObj.set("rowcode", (Object)entity.getRowCode());
            adjustObj.set("draftnumber", (Object)entity.getDraftNumber());
            adjustObj.set("creator", (Object)RequestContext.get().getUserId());
            adjustObj.set("createtime", (Object)new Date());
            adjustObj.set("isrefreshmodify", (Object)false);
            saveList.add(adjustObj);
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            LOGGER.error("DATA RECORD FAILURE", (Throwable)e);
        }
    }
}

