/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.account;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.AccountingDetailFormService;
import kd.taxc.tcvat.business.service.account.InvoiceDetailsService;
import kd.taxc.tcvat.business.service.account.RolloutAmountDetailsService;
import kd.taxc.tcvat.business.service.account.SaveFetchRuleExtensionService;
import kd.taxc.tcvat.business.service.account.hzsb.HzRolloutAmountDetailsService;
import kd.taxc.tcvat.business.service.account.hzsb.YbHzAccountingDetailsService;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.AddDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.DiffDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.SmallScaleCurrentPaymentEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzAddDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzJzjtJxseEngine;
import kd.taxc.tcvat.business.service.engine.impl.service.DiffDeductionEngineService;
import kd.taxc.tcvat.business.service.prepay.engine.impl.AccountEngineService;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.AddDeductionRelateEnum;
import kd.taxc.tcvat.common.enums.DiffRuleTypeEnum;
import kd.taxc.tcvat.common.enums.DraftFieldEnum;

public class SaveFetchRuleService
implements SaveFetchRuleExtensionService {
    private static final Log LOGGER = LogFactory.getLog(SaveFetchRuleService.class);
    private SaveFetchRuleExtensionService saveFetchRuleExtensionService;

    public SaveFetchRuleService(String formId) {
        if (formId != null && "tcvat_accdetail_list".equals(formId)) {
            this.saveFetchRuleExtensionService = new AccountingDetailFormService();
        } else if (formId != null && "tcvat_hz_rollout_amo_list".equals(formId)) {
            this.saveFetchRuleExtensionService = new HzRolloutAmountDetailsService();
        } else if (formId != null && "tcvat_rollout_amount_list".equals(formId)) {
            this.saveFetchRuleExtensionService = new RolloutAmountDetailsService();
        } else if (formId != null && "tcvat_ybhz_accdetail_list".equals(formId)) {
            this.saveFetchRuleExtensionService = new YbHzAccountingDetailsService();
        } else if (formId != null && "tcvat_income_invoice_list".equals(formId)) {
            this.saveFetchRuleExtensionService = new InvoiceDetailsService();
        }
        if (this.saveFetchRuleExtensionService == null) {
            this.saveFetchRuleExtensionService = this;
        }
    }

    @Override
    public void afterSave(Map<String, Object> customParams) {
        if (this.saveFetchRuleExtensionService != null) {
            this.saveFetchRuleExtensionService.afterSave(customParams);
        }
    }

    public void txUpdate(Map<String, Object> customParams, Map<String, Object> modelParam) {
        try (TXHandle h = TX.requiresNew();){
            try {
                this.updateDraftCell(customParams, modelParam);
                this.saveEditRecordAndMarkDraftModified(customParams, modelParam);
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error("DATA UPGRADE FAILURE!!!!", t);
                throw new RuntimeException(t);
            }
        }
        String updateDraft = (String)customParams.get("updateDraft");
        if (DraftConstant.YBNSR_INCOME_SUMMARY_SJJT.equals(updateDraft) || DraftConstant.YBNSR_INCOME_SUMMARY.equals(updateDraft)) {
            this.reCalDiffDraft(customParams);
        }
        String draftpurpose = (String)customParams.get("draftpurpose");
        if ("zzsxgmnsr".equals(customParams.get("taxpayertype")) && AddDeductionRelateEnum.mapping(updateDraft) && (updateDraft.equals("tcvat_xgm_account_summary") || updateDraft.equals("tcvat_diffdeduct_temp") || updateDraft.equals("tcvat_xgm_account_sum_jt") || updateDraft.equals("tcvat_diffdeduct_sjjt"))) {
            SmallScaleCurrentPaymentEngine smallScaleCurrentPaymentEngine = new SmallScaleCurrentPaymentEngine();
            smallScaleCurrentPaymentEngine.createDraft((String)customParams.get("orgid"), (String)customParams.get("skssqq"), (String)customParams.get("skssqz"), (String)customParams.get("deadline"), draftpurpose, (IPageCache)new PageCache(""));
        }
    }

    private void updateDraftCell(Map<String, Object> customParams, Map<String, Object> modelParam) {
        String updateDraft = (String)customParams.get("updateDraft");
        DynamicObject draftObj = BusinessDataServiceHelper.loadSingle((Object)customParams.get("id"), (String)updateDraft);
        String fieldName = (String)customParams.get("fieldName");
        if (("tcvat_hz_account_summary".equals(updateDraft) || DraftConstant.YBHZ_HZ_ACCOUNT_SUMMARY_SJJT.equals(updateDraft)) && "noneinvoiceamount".equals(fieldName)) {
            fieldName = "accountingamount";
        }
        Object adjustsumamount = modelParam.get(DraftConstant.ADJUSTSUMAMOUNT);
        BigDecimal original = draftObj.getBigDecimal(fieldName);
        draftObj.set(fieldName, adjustsumamount);
        this.saveFetchRuleExtensionService.updateFiled(draftObj, fieldName, adjustsumamount, updateDraft);
        if (DraftConstant.YBHZ_HZ_ACCOUNT_SUMMARY_SJJT.equals(updateDraft) || DraftConstant.YBNSR_INCOME_SUMMARY_SJJT.equals(updateDraft) || "tcvat_account_summary".equals(updateDraft) || "tcvat_hz_account_summary".equals(updateDraft) || "tcvat_xgm_account_summary".equals(updateDraft) || DraftConstant.XGMNSR_ACCOUNT_SUMMARY_SJJT.equals(updateDraft)) {
            BigDecimal totalAmount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{draftObj.getBigDecimal("specialinvoiceamount"), draftObj.getBigDecimal("otherinvoiceamount"), "tcvat_xgm_account_summary".equals(updateDraft) || "tcvat_xgm_account_sum_jt".equals(updateDraft) ? draftObj.getBigDecimal("noneinvoiceamount") : draftObj.getBigDecimal("accountingamount")});
            draftObj.set("tcvat_xgm_account_summary".equals(updateDraft) || "tcvat_xgm_account_sum_jt".equals(updateDraft) ? "totalinvoiceamount" : "taxamount", (Object)totalAmount);
            BigDecimal totaltaxamount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{draftObj.getBigDecimal("specialtaxamount"), draftObj.getBigDecimal("othertaxamount"), draftObj.getBigDecimal("nonetaxamount")});
            draftObj.set("totaltaxamount", (Object)totaltaxamount);
            draftObj.set("pricetaxamount", (Object)BigDecimalUtil.addObject((Object)totalAmount, (Object)totaltaxamount));
        }
        if ("tcvat_project_account".equals(updateDraft)) {
            DynamicObject taxOrgObject = OrgCheckUtil.getTaxOrgNsrxx((Long)draftObj.getDynamicObject("orgid").getLong("id"), (Date)draftObj.getDate("startdate"), (Date)draftObj.getDate("enddate"), (String)"tcvat");
            String taxPayerType = taxOrgObject == null ? null : taxOrgObject.getString("taxpayertype");
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)draftObj.get("projectid"), (String)"tcvat_prepay_project_info");
            DynamicObjectCollection entryCollection = draftObj.getDynamicObjectCollection("entryentity");
            String prepayProjectType = draftObj.getString("prepaytype");
            BigDecimal prepayAmount = BigDecimal.ZERO;
            for (DynamicObject object : entryCollection) {
                AccountEngineService.calculateEntryAmount(object.getInt("seq"), new BigDecimal(object.getString("prepayrate").replace("%", "")), prepayProjectType, taxPayerType, draftObj, object, prepayAmount);
                if (object.getInt("seq") == 1) {
                    prepayAmount = object.getBigDecimal("prepayamount");
                }
                this.otherTaxTypeEntry(object, project, prepayAmount, draftObj.getBigDecimal("salesamount"));
            }
        }
        if (DraftConstant.YBNSR_DIFF_SUMMARY.equals(updateDraft) || DraftConstant.YBNSR_DIFF_SUMMARY_SJJT.equals(updateDraft)) {
            if ("currentamount".equals(fieldName)) {
                this.updateRelateCellWhileFseChange(draftObj, updateDraft, original, customParams);
            }
            if ("deductamount".equals(fieldName)) {
                this.updateRelateCellWhileMsKceChange(draftObj, updateDraft, original, customParams);
            }
        }
        if (DraftConstant.YBNSR_SJKCE_SUMMARY.equals(updateDraft) || DraftConstant.YBNSR_SJKCE_SUMMARY_SJJT.equals(updateDraft)) {
            this.updateRelateCellWhileKceChange(draftObj, updateDraft, fieldName, customParams);
        }
        SaveServiceHelper.update((DynamicObject)draftObj);
        String taxperiod = draftObj.containsProperty("taxperiod") ? draftObj.getString("taxperiod") : draftObj.getString("startdate").substring(0, 7);
        this.handleAddDeductionDraft(updateDraft, customParams.getOrDefault("mainorgid", customParams.get("orgid")).toString(), taxperiod, (String)customParams.getOrDefault("taxpayertype", ""), customParams);
    }

    private void saveEditRecordAndMarkDraftModified(Map<String, Object> customParams, Map<String, Object> modelParam) {
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        BigDecimal oldRuleAdjustAmount = new BigDecimal((String)modelParam.get("oldRuleAdjustAmount"));
        BigDecimal ruleAdjustAmount = (BigDecimal)modelParam.get(DraftConstant.CARDADJUSTAMOUNT);
        BigDecimal oldManualAdjustAmount = new BigDecimal((String)modelParam.get("oldManualAdjustAmount"));
        BigDecimal manualAdjustAmount = (BigDecimal)modelParam.get("manualAdjustAmount");
        String tzsm0 = (String)modelParam.get("tzsm0");
        Object oldRuleTzsm = modelParam.get("oldRuleTzsm");
        Object oldManualTzsm = modelParam.get("oldManualTzsm");
        if (ruleAdjustAmount.compareTo(oldRuleAdjustAmount) != 0 || oldRuleTzsm != null && !Objects.equals(tzsm0, oldRuleTzsm)) {
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)DraftConstant.TCVAT_DRAFT_EDIT);
            adjustObj.set("adjusttype", (Object)"1");
            adjustObj.set("itemname", customParams.get("description"));
            adjustObj.set("taxorg", customParams.get("orgid"));
            adjustObj.set("tzszq", (Object)oldRuleAdjustAmount);
            adjustObj.set("tzszh", (Object)ruleAdjustAmount);
            adjustObj.set("tzsm", (Object)tzsm0);
            adjustObj.set("draftid", customParams.get("id"));
            adjustObj.set("drafttype", customParams.get("drafttype"));
            adjustObj.set("rowcode", (Object)DraftFieldEnum.mapping((String)customParams.get("drafttype"), (String)customParams.get("fieldName")));
            adjustObj.set("originamount", modelParam.get(DraftConstant.CARDORIGINAMOUNT));
            adjustObj.set("draftnumber", customParams.get("draftnumber"));
            adjustObj.set("creator", (Object)RequestContext.get().getUserId());
            adjustObj.set("createtime", (Object)new Date());
            adjustObj.set("isrefreshmodify", (Object)Boolean.FALSE);
            saveList.add(adjustObj);
        }
        String tzsm1 = (String)modelParam.get("tzsm1");
        if (manualAdjustAmount.compareTo(oldManualAdjustAmount) != 0 || oldManualTzsm != null && !Objects.equals(tzsm1, oldManualTzsm)) {
            DynamicObject adjustObj = BusinessDataServiceHelper.newDynamicObject((String)DraftConstant.TCVAT_DRAFT_EDIT);
            adjustObj.set("adjusttype", (Object)"2");
            adjustObj.set("itemname", (Object)"--");
            adjustObj.set("taxorg", (Object)"--");
            adjustObj.set("tzszq", (Object)oldManualAdjustAmount);
            adjustObj.set("tzszh", (Object)manualAdjustAmount);
            adjustObj.set("tzsm", (Object)tzsm1);
            adjustObj.set("draftid", customParams.get("id"));
            adjustObj.set("drafttype", customParams.get("drafttype"));
            adjustObj.set("rowcode", (Object)DraftFieldEnum.mapping((String)customParams.get("drafttype"), (String)customParams.get("fieldName")));
            adjustObj.set("originamount", modelParam.get(DraftConstant.CARDORIGINAMOUNT));
            adjustObj.set("draftnumber", customParams.get("draftnumber"));
            adjustObj.set("creator", (Object)RequestContext.get().getUserId());
            adjustObj.set("createtime", (Object)new Date());
            adjustObj.set("isrefreshmodify", (Object)Boolean.FALSE);
            saveList.add(adjustObj);
        }
        this.saveFetchRuleExtensionService.addRollOutRecord(tzsm0, tzsm1, oldRuleTzsm, oldManualTzsm, customParams, saveList, modelParam);
        if (saveList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            this.markDraftModified((String)customParams.get("draftnumber"));
        }
    }

    private void reCalDiffDraft(Map<String, Object> customParams) {
        String selectFileds;
        String entryName = ((String)customParams.get("draftnumber")).startsWith("VATACCURE") ? "tpo_declare_main_tsd" : "tctb_draft_main";
        DynamicObject draft = QueryServiceHelper.queryOne((String)entryName, (String)(selectFileds = ((String)customParams.get("draftnumber")).startsWith("VATACCURE") ? "skssqq as startdate,skssqz as enddate,templatetype,draftpurpose" : "startdate,enddate,templatetype,draftpurpose"), (QFilter[])new QFilter[]{new QFilter("billno", "=", customParams.get("draftnumber"))});
        if (draft != null) {
            String startdateStr = DateUtils.format((Date)draft.getDate("startdate"));
            String enddateStr = DateUtils.format((Date)draft.getDate("enddate"));
            TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel((String)customParams.get("orgid"), startdateStr, enddateStr, draft.getString("templatetype").replace("draft_", "").replace("_sjjt", ""), null, draft.getString("draftpurpose"));
            engineModel.getCustom().put("calcType", "refetch");
            DiffDeductionEngine diffDeductionEngine = new DiffDeductionEngine();
            diffDeductionEngine.setCtx(RequestContext.getOrCreate());
            diffDeductionEngine.setEngineModel(engineModel);
            try {
                diffDeductionEngine.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void otherTaxTypeEntry(DynamicObject object, DynamicObject project, BigDecimal prepayAmount, BigDecimal salesamount) {
        String sljsjjbillingbasis;
        BigDecimal prepayrate;
        String yhstaxbasis;
        String taxtype;
        String sljsjj = ResManager.loadKDString((String)"\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", (String)"AbstractEditPopFormPlugin_8", (String)"taxc-tcvat", (Object[])new Object[0]);
        String yhs = ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"AbstractEditPopFormPlugin_10", (String)"taxc-tcvat", (Object[])new Object[0]);
        if (yhs.equals(taxtype = object.getString("taxtype")) && "1".equals(yhstaxbasis = project.getString("yhstaxbasis"))) {
            object.set("prepaybase", (Object)salesamount);
            prepayrate = new BigDecimal(object.getString("prepayrate").replace("%", ""));
            object.set("prepayamount", (Object)object.getBigDecimal("prepaybase").multiply(prepayrate).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        }
        if (sljsjj.equals(taxtype) && "1".equals(sljsjjbillingbasis = project.getString("sljsjjbillingbasis"))) {
            object.set("prepaybase", (Object)prepayAmount);
            prepayrate = new BigDecimal(object.getString("prepayrate").replace("%", ""));
            object.set("prepayamount", (Object)object.getBigDecimal("prepaybase").multiply(prepayrate).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
        }
    }

    private void updateRelateCellWhileFseChange(DynamicObject upperDraft, String upperDraftName, BigDecimal original, Map<String, Object> customParams) {
        DynamicObject draftObj = BusinessDataServiceHelper.loadSingle((String)(upperDraftName.contains("sjjt") ? DraftConstant.YBNSR_SJKCE_SUMMARY_SJJT : DraftConstant.YBNSR_SJKCE_SUMMARY), (QFilter[])new QFilter[]{new QFilter("org", "=", upperDraft.get("org.id")), new QFilter("taxperiod", "in", PeriodService.getPeriodList(DateUtils.stringToDate2((String)((String)customParams.get("skssqq"))), DateUtils.stringToDate2((String)((String)customParams.get("skssqz"))))), new QFilter("difftype", "=", upperDraft.get("difftype.id"))});
        if (draftObj == null) {
            return;
        }
        BigDecimal amount = upperDraft.getBigDecimal("currentamount").subtract(original);
        draftObj.set("currentamount", (Object)draftObj.getBigDecimal("currentamount").add(amount));
        draftObj.set("predeductamount", (Object)draftObj.getBigDecimal("predeductamount").add(amount));
        draftObj.set("endamount", (Object)draftObj.getBigDecimal("predeductamount").subtract(draftObj.getBigDecimal("deductamount")));
        DynamicObject diffRule = QueryServiceHelper.queryOne((String)"tcvat_rule_diff", (String)"minswitch,equalsjkce", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draftObj.getLong("ruleid"))});
        if (diffRule != null) {
            if (diffRule.getBoolean("minswitch")) {
                BigDecimal notaxamount = draftObj.getBigDecimal("notaxamount");
                BigDecimal predeductamount = draftObj.getBigDecimal("predeductamount");
                draftObj.set("deductamount", (Object)notaxamount.min(predeductamount));
            }
            if (diffRule.getBoolean("equalsjkce")) {
                draftObj.set("jzjtdeductamount", draftObj.get("deductamount"));
            }
        }
        SaveServiceHelper.update((DynamicObject)draftObj);
    }

    private void updateRelateCellWhileMsKceChange(DynamicObject upperDraft, String upperDraftName, BigDecimal original, Map<String, Object> customParams) {
        DynamicObject draftObj = BusinessDataServiceHelper.loadSingle((String)(upperDraftName.contains("sjjt") ? DraftConstant.YBNSR_SJKCE_SUMMARY_SJJT : DraftConstant.YBNSR_SJKCE_SUMMARY), (QFilter[])new QFilter[]{new QFilter("org", "=", upperDraft.get("org.id")), new QFilter("taxperiod", "in", PeriodService.getPeriodList(DateUtils.stringToDate2((String)((String)customParams.get("skssqq"))), DateUtils.stringToDate2((String)((String)customParams.get("skssqz"))))), new QFilter("difftype", "=", upperDraft.get("difftype.id"))});
        if (draftObj == null) {
            return;
        }
        BigDecimal amount = upperDraft.getBigDecimal("deductamount").subtract(original);
        draftObj.set("deductamount", (Object)draftObj.getBigDecimal("deductamount").add(amount));
        draftObj.set("endamount", (Object)draftObj.getBigDecimal("predeductamount").subtract(draftObj.getBigDecimal("deductamount")));
        SaveServiceHelper.update((DynamicObject)draftObj);
    }

    private void updateRelateCellWhileKceChange(DynamicObject draftObj, String updateDraftName, String fieldName, Map<String, Object> customParams) {
        DynamicObject[] incomeAccountCollection = BusinessDataServiceHelper.load((String)(updateDraftName.contains("sjjt") ? DraftConstant.YBNSR_INCOME_SUMMARY_SJJT : DraftConstant.YBNSR_INCOME_SUMMARY), (String)"businesstype,taxrate,taxmethodtype,pricetaxamount,jzjt,totaltaxamount", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)draftObj.getLong("org.id")), new QFilter("taxperiod", "in", PeriodService.getPeriodList(DateUtils.stringToDate2((String)((String)customParams.get("skssqq"))), DateUtils.stringToDate2((String)((String)customParams.get("skssqz")))))});
        DiffRuleTypeEnum diffTypeEnum = DiffRuleTypeEnum.getEnumById(draftObj.getLong("difftype.id"));
        List<DynamicObject> incomeList = DiffDeductionEngineService.doGetIncomeList(incomeAccountCollection, diffTypeEnum, false);
        List<DynamicObject> jzjtIncomeList = DiffDeductionEngineService.doGetIncomeList(incomeAccountCollection, diffTypeEnum, true);
        if ("deductamount".equals(fieldName)) {
            draftObj.set("endamount", (Object)draftObj.getBigDecimal("predeductamount").subtract(draftObj.getBigDecimal("deductamount")));
            draftObj.set("ynse", (Object)DiffDeductionEngineService.calYnse(incomeList.stream().map(e -> e.getBigDecimal("totaltaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO), draftObj, diffTypeEnum));
            DynamicObject diffRule = QueryServiceHelper.queryOne((String)"tcvat_rule_diff", (String)"equalsjkce", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)draftObj.getLong("ruleid"))});
            if (diffRule != null && diffRule.getBoolean("equalsjkce")) {
                draftObj.set("jzjtdeductamount", draftObj.get("deductamount"));
            }
        }
        if ("jzjtdeductamount".equals(fieldName)) {
            draftObj.set("jzjtynse", (Object)DiffDeductionEngineService.calJzjtYnse(jzjtIncomeList.stream().map(e -> e.getBigDecimal("totaltaxamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO), draftObj, diffTypeEnum));
        }
    }

    private void handleAddDeductionDraft(String updateDraft, String orgid, String taxperiod, String taxpayerType, Map<String, Object> customParams) {
        if (AddDeductionRelateEnum.mapping(updateDraft)) {
            if (updateDraft.equals("tcvat_xgm_account_summary") || updateDraft.equals("tcvat_diffdeduct_temp") || updateDraft.equals("tcvat_xgm_account_sum_jt") || updateDraft.equals("tcvat_diffdeduct_sjjt")) {
                return;
            }
            if (updateDraft.contains("hz")) {
                Date skssqq = DateUtils.stringToDate((String)(taxperiod + "-01"));
                Date skssqz = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)skssqq));
                TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel(orgid, DateUtils.format((Date)skssqq), DateUtils.format((Date)skssqz), taxpayerType, null, (String)customParams.get("draftpurpose"));
                if ("zzsybnsr_yz_zjg".equals(taxpayerType) || "zzsybnsr_ybhz".equals(taxpayerType) || "zzsybnsr_hz_zjg".equals(taxpayerType)) {
                    if (AddDeductionRelateEnum.INCOME_HZ_DRAFT.getDraft().equals(updateDraft) || AddDeductionRelateEnum.INCOME_HZ_DRAFT_SJJT.getDraft().equals(updateDraft)) {
                        try {
                            YbhzJzjtJxseEngine jzjtJxseEngine = new YbhzJzjtJxseEngine();
                            engineModel.getCustom().put("calcType", "refetch");
                            jzjtJxseEngine.calcData(engineModel);
                        }
                        catch (Exception e) {
                            LOGGER.error((Throwable)e);
                            String sgtzBizname = ResManager.loadKDString((String)"\u8054\u52a8\u5237\u65b0\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e95\u7a3f\uff0c\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u5206\u6790\u3002", (String)"AbstractEditPopFormPlugin_9", (String)"taxc-tcvat", (Object[])new Object[0]);
                            throw new KDBizException(sgtzBizname);
                        }
                    }
                    YbhzAddDeductionEngine ybhzAddDeductionEngine = new YbhzAddDeductionEngine();
                    ybhzAddDeductionEngine.insertData(engineModel, orgid, skssqq, skssqz);
                }
            } else {
                String selectFileds;
                String entryName = ((String)customParams.get("draftnumber")).startsWith("VATACCURE") ? "tpo_declare_main_tsd" : "tctb_draft_main";
                DynamicObject draft = QueryServiceHelper.queryOne((String)entryName, (String)(selectFileds = ((String)customParams.get("draftnumber")).startsWith("VATACCURE") ? "skssqq as startdate,skssqz as enddate,templatetype,draftpurpose" : "startdate,enddate,templatetype,draftpurpose"), (QFilter[])new QFilter[]{new QFilter("billno", "=", customParams.get("draftnumber"))});
                if (draft != null) {
                    String startdateStr = DateUtils.format((Date)draft.getDate("startdate"));
                    String enddateStr = DateUtils.format((Date)draft.getDate("enddate"));
                    TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel(orgid, startdateStr, enddateStr, draft.getString("templatetype").replace("draft_", "").replace("_sjjt", ""), null, draft.getString("draftpurpose"));
                    AddDeductionEngine engine = new AddDeductionEngine();
                    engine.insertData(orgid, engineModel);
                }
            }
        }
    }

    private void markDraftModified(String draftnumber) {
        TaxDeclareHelper.markDraftModified(draftnumber, 1);
    }
}

