/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.declare;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.common.enums.TaxPayerTypeEnum;

public class DeclareShowService {
    public static final String ORG = "org";
    public static final String PARA_ORG = "orgid";
    public static final String SKSSQQ = "skssqq";
    public static final String SKSSQZ = "skssqz";
    public static final String TABPAGEAP1 = "tabpageap1";
    public static final String TABPAGEAP2 = "tabpageap2";
    public static final String TABPAGEAP3 = "tabpageap3";
    public static final String TABPAGEAP4 = "tabpageap4";
    private static final String[] tab_keys = new String[]{"tabpageap1", "tabpageap2", "tabpageap3", "tabpageap4"};

    public static String[] getTabKeys() {
        return tab_keys;
    }

    public static void initBaseData(Map<String, Object> customParams, IDataModel dataModel) {
        dataModel.setValue(ORG, customParams.get(PARA_ORG));
        dataModel.setValue(SKSSQQ, (Object)DateUtils.stringToDate((String)((String)customParams.get(SKSSQQ))));
        dataModel.setValue(SKSSQZ, (Object)DateUtils.stringToDate((String)((String)customParams.get(SKSSQZ))));
    }

    public static void setActiveTab(String tabKey, IFormView formView, Map<String, String> pageMap) {
        HashMap<String, Object> stylemap = new HashMap<String, Object>(2);
        stylemap.put("bc", "#F3F6FF");
        String linestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap();
        HashMap<String, String> border = new HashMap<String, String>();
        border.put("b", linestyle);
        style.put("b", border);
        stylemap.put("s", style);
        formView.updateControlMetadata(tabKey, stylemap);
        HashMap<String, Object> stylemap1 = new HashMap<String, Object>(2);
        stylemap1.put("bc", "#ffffff");
        String linestyle1 = "0px_solid_#ffffff";
        HashMap style1 = new HashMap();
        HashMap<String, String> border1 = new HashMap<String, String>();
        border1.put("b", linestyle1);
        style1.put("b", border1);
        stylemap1.put("s", style1);
        Arrays.asList(tab_keys).forEach(key -> {
            if (!key.equals(tabKey)) {
                formView.updateControlMetadata(key, stylemap1);
            }
        });
        DeclareShowService.showTab(tabKey, formView, pageMap);
    }

    public static void showTab(String tableKey, IFormView formView, Map<String, String> pageMap) {
        String formId = pageMap.get(tableKey);
        Map customParams = formView.getFormShowParameter().getCustomParams();
        customParams.put("from", "history");
        String skssqq = (String)customParams.get(SKSSQQ);
        String orgid = (String)customParams.get(PARA_ORG);
        String skssqz = (String)customParams.get(SKSSQZ);
        String templatetype = (String)customParams.get("templatetype");
        customParams.put("taxperiod", skssqq.substring(0, 7));
        if (TABPAGEAP2.equals(tableKey)) {
            formId = TaxPayerTypeEnum.getEnumByTaxPayerType((String)customParams.get("taxPayerType")).getAccountPage();
            customParams.put("status", "3");
            customParams.put("readonly", Boolean.TRUE);
        } else if (TABPAGEAP3.equals(tableKey)) {
            formId = TaxPayerTypeEnum.getEnumByTaxPayerType((String)customParams.get("taxPayerType")).getPolicyConfirmHistoryPage();
            customParams.put("status", "3");
        } else if (TABPAGEAP1.equals(tableKey)) {
            DynamicObject object;
            DynamicObject dynamicObject = object = "bdtaxr_taxbureau_sbb".equals(customParams.get("entityid")) ? DeclareShowService.queryHistoryNsrxx(templatetype, orgid, skssqq, skssqz) : DeclareShowService.queryNsrxx(templatetype, orgid, skssqq, skssqz);
            if (object != null && StringUtils.isNotEmpty((CharSequence)object.getString("templateid"))) {
                customParams.put("templateid", object.getString("templateid"));
            }
        }
        if (!StringUtils.isEmpty((CharSequence)formId)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(formId);
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexcontent");
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setId(Long.valueOf(Long.parseLong(customParams.getOrDefault("sbbid", "0"))));
            requestModel.setOrgId(Long.valueOf(Long.parseLong(customParams.getOrDefault(PARA_ORG, "0"))));
            requestModel.setTemplateType((String)customParams.get("templatetype"));
            requestModel.setOperation("read");
            requestModel.setSkssqq((String)customParams.get(SKSSQQ));
            requestModel.setSkssqz((String)customParams.get(SKSSQZ));
            requestModel.setRefresh(Boolean.FALSE);
            if ("bdtaxr_history_sbb".equals(customParams.get("entityid"))) {
                requestModel.setDataSource("history");
            }
            if ("bdtaxr_taxbureau_sbb".equals(customParams.get("entityid"))) {
                requestModel.setDataSource("taxBureau");
            }
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
            parameter.setCustomParams(customParams);
            formView.showForm(parameter);
        }
    }

    public static DynamicObject queryNsrxx(String templateType, String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        return YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)startdate, (String)enddate, Collections.emptyMap());
    }

    public static DynamicObject queryHistoryNsrxx(String templateType, String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        QFilter qFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId)).and(SKSSQQ, "=", (Object)DateUtils.stringToDate((String)startdate)).and(SKSSQZ, "=", (Object)DateUtils.stringToDate((String)enddate)).and("type", "=", (Object)templateType);
        return QueryServiceHelper.queryOne((String)"bdtaxr_history_sbb", (String)"templateid, id,modifytime, creator, datatype", (QFilter[])qFilter.toArray());
    }
}

