/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.dispatchservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.task.helper.BatchGenerateTaskOrgQueryHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.dispatchservice.PrepayDeclareProcessService;
import kd.taxc.tcvat.business.service.dispatchservice.dto.PrepayDeclareDTO;
import org.apache.commons.beanutils.ConvertUtils;

public class PrepayDeclareProcessTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(PrepayDeclareProcessTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        String orgId = (String)map.get("orgId");
        String startDateStr = (String)map.get("startDate");
        String endDateStr = (String)map.get("endDate");
        Date startDate = DateUtils.getLastMinMonthDate();
        Date endDate = DateUtils.getLastMaxMonthDate();
        if (StringUtil.isNotBlank((CharSequence)startDateStr)) {
            startDate = DateUtils.stringToDate((String)((String)map.get("startDate")));
        }
        if (StringUtil.isNotBlank((CharSequence)endDateStr)) {
            endDate = DateUtils.stringToDate((String)((String)map.get("endDate")));
        }
        List<Object> orgIdList = new ArrayList(0);
        if (StringUtil.isBlank((CharSequence)orgId)) {
            List orgListStr = BatchGenerateTaskOrgQueryHelper.getOrgList(map);
            orgIdList = orgListStr.stream().map(Long::parseLong).collect(Collectors.toList());
        } else {
            String[] orgIds = orgId.split(",");
            orgIdList = Arrays.asList((Long[])ConvertUtils.convert((String[])orgIds, Long.class));
        }
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter projectStatusFilter = new QFilter("projectstatus", "!=", (Object)"close");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection projectInfo = QueryServiceHelper.query((String)"tcvat_prepay_project_info", (String)"id,org", (QFilter[])new QFilter[]{orgFilter, statusFilter, projectStatusFilter});
        PrepayDeclareProcessService prepayDeclareProcessService = new PrepayDeclareProcessService();
        ArrayList<String> logs = new ArrayList<String>();
        for (DynamicObject project : projectInfo) {
            ApiResult apiResult = prepayDeclareProcessService.execute(new PrepayDeclareDTO(project.getLong("org"), project.getLong("id"), startDate, endDate, null));
            logs.add("MESSAGE: " + project.getString("id") + " result :" + apiResult.getSuccess() + ": " + apiResult.getMessage());
        }
        logger.info(((Object)logs).toString());
    }
}

