/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.dispatchservice.handler;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.tcvat.business.service.dispatchservice.dto.PrepayDeclareDTO;
import kd.taxc.tcvat.business.service.dispatchservice.handler.AbstractProcessHandler;
import kd.taxc.tcvat.business.service.dispatchservice.handler.task.TaxDeclareProcessTask;
import kd.taxc.tcvat.business.service.prepay.declare.CheckDraftService;

public class FirstStepHandler
extends AbstractProcessHandler<ApiResult, PrepayDeclareDTO> {
    private static Log logger = LogFactory.getLog(FirstStepHandler.class);

    @Override
    public ApiResult handler(PrepayDeclareDTO prepayDeclareDTO) {
        logger.info("create draft");
        String declareSerialno = CheckDraftService.getDeclareSerialno(prepayDeclareDTO);
        TaxDeclareProcessTask taxDeclareProcessTask = new TaxDeclareProcessTask(declareSerialno, prepayDeclareDTO);
        taxDeclareProcessTask.setCtx(RequestContext.getOrCreate());
        Future future = ThreadPoolsService.getInstance().submitFutrue((Callable)((Object)taxDeclareProcessTask));
        try {
            future.get();
        }
        catch (Exception e) {
            logger.error("create draft error", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
        ApiResult checkResult = CheckDraftService.checkBeforeNextStep(declareSerialno, prepayDeclareDTO, null);
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        if (null != this.getNextProcessHandler()) {
            return (ApiResult)this.getNextProcessHandler().handler(prepayDeclareDTO);
        }
        return ApiResult.success((Object)prepayDeclareDTO);
    }
}

