/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.dispatchservice.handler;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.dispatchservice.dto.PrepayDeclareDTO;
import kd.taxc.tcvat.business.service.dispatchservice.handler.AbstractProcessHandler;

public class SecondStepHandler
extends AbstractProcessHandler<ApiResult, PrepayDeclareDTO> {
    public static Log logger = LogFactory.getLog(SecondStepHandler.class);

    @Override
    public ApiResult handler(PrepayDeclareDTO prepayDeclareDTO) {
        logger.info("create declare report");
        PageCache cache = new PageCache("");
        cache.put("declareserialno", prepayDeclareDTO.getDeclareSerialno());
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)prepayDeclareDTO.getProjectId(), (String)"tcvat_prepay_project_info", (String)"prepaytype");
        cache.put("prepaytype", project.getString("prepaytype"));
        cache.put("projectid", String.valueOf(prepayDeclareDTO.getProjectId()));
        cache.put("taxorg", String.valueOf(prepayDeclareDTO.getTaxorg()));
        cache.put("taxpayertype", prepayDeclareDTO.getTaxPayerType());
        cache.put("apanage", String.valueOf(prepayDeclareDTO.getProjectId()));
        cache.put("sblx", "2");
        try (TXHandle h = TX.requiresNew();){
            try {
                Map valueMap = FormulaService.query((IPageCache)cache, (String)"zzsyjskb", (String)String.valueOf(prepayDeclareDTO.getOrgId()), (String)DateUtils.format((Date)prepayDeclareDTO.getStartDate()), (String)DateUtils.format((Date)prepayDeclareDTO.getEndDate()), (boolean)true);
                DataSaveService.mapToTable((String)"tcvat_nsrxx", (Map)valueMap);
                new PrepayStatusService().updateStatus(String.valueOf(prepayDeclareDTO.getOrgId()), DateUtils.format((Date)prepayDeclareDTO.getStartDate()), DateUtils.format((Date)prepayDeclareDTO.getEndDate()), "2", String.valueOf(prepayDeclareDTO.getProjectId()), prepayDeclareDTO.getDeclareSerialno());
            }
            catch (Throwable t) {
                h.markRollback();
                logger.error("create declare report error", t);
                ApiResult apiResult = ApiResult.fail((String)t.getMessage());
                if (h != null) {
                    if (var5_5 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return apiResult;
            }
        }
        if (null != this.getNextProcessHandler()) {
            return (ApiResult)this.getNextProcessHandler().handler(prepayDeclareDTO);
        }
        return ApiResult.success((Object)prepayDeclareDTO);
    }
}

