/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.dispatchservice.handler.task;

import java.util.Date;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.dispatchservice.dto.PrepayDeclareDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.prepay.engine.util.PrepayEngineUtils;

public class TaxDeclareProcessTask
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private PrepayDeclareDTO prepayDeclareDTO;
    private String declareserialno;

    public TaxDeclareProcessTask(String declareserialno, PrepayDeclareDTO prepayDeclareDTO) {
        this.prepayDeclareDTO = prepayDeclareDTO;
        this.declareserialno = declareserialno;
    }

    protected DynamicObject execute() throws Exception {
        Long orgid = this.prepayDeclareDTO.getOrgId();
        String projectid = String.valueOf(this.prepayDeclareDTO.getProjectId());
        Date startDate = this.prepayDeclareDTO.getStartDate();
        Date endDate = this.prepayDeclareDTO.getEndDate();
        TcvatEngineModel engineModel = new TcvatEngineModel(String.valueOf(orgid), DateUtils.format((Date)startDate), DateUtils.format((Date)endDate));
        DynamicObject taxOrg = this.getTaxOrg(orgid, startDate, endDate);
        engineModel.addCustom("projectid", projectid);
        engineModel.addCustom("taxorg", taxOrg.getString("taxorg"));
        this.prepayDeclareDTO.setTaxorg(taxOrg.getLong("taxorg"));
        engineModel.addCustom("declareserialno", this.declareserialno);
        try (TXHandle h = TX.requiresNew();){
            try {
                PrepayEngineUtils.execute(RequestContext.getOrCreate(), engineModel);
                new PrepayStatusService().updateStatus(String.valueOf(orgid), DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), "1", projectid, this.declareserialno);
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
        return null;
    }

    private DynamicObject getTaxOrg(Long orgID, Date startDate, Date endDate) {
        DynamicObject taxOrgObject = OrgCheckUtil.getTaxOrgInfo((Long)orgID, (Date)startDate, (Date)endDate);
        if (Objects.isNull(taxOrgObject)) {
            return new DynamicObject();
        }
        return taxOrgObject;
    }
}

