/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.AddDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.YbnsrJzjtJxseEngine;
import kd.taxc.tcvat.business.service.engine.impl.utils.DeductEngineService;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftFieldEnum;

public class DeductionRolloutService {
    private static Log logger = LogFactory.getLog(DeductionRolloutService.class);
    private static DeductEngineService deductEngineService = new DeductEngineService();
    private static final Set<String> ROLLOUTSET = Sets.newHashSet((Object[])new String[]{"tcvat_roll_out_summary", "tcvat_hz_roll_out_sum", "tcvat_roll_out_sum_sjjt", "tcvat_hz_rollout_sum_sjjt"});

    public void updateDeductDynam(DynamicObject t, BigDecimal invoiceJzjtSum, BigDecimal taxAmountSum, String amount, String jzjtxse) {
        t.set("jzjtxse", (Object)invoiceJzjtSum);
        t.set("xsehe", (Object)taxAmountSum);
        if (taxAmountSum.intValue() == 0) {
            t.set("hfbl", (Object)0);
            t.set(jzjtxse, (Object)0);
        } else {
            t.set("hfbl", (Object)invoiceJzjtSum.divide(taxAmountSum, 4, 4));
            t.set(jzjtxse, (Object)t.getBigDecimal(amount).multiply(t.getBigDecimal("hfbl")));
        }
    }

    public Map<String, BigDecimal> getIncomeJzjtAmount(Map<String, Object> params, List<String> dateList) {
        String incomeMeta = DraftMetaDataDTO.getMetaData((String)params.get("draftpurpose"), (String)params.get("taxPayerType")).getIncome().getAccountMetaDataName();
        DynamicObjectCollection incomedata = QueryServiceHelper.query((String)incomeMeta, (String)"taxperiod,taxamount, jzjt", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(params.get("orgid").toString())), new QFilter("taxperiod", "in", dateList)});
        return deductEngineService.incomeJzjtAmount(incomedata);
    }

    public void updateRollOutDate(Map<String, Object> params) {
        List<String> dateList = TaxDeclarationService.getRealQuarter(params.get("draftpurpose").toString(), params.get("orgid").toString(), params.get("skssqq").toString(), params.get("skssqz").toString());
        DraftMetaDataInfo rollOutMetaData = DraftMetaDataDTO.getMetaDataByCustomParam(params).getRollOut();
        QFilter filter = new QFilter("org", "=", (Object)Long.valueOf(params.get("orgid").toString())).and("taxperiod", "in", dateList).and("jzjt", "=", (Object)"2");
        DynamicObject[] rollOut = BusinessDataServiceHelper.load((String)rollOutMetaData.getAccountMetaDataName(), (String)"id,serialno,jzjtrolloutamount", (QFilter[])new QFilter[]{filter});
        if (rollOut == null || rollOut.length == 0) {
            return;
        }
        Map<String, BigDecimal> incomeJzjtAmount = this.getIncomeJzjtAmount(params, dateList);
        ArrayList needWcRollOut = Lists.newArrayList();
        ArrayList needNcRollOut = Lists.newArrayList();
        Set serialnos = Arrays.stream(rollOut).map(o -> o.getString("serialno")).collect(Collectors.toSet());
        QFilter filter1 = new QFilter("taxaccountserialno", "in", serialnos).and("org", "=", (Object)Long.valueOf(params.get("orgid").toString()));
        DynamicObject[] details = BusinessDataServiceHelper.load((String)"tcvat_accdetail_rollout", (String)"id,amount,jzjtxse,xsehe,hfbl,jzjtrolloutamount,taxaccountserialno", (QFilter[])new QFilter[]{filter1});
        for (DynamicObject roll : rollOut) {
            List<DynamicObject> details1 = Arrays.stream(details).filter(a -> roll.getString("serialno").equals(a.getString("taxaccountserialno"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(details1)) continue;
            BigDecimal jzjtjxse1 = BigDecimal.ZERO;
            for (DynamicObject detail1 : details1) {
                this.updateDeductDynam(detail1, incomeJzjtAmount.get("invoiceJzjtSum"), incomeJzjtAmount.get("taxAmountSum"), "amount", "jzjtrolloutamount");
                jzjtjxse1 = jzjtjxse1.add(detail1.getBigDecimal("jzjtrolloutamount"));
            }
            Collections.addAll(needNcRollOut, details1.toArray(new DynamicObject[0]));
            roll.set("jzjtrolloutamount", (Object)jzjtjxse1);
            needWcRollOut.add(roll);
        }
        if (CollectionUtils.isNotEmpty((Collection)needNcRollOut)) {
            SaveServiceHelper.update((DynamicObject[])needNcRollOut.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])needWcRollOut.toArray(new DynamicObject[0]));
        }
    }

    public static void updateJzjtJxseDraft(Map<String, Object> params) {
        String orgid = (String)params.get("orgid");
        String start = params.get("skssqq").toString();
        String last = params.get("skssqz").toString();
        TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel(orgid, start, last, (String)params.get("taxPayerType"), null, (String)params.get("draftpurpose"));
        engineModel.getCustom().put("calcType", "refetch");
        YbnsrJzjtJxseEngine engine = new YbnsrJzjtJxseEngine();
        try {
            engine.calcData(engineModel);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String sgtzBizname = ResManager.loadKDString((String)"\u8054\u52a8\u5237\u65b0\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5e95\u7a3f\uff0c\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u5206\u6790\u3002", (String)"DeductionRolloutService_0", (String)"taxc-tcvat", (Object[])new Object[0]);
            throw new KDBizException(sgtzBizname);
        }
    }

    public static void updateAddDeductionDraft(Map<String, Object> params) {
        String orgid = (String)params.get("orgid");
        String start = params.get("skssqq").toString();
        String last = params.get("skssqz").toString();
        TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel(orgid, start, last, (String)params.get("taxPayerType"), null, (String)params.get("draftpurpose"));
        AddDeductionEngine engine = new AddDeductionEngine();
        engine.insertData(orgid, engineModel);
    }

    public static void addRollOutRecord(String tzsm0, String tzsm1, Object oldRuleTzsm, Object oldManualTzsm, Map<String, Object> customParams, List<DynamicObject> saveList, Map<String, Object> modelParam) {
        BigDecimal oldRuleAdjustAmount = new BigDecimal((String)modelParam.get("oldRuleAdjustAmount"));
        BigDecimal ruleAdjustAmount = (BigDecimal)modelParam.get(DraftConstant.CARDADJUSTAMOUNT);
        BigDecimal oldManualAdjustAmount = new BigDecimal((String)modelParam.get("oldManualAdjustAmount"));
        BigDecimal manualAdjustAmount = (BigDecimal)modelParam.get("manualAdjustAmount");
        Object updateDraft = customParams.get("updateDraft");
        if (ROLLOUTSET.contains(updateDraft) && ("jzjtrolloutamount".equals(customParams.get("fieldName")) || "accountingamount".equals(customParams.get("fieldName")))) {
            DynamicObject adjustObj;
            DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)customParams.get("id"), (String)updateDraft.toString());
            Object fieldName = customParams.get("fieldName");
            if (Objects.isNull(single) || Objects.isNull(fieldName) || !"1".equals(single.get("jzjt"))) {
                return;
            }
            String goalField = "jzjtrolloutamount".equals(fieldName) ? "accountingamount" : "jzjtrolloutamount";
            QFilter draftTypeFilter = new QFilter("drafttype", "=", customParams.get("drafttype"));
            QFilter draftIdFilter = new QFilter("draftid", "=", customParams.get("id"));
            DynamicObjectCollection editList = QueryServiceHelper.query((String)DraftConstant.TCVAT_DRAFT_EDIT, (String)"rowcode,tzszh,adjusttype", (QFilter[])new QFilter[]{draftTypeFilter, draftIdFilter}, (String)"createtime desc");
            if (ruleAdjustAmount.compareTo(oldRuleAdjustAmount) != 0 || oldRuleTzsm != null && !Objects.equals(tzsm0, oldRuleTzsm)) {
                adjustObj = BusinessDataServiceHelper.newDynamicObject((String)DraftConstant.TCVAT_DRAFT_EDIT);
                adjustObj.set("adjusttype", (Object)"1");
                adjustObj.set("itemname", customParams.get("description"));
                adjustObj.set("taxorg", customParams.get("orgid"));
                adjustObj.set("tzszq", DeductionRolloutService.getTaxcAmount(goalField, editList, "1"));
                adjustObj.set("tzszh", (Object)ruleAdjustAmount);
                adjustObj.set("tzsm", (Object)tzsm0);
                adjustObj.set("draftid", customParams.get("id"));
                adjustObj.set("drafttype", customParams.get("drafttype"));
                adjustObj.set("rowcode", (Object)DraftFieldEnum.mapping((String)customParams.get("drafttype"), goalField));
                adjustObj.set("originamount", modelParam.get(DraftConstant.CARDORIGINAMOUNT));
                adjustObj.set("draftnumber", customParams.get("draftnumber"));
                adjustObj.set("creator", (Object)RequestContext.get().getUserId());
                adjustObj.set("createtime", (Object)new Date());
                adjustObj.set("isrefreshmodify", (Object)Boolean.FALSE);
                saveList.add(adjustObj);
            }
            if (manualAdjustAmount.compareTo(oldManualAdjustAmount) != 0 || oldManualTzsm != null && !Objects.equals(tzsm1, oldManualTzsm)) {
                adjustObj = BusinessDataServiceHelper.newDynamicObject((String)DraftConstant.TCVAT_DRAFT_EDIT);
                adjustObj.set("adjusttype", (Object)"2");
                adjustObj.set("itemname", (Object)"--");
                adjustObj.set("taxorg", (Object)"--");
                adjustObj.set("tzszq", DeductionRolloutService.getTaxcAmount(goalField, editList, "2"));
                adjustObj.set("tzszh", (Object)manualAdjustAmount);
                adjustObj.set("tzsm", (Object)tzsm1);
                adjustObj.set("draftid", customParams.get("id"));
                adjustObj.set("drafttype", customParams.get("drafttype"));
                adjustObj.set("rowcode", (Object)DraftFieldEnum.mapping((String)customParams.get("drafttype"), goalField));
                adjustObj.set("originamount", modelParam.get(DraftConstant.CARDORIGINAMOUNT));
                adjustObj.set("draftnumber", customParams.get("draftnumber"));
                adjustObj.set("creator", (Object)RequestContext.get().getUserId());
                adjustObj.set("createtime", (Object)new Date());
                adjustObj.set("isrefreshmodify", (Object)Boolean.FALSE);
                saveList.add(adjustObj);
            }
        }
    }

    public static void updateFiled(DynamicObject draftObj, String fieldName, Object adjustsumamount, String updateDraft) {
        if (!ROLLOUTSET.contains(updateDraft) || !"1".equals(draftObj.get("jzjt"))) {
            return;
        }
        if ("accountingamount".equals(fieldName)) {
            draftObj.set("jzjtrolloutamount", adjustsumamount);
        } else if ("jzjtrolloutamount".equals(fieldName)) {
            draftObj.set("accountingamount", adjustsumamount);
        }
    }

    private static Object getTaxcAmount(String goalField, DynamicObjectCollection dynamicObjects, String type) {
        Object result = 0;
        Optional<DynamicObject> rowcode = dynamicObjects.stream().filter(o -> goalField.equals(o.getString("rowcode")) && type.equals(o.getString("adjusttype"))).findFirst();
        if (rowcode.isPresent()) {
            result = rowcode.get().get("tzszh");
        }
        return result;
    }
}

