/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import org.apache.commons.collections.CollectionUtils;

public class TaxDeclarationService {
    private static Log logger = LogFactory.getLog(TaxDeclarationService.class);

    @Deprecated
    public static TreeNode getDefaultOrg(IFormView getView, List<TreeNode> nodeList) {
        String currOrgId = String.valueOf(RequestContext.get().getOrgId());
        DynamicObject org = null;
        try {
            org = (DynamicObject)getView.getParentView().getModel().getValue("org");
            currOrgId = org.getString("id");
        }
        catch (Exception ee) {
            logger.error((Throwable)ee);
        }
        TreeNode defaultOrg = null;
        for (TreeNode node : nodeList) {
            if (!currOrgId.equals(node.getId())) continue;
            defaultOrg = node;
            break;
        }
        return defaultOrg;
    }

    public static int getJzjtJxseSplitRateScale(Long orgid) {
        String innosplittaxratescale = (String)SystemParamUtil.getAppParameter((String)"tcvat", (String)"innosplittaxratescale", (long)orgid);
        int result = innosplittaxratescale != null ? Integer.parseInt(innosplittaxratescale) : 4;
        return result <= 4 ? 4 : result;
    }

    public static boolean isNature(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        if (DateUtils.getYearOfDate((Date)startDate) != DateUtils.getYearOfDate((Date)endDate)) {
            return false;
        }
        int diff = Math.abs(DateUtils.getMonthOfDate((Date)endDate) - DateUtils.getMonthOfDate((Date)startDate));
        if (diff == 0) {
            Date startDay = DateUtils.getFirstDateOfMonth((Date)startDate);
            Date lastDay = DateUtils.getLastDateOfMonth((Date)endDate);
            return DateUtils.format((Date)startDate).equals(DateUtils.format((Date)startDay)) && DateUtils.format((Date)endDate).equals(DateUtils.format((Date)lastDay));
        }
        if (diff == 2) {
            Date startDay = DateUtils.getFirstDateOfSeason((Date)startDate);
            Date lastDay = DateUtils.getLastDateOfSeason((Date)endDate);
            return DateUtils.format((Date)startDate).equals(DateUtils.format((Date)startDay)) && DateUtils.format((Date)endDate).equals(DateUtils.format((Date)lastDay));
        }
        return false;
    }

    public static List<String> getRealQuarter(String draftPurpose, String orgId, String skssqq, String skssqz) {
        String deadline;
        Date endDate;
        Date starDate;
        DynamicObject object = null;
        if ("sjjt".equals(draftPurpose)) {
            String cycle = PeriodService.getCycleByProvisionPlan(Collections.singletonList(Long.parseLong(orgId)), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
            Map<String, Date> stringDateMap = PeriodService.nowProvisionPeriod(DateUtils.stringToDate((String)skssqq), cycle);
            starDate = stringDateMap.get("startDate");
            endDate = stringDateMap.get("endDate");
            if (starDate == null || endDate == null) {
                starDate = DateUtils.stringToDate((String)skssqq);
                endDate = DateUtils.stringToDate((String)skssqz);
            }
            deadline = TaxDeclareHelper.getDeadLine(draftPurpose, orgId, starDate, endDate);
        } else {
            object = OrgChangeRecordUtil.loadChangeRecord((String)orgId, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
            if (null == object) {
                return new ArrayList<String>(1);
            }
            starDate = object.getDate("taxstartdate");
            endDate = object.getDate("taxenddate");
            deadline = object.getString("deadline");
        }
        List<String> realZone = Arrays.asList(DateUtils.format((Date)starDate), StringUtils.isBlank((Object)endDate) ? DateUtils.format((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)skssqq), (int)("aysb".equals(deadline) ? 1 : 3))) : DateUtils.format((Date)endDate));
        List<Date> realDates = PeriodService.getRealDates(realZone, DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz));
        if (CollectionUtils.isEmpty(realDates)) {
            return new ArrayList<String>();
        }
        return PeriodService.getPeriodList(realDates.get(0), realDates.get(1)).stream().distinct().collect(Collectors.toList());
    }
}

