/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.metadata.handler.hz.sjjt;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.metadata.AbstractDraftMetaDataHandler;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.draft.metadata.handler.hz.sjjt.SjjtHzDraftMetaDataEnum;

public class SjjtHzDraftMetaDataHandler
extends AbstractDraftMetaDataHandler<SjjtHzDraftMetaDataEnum> {
    public Map<String, DraftMetaDataDTO> cacheMap = new ConcurrentHashMap<String, DraftMetaDataDTO>();
    private static final Set<String> taxPayerTypeSet = Sets.newHashSet((Object[])new String[]{"zzsybnsr_ybhz", "zzsybnsr_hz_zjg", "zzsybnsr_yz_zjg"});

    @Override
    public DraftMetaDataDTO handler(String draftPurpose, String taxPayerType) {
        if (taxPayerTypeSet.contains(taxPayerType) && "sjjt".equals(draftPurpose)) {
            if (null != this.cacheMap.get(draftPurpose)) {
                return this.cacheMap.get(draftPurpose);
            }
            this.cacheMap.put(draftPurpose, this.getDraftMetaDataDTO(draftPurpose, taxPayerType));
            return this.cacheMap.get(draftPurpose);
        }
        if (null != this.getNextHandler()) {
            return this.getNextHandler().handler(draftPurpose, taxPayerType);
        }
        return null;
    }

    @Override
    public DraftMetaDataDTO getDraftMetaDataDTO(String draftPurpose, String taxPayerType) {
        DraftMetaDataDTO draftMetaDataDTO = new DraftMetaDataDTO(draftPurpose, taxPayerType);
        draftMetaDataDTO.setTemplateType(TcvatDraftService.getDraftTemplateType(draftPurpose, taxPayerType));
        draftMetaDataDTO.setPolicyConfirm(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.POLICY_CONFIRM));
        draftMetaDataDTO.setIncome(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.INCOME));
        draftMetaDataDTO.setDiff(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.DIFF));
        draftMetaDataDTO.setWaitDeduction(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.WAITDEDUCTION));
        draftMetaDataDTO.setTaxReduction(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.TAXREDUCTION));
        draftMetaDataDTO.setRollOut(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.ROLLOUT));
        draftMetaDataDTO.setDeduction(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.DEDUCTION));
        draftMetaDataDTO.setAddDeduction(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.ADDDEDUCTION));
        draftMetaDataDTO.setPerpre(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.PERPRE));
        draftMetaDataDTO.setJzjtjxse(this.createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum.JZJTJXSE));
        return draftMetaDataDTO;
    }

    @Override
    public DraftMetaDataInfo createDraftMetaDataInfo(SjjtHzDraftMetaDataEnum draftMetaDataEnum) {
        return new DraftMetaDataInfo(draftMetaDataEnum.getAccountMetaDataName(), draftMetaDataEnum.getDetailMetaDataNameMap());
    }
}

