/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.metadata.handler.xgmnsr.nssb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.taxc.tcvat.business.service.draft.metadata.AbstractDraftMetaDataHandler;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.draft.metadata.handler.xgmnsr.nssb.NssbXgmnsrDraftMetaDataEnum;

public class NssbXgmnsrDraftMetaDataHandler
extends AbstractDraftMetaDataHandler<NssbXgmnsrDraftMetaDataEnum> {
    private Map<String, DraftMetaDataDTO> cacheMap = new ConcurrentHashMap<String, DraftMetaDataDTO>();

    @Override
    public DraftMetaDataDTO handler(String draftPurpose, String taxPayerType) {
        if ("zzsxgmnsr".equals(taxPayerType) && "nssb".equals(draftPurpose)) {
            if (null != this.cacheMap.get(draftPurpose)) {
                return this.cacheMap.get(draftPurpose);
            }
            this.cacheMap.put(draftPurpose, this.getDraftMetaDataDTO(draftPurpose, taxPayerType));
            return this.cacheMap.get(draftPurpose);
        }
        if (null != this.getNextHandler()) {
            return this.getNextHandler().handler(draftPurpose, taxPayerType);
        }
        return null;
    }

    @Override
    public DraftMetaDataDTO getDraftMetaDataDTO(String draftPurpose, String taxPayerType) {
        DraftMetaDataDTO draftMetaDataDTO = new DraftMetaDataDTO(draftPurpose, taxPayerType);
        draftMetaDataDTO.setTemplateType("draft_zzsxgmnsr");
        draftMetaDataDTO.setPolicyConfirm(this.createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum.POLICY_CONFIRM));
        draftMetaDataDTO.setIncome(this.createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum.INCOME));
        draftMetaDataDTO.setDiff(this.createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum.DIFF));
        draftMetaDataDTO.setWaitDeduction(this.createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum.WAITDEDUCTION));
        draftMetaDataDTO.setTaxReduction(this.createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum.TAXREDUCTION));
        draftMetaDataDTO.setRollOut(this.createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum.ROLLOUT));
        draftMetaDataDTO.setDeduction(this.createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum.DEDUCTION));
        return draftMetaDataDTO;
    }

    @Override
    public DraftMetaDataInfo createDraftMetaDataInfo(NssbXgmnsrDraftMetaDataEnum draftMetaDataEnum) {
        return new DraftMetaDataInfo(draftMetaDataEnum.getAccountMetaDataName(), draftMetaDataEnum.getDetailMetaDataNameMap());
    }
}

