/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.metadata.handler.xgmnsr.sjjt;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.taxc.tcvat.business.service.draft.metadata.AbstractDraftMetaDataHandler;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.draft.metadata.handler.xgmnsr.sjjt.SjjtXgmnsrDraftMetaDataEnum;

public class SjjtXgmnsrDraftMetaDataHandler
extends AbstractDraftMetaDataHandler<SjjtXgmnsrDraftMetaDataEnum> {
    private Map<String, DraftMetaDataDTO> cacheMap = new ConcurrentHashMap<String, DraftMetaDataDTO>();

    @Override
    public DraftMetaDataDTO handler(String draftPurpose, String taxPayerType) {
        if ("zzsxgmnsr".equals(taxPayerType) && "sjjt".equals(draftPurpose)) {
            if (null != this.cacheMap.get(draftPurpose)) {
                return this.cacheMap.get(draftPurpose);
            }
            this.cacheMap.put(draftPurpose, this.getDraftMetaDataDTO(draftPurpose, taxPayerType));
            return this.cacheMap.get(draftPurpose);
        }
        if (null != this.getNextHandler()) {
            return this.getNextHandler().handler(draftPurpose, taxPayerType);
        }
        return null;
    }

    @Override
    public DraftMetaDataDTO getDraftMetaDataDTO(String draftPurpose, String taxPayerType) {
        DraftMetaDataDTO draftMetaDataDTO = new DraftMetaDataDTO(draftPurpose, taxPayerType);
        draftMetaDataDTO.setTemplateType("draft_zzsxgmnsr_sjjt");
        draftMetaDataDTO.setPolicyConfirm(this.createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum.POLICY_CONFIRM));
        draftMetaDataDTO.setIncome(this.createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum.INCOME));
        draftMetaDataDTO.setDiff(this.createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum.DIFF));
        draftMetaDataDTO.setWaitDeduction(this.createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum.WAITDEDUCTION));
        draftMetaDataDTO.setTaxReduction(this.createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum.TAXREDUCTION));
        draftMetaDataDTO.setRollOut(this.createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum.ROLLOUT));
        draftMetaDataDTO.setDeduction(this.createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum.DEDUCTION));
        return draftMetaDataDTO;
    }

    @Override
    public DraftMetaDataInfo createDraftMetaDataInfo(SjjtXgmnsrDraftMetaDataEnum draftMetaDataEnum) {
        return new DraftMetaDataInfo(draftMetaDataEnum.getAccountMetaDataName(), draftMetaDataEnum.getDetailMetaDataNameMap());
    }
}

