/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.strategy;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public abstract class TcvatStrategy {
    public static final String TAXPAYER_TYPE_KEY = "taxPayerType";
    protected DeductionService deductionService = new DeductionService();
    protected DraftService draftService = new DraftService();

    public Map<String, DeclarePageType> getDeclareMapAndStatusMap() {
        return TaxStepsConstant.getTcvatDraftYbnsr();
    }

    public Boolean propertyChangedCheck(Object value, IPageCache pageCache, IFormView view) {
        return Boolean.FALSE;
    }

    public EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String taxPayerType, IPageCache pageCache, String draftPurpose) {
        TcvatEngineModel engineModel = new TcvatEngineModel(orgId, skssqq, skssqz, taxPayerType, pageCache);
        engineModel.getCustom().put("taxperiod", skssqq.substring(0, 7));
        engineModel.getCustom().put("skssqq", skssqq);
        engineModel.getCustom().put("skssqz", skssqz);
        engineModel.addCustom(TAXPAYER_TYPE_KEY, taxPayerType);
        engineModel.addCustom("taxpayertype", taxPayerType);
        Map<String, Object> cache = TaxDeclareHelper.getTemplateType("draft", orgId, skssqq, skssqz, draftPurpose);
        engineModel.addCustom("templatetype", cache.get("templatetype"));
        int diffMonth = DateUtils.getMonthDiff((Date)DateUtils.stringToDate((String)skssqz), (Date)DateUtils.stringToDate((String)skssqq));
        engineModel.addCustom("deadLine", diffMonth == 0 ? "aysb" : "ajsb");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        Map<String, String> invoiceTypeIdMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        engineModel.addCustom("invoiceTypeIdMap", invoiceTypeIdMap);
        if (null == pageCache) {
            pageCache = new PageCache("");
            pageCache.put(TAXPAYER_TYPE_KEY, taxPayerType);
            DynamicObject dynamicObject = TemplateUtilsOld.getTemplateObjectByConfig((String)taxPayerType, (String)orgId, (Date)DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM-dd"), (Date)DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM-dd"));
            pageCache.put("templateid", null != dynamicObject ? dynamicObject.getString("id") : null);
            pageCache.put("orgid", orgId);
            pageCache.put("deadLine", diffMonth == 0 ? "aysb" : "ajsb");
            pageCache.put("skssqq", skssqq);
            pageCache.put("skssqz", skssqz);
        }
        pageCache.put("draftpurpose", draftPurpose);
        pageCache.put("rulePurpose", draftPurpose);
        engineModel.addCustom("rulePurpose", pageCache.get("rulePurpose"));
        engineModel.addCustom("draftpurpose", pageCache.get("draftpurpose"));
        engineModel.setDraftMetaDataDTO(DraftMetaDataDTO.getMetaData(pageCache.get("draftpurpose"), taxPayerType));
        engineModel.addCustom("customCache", pageCache);
        engineModel.setPageCache(pageCache);
        return engineModel;
    }

    public TcvatEngineModel engineExecute(TcvatEngineModel engineModel) throws InterruptedException, ExecutionException, TimeoutException {
        return null;
    }

    public void insertCheckData(TcvatEngineModel engineModel, String orgId, String startdate, String enddate, String planid) {
        if (orgId == null) {
            return;
        }
    }

    public void calculate(String orgId, String startdate, String enddate, String templateType, IPageCache pageCache) {
    }

    public Boolean validDeductionDraft(DraftDto draftDto) {
        return Boolean.FALSE;
    }

    public void changeZlbData(Map<String, String> sejszlbData, String orgId, String startdate, String enddate, String taxpayerType, String prelevyrate) {
    }

    public Map<String, String> getInvoiceTypeMap() {
        DynamicObject[] invoiceTypeDynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        Map<String, String> invoiceTypeMap = Arrays.stream(invoiceTypeDynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        return invoiceTypeMap;
    }

    public QFilter getDeleteCheckDataFilter(String orgId, String startdate, String enddate, String draftPurpose) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        q1.and(new QFilter("draftpurpose", "=", (Object)draftPurpose));
        return q1.and(this.getSkssqFiler(startdate, enddate));
    }

    public QFilter getSkssqFiler(String startdate, String enddate) {
        Date skssqq = DateUtils.stringToDate((String)startdate);
        QFilter q2 = new QFilter("skssqq", ">=", (Object)skssqq);
        Date skssqz = DateUtils.stringToDate((String)enddate);
        QFilter q3 = new QFilter("skssqz", "<=", (Object)skssqz);
        return q2.and(q3);
    }

    public void saveRepInvoiceData(String orgId, TcvatEngineModel engineModel, Date skssqq, Date skssqz, Map<String, String> invoiceTypeMap, String entityName, Map<String, String> declareTypeMap) {
        Map<String, Map<String, Object>> errorMap = engineModel.getErrorMap();
        ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>(errorMap.size());
        String draftPurpose = engineModel.getDraftMetaDataDTO().getDraftPurpose();
        for (Map<String, Object> objectMap : errorMap.values()) {
            Set rulelist = (Set)objectMap.get("rulelist");
            if (!"invoice".equals((String)objectMap.get("field"))) continue;
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            if (null != declareTypeMap) {
                object.set("declaretype", (Object)declareTypeMap.get(objectMap.get("org").toString()));
                object.set("invoicetype", (Object)invoiceTypeMap.get(objectMap.get("baseinvoicetype").toString()));
                object.set("invoiceorg", objectMap.get("org"));
            }
            object.set("org", (Object)Long.parseLong(orgId));
            object.set("skssqq", (Object)skssqq);
            object.set("skssqz", (Object)skssqz);
            object.set("ruletype", objectMap.get("type"));
            object.set("field", (Object)((String)objectMap.get("field")));
            object.set("name", (Object)String.join((CharSequence)",", rulelist));
            object.set("baseinvoicetype", objectMap.get("baseinvoicetype"));
            object.set("invoicedate", objectMap.get("invoicedate"));
            object.set("goodsname", objectMap.get("goodsname"));
            object.set("goodscode", objectMap.get("goodscode"));
            object.set("invoicecode", objectMap.get("invoicecode"));
            object.set("invoiceno", objectMap.get("invoiceno"));
            object.set("taxrate", objectMap.get("taxrate"));
            object.set("amount", objectMap.get("amount"));
            object.set("taxamount", objectMap.get("taxamount"));
            object.set("total", objectMap.get("total"));
            object.set("draftpurpose", (Object)draftPurpose);
            ruleList.add(object);
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(ruleList));
    }

    public void saveInvoiceNotConfigData(TcvatEngineModel engineModel, String orgId, Set<String> entryIds, Date skssqq, Date skssqz, Map<String, String> invoiceTypeMap, String entityName, Map<String, String> declareTypeMap) {
        List<Long> orglist = null == engineModel.getCustom().get("orglist") ? Collections.singletonList(Long.valueOf(orgId)) : JSON.parseArray((String)engineModel.getCustom().get("orglist").toString(), Long.class).stream().distinct().collect(Collectors.toList());
        QFilter orgFilter = new QFilter("taxorg", "in", orglist).and("issuetime", ">=", (Object)skssqq).and("issuetime", "<=", (Object)skssqz).and("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "3"}));
        String selectFields = "id, orgid as org, issuetime as invoicedate,invoicecode,invoiceno,baseinvoicetype,items.id as entryentity.id ,items.taxrate as entryentity.taxrate,items.amount as entryentity.amount,items.tax as entryentity.taxamount1,items.goodsname as goodsname,items.goodscode as goodscode";
        QFilter and = QFilter.isNotNull((String)"items.goodscode").and("items.goodscode", "!=", (Object)" ").and("items.goodscode", "!=", (Object)"");
        and.or(new QFilter("issuetype", "=", (Object)"1"));
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"TcvatStrategy.sim_vatinvoice", (String)"sim_vatinvoice", (String)selectFields, (QFilter[])new QFilter[]{orgFilter, and}, (String)"invoicetype,items.taxrate");
        selectFields = "id, orgid as org, issuetime as invoicedate,invoicecode,invoiceno, '961641829533496320' as baseinvoicetype, id as entryentity.id ,taxrate as entryentity.taxrate, invoiceamount as entryentity.amount,totaltax as entryentity.taxamount1,'' as goodsname, goodscode";
        DataSet invoiceVehiclesDataSet = QueryServiceHelper.queryDataSet((String)"TcvatStrategy.sim_vatinvoice_vehicles", (String)"sim_vatinvoice_vehicles", (String)selectFields, (QFilter[])new QFilter[]{orgFilter}, (String)"invoicetype");
        HashMap<String, Map<String, Object>> invoiceEntityMap = new HashMap<String, Map<String, Object>>();
        this.getInvoiceMap(invoiceEntityMap, invoiceDataSet, invoiceTypeMap, declareTypeMap, entryIds);
        this.getInvoiceMap(invoiceEntityMap, invoiceVehiclesDataSet, invoiceTypeMap, declareTypeMap, entryIds);
        String draftPurpose = engineModel.getDraftMetaDataDTO().getDraftPurpose();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(invoiceEntityMap.size());
        for (Map value : invoiceEntityMap.values()) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            if (null != declareTypeMap) {
                object.set("declaretype", (Object)declareTypeMap.get(value.get("org").toString()));
                object.set("invoiceorg", value.get("org"));
                object.set("invoicetype", (Object)invoiceTypeMap.get(value.get("baseinvoicetype").toString()));
            }
            object.set("org", (Object)Long.parseLong(orgId));
            object.set("skssqq", (Object)skssqq);
            object.set("skssqz", (Object)skssqz);
            object.set("baseinvoicetype", value.get("baseinvoicetype"));
            object.set("count", value.get("count"));
            object.set("taxrate", value.get("taxrate"));
            object.set("amount", value.get("amount"));
            object.set("taxamount", value.get("taxamount"));
            object.set("total", value.get("total"));
            object.set("invoicedate", value.get("invoicedate"));
            object.set("invoicecode", value.get("invoicecode"));
            object.set("invoiceno", value.get("invoiceno"));
            object.set("goodsname", value.get("goodsname"));
            object.set("goodscode", value.get("goodscode"));
            object.set("draftpurpose", (Object)draftPurpose);
            list.add(object);
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(list));
    }

    private void getInvoiceMap(Map<String, Map<String, Object>> invoiceEntityMap, DataSet dataSet, Map<String, String> invoiceTypeMap, Map<String, String> declareTypeMap, Set<String> entryIds) {
        while (dataSet.hasNext()) {
            Row invoice = dataSet.next();
            String entryentityId = invoice.getString("entryentity.id");
            if (entryIds.contains(entryentityId)) continue;
            HashMap<String, Object> invoicemap = new HashMap<String, Object>();
            if (null != declareTypeMap) {
                invoicemap.put("invoicetype", invoiceTypeMap.get(invoice.getString("baseinvoicetype")));
            }
            invoicemap.put("baseinvoicetype", invoice.getString("baseinvoicetype"));
            invoicemap.put("taxrate", invoice.getString("entryentity.taxrate"));
            invoicemap.put("count", invoicemap.getOrDefault("count", 0) + 1);
            invoicemap.put("amount", invoice.getBigDecimal("entryentity.amount"));
            invoicemap.put("taxamount", invoice.getBigDecimal("entryentity.taxamount1"));
            invoicemap.put("total", invoicemap.getOrDefault("amount", BigDecimal.ZERO).add((BigDecimal)invoicemap.get("taxamount")));
            invoicemap.put("invoicedate", invoice.getDate("invoicedate"));
            invoicemap.put("invoicecode", invoice.get("invoicecode"));
            invoicemap.put("invoiceno", invoice.get("invoiceno"));
            invoicemap.put("org", invoice.get("org"));
            invoicemap.put("goodsname", invoice.get("goodsname"));
            invoicemap.put("goodscode", invoice.get("goodscode"));
            invoiceEntityMap.put(entryentityId, invoicemap);
        }
    }
}

