/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.strategy.impl;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.taxdeclare.DeclarePageType;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.util.YbhzEngineUtils;
import kd.taxc.tcvat.business.service.zlb.YbhzTaxCalculateService;
import kd.taxc.tcvat.business.service.zlb.YbhzZlbCalculateService;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class Ybhzyz3StrategyImpl
extends TcvatStrategy {
    @Override
    public Map<String, DeclarePageType> getDeclareMapAndStatusMap() {
        return TaxStepsConstant.getTcvatYbnsrYBHz();
    }

    @Override
    public Boolean propertyChangedCheck(Object value, IPageCache pageCache, IFormView view) {
        String endDate;
        String startDate;
        Map<String, Object> cache;
        String templatetype;
        boolean result;
        String orgId = pageCache.get("orgid");
        if (value != null) {
            orgId = ((DynamicObject)value).get("id").toString();
        }
        if (result = "draft_zzsybnsr_yz_fzjg".equals(templatetype = (String)(cache = TaxDeclareHelper.getTemplateType("draft", orgId, startDate = pageCache.get("skssqq"), endDate = pageCache.get("skssqz"), "nssb")).get("templatetype"))) {
            view.showConfirm((String)cache.get("taxpayertypemsg"), MessageBoxOptions.OK, ConfirmTypes.Save, null);
        }
        return result;
    }

    @Override
    public EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String taxPayerType, IPageCache pageCache, String draftPurpose) {
        TcvatEngineModel engineModel = (TcvatEngineModel)super.buildEngineModel(orgId, skssqq, skssqz, taxPayerType, pageCache, draftPurpose);
        List<Long> curOrgList = Collections.singletonList(Long.parseLong(orgId));
        pageCache = engineModel.getPageCache();
        Date startDate = DateUtils.stringToDate((String)skssqq);
        Date endDate = DateUtils.stringToDate((String)skssqz);
        DynamicObjectCollection collection = OrgUtils.queryOrgGroupDetailForCollectedOrg((String)"zzs", (String)orgId, (String)skssqz);
        DynamicObject hzplan = OrgUtils.getOrgDeclarePlan((Long)Long.parseLong(orgId), (Date)startDate, (Date)endDate);
        if (hzplan != null) {
            engineModel.addCustom("prelevyrate", hzplan.getString("prelevyrate"));
            pageCache.put("planid", hzplan.getString("id"));
        }
        if (collection.isEmpty()) {
            pageCache.put("declaremap", JSON.toJSONString(new HashMap()));
        } else {
            curOrgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
            Map<String, String> declareMap = collection.stream().collect(Collectors.toMap(o -> o.getString("orgid"), o -> o.getString("levelname"), (k1, k2) -> k1));
            pageCache.put("declaremap", JSON.toJSONString(declareMap));
            engineModel.addCustom("declaremap", declareMap);
        }
        engineModel.addCustom("orglist", curOrgList);
        DraftMetaDataDTO dto = engineModel.getDraftMetaDataDTO();
        DynamicObject confirm = TcvatDraftService.loadPolicyConfirm(dto.getDraftPurpose(), dto.getTaxPayerType(), dto.getTemplateType(), orgId, skssqq, skssqz);
        if (null == confirm) {
            DynamicObject declarePlanObject = OrgUtils.getOrgDeclarePlan((Long)Long.parseLong(orgId), (Date)startDate, (Date)endDate);
            pageCache.put("planid", declarePlanObject.getString("id"));
        } else {
            DynamicObjectCollection list = confirm.getDynamicObjectCollection("entryentity");
            Set hzsbOrgList = list.stream().map(confirmRule -> confirmRule.getLong("suborg.id")).collect(Collectors.toSet());
            for (DynamicObject confirmRule2 : list) {
                boolean nrhzsb = confirmRule2.getBoolean("nrhzsb");
                if (nrhzsb) continue;
                hzsbOrgList.remove(confirmRule2.getLong("suborg.id"));
            }
            engineModel.addCustom("hzsbOrgList", hzsbOrgList);
        }
        engineModel.addCustom("policyconfirmentry", dto.getPolicyConfirm().getAccountMetaDataName());
        engineModel.addCustom("planid", pageCache.get("planid"));
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(curOrgList, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
        engineModel.addCustom("OrgRelationMap", orgRelationMap);
        return engineModel;
    }

    @Override
    public TcvatEngineModel engineExecute(TcvatEngineModel engineModel) throws InterruptedException, ExecutionException, TimeoutException {
        YbhzEngineUtils.execute(RequestContext.getOrCreate(), engineModel);
        return engineModel;
    }

    @Override
    public void insertCheckData(TcvatEngineModel engineModel, String orgId, String startdate, String enddate, String planid) {
        super.insertCheckData(engineModel, orgId, startdate, enddate, planid);
        Map<String, String> invoiceTypeMap = this.getInvoiceTypeMap();
        String draftPurpose = engineModel.getDraftMetaDataDTO().getDraftPurpose();
        QFilter filter = this.getDeleteCheckDataFilter(orgId, startdate, enddate, draftPurpose);
        DeleteServiceHelper.delete((String)"tcvat_checkdata_rule", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"tcvat_checkdata_invoice", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"tcvat_ybnsr_rule_invoice", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection declarePlanObject = QueryServiceHelper.query((String)"tctb_org_group_detail", (String)"orgid, declaration", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(planid))});
        Map<String, String> declareTypeMap = declarePlanObject.stream().collect(Collectors.toMap(k -> k.getString("orgid"), v -> v.getString("declaration"), (k1, k2) -> k1));
        this.saveRepInvoiceData(orgId, engineModel, DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate), invoiceTypeMap, "tcvat_checkdata_rule", declareTypeMap);
        this.saveInvoiceNotConfigData(engineModel, orgId, engineModel.getEntryIds(), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate), invoiceTypeMap, "tcvat_checkdata_invoice", declareTypeMap);
    }

    @Override
    public void calculate(String orgId, String startdate, String enddate, String templateType, IPageCache pageCache) {
        HashMap<String, String> dataMap = new HashMap();
        String zlbsbbTemplateType = templateType;
        pageCache.put("originaltype", templateType);
        if ("draft_zzsybnsr_yz_zjg".equals(templateType)) {
            String draftTemplateType;
            DynamicObject draftData;
            dataMap = FormulaService.query((IPageCache)pageCache, (String)"draft_zzsybnsr_ybhz", (String)orgId, (String)startdate, (String)enddate, (boolean)true);
            zlbsbbTemplateType = "draft_zzsybnsr_ybhz";
            YbhzTaxCalculateService.calculate(dataMap, orgId, startdate, enddate, templateType);
            String taxPayerType = pageCache.get("taxPayerType");
            YbhzZlbCalculateService.calculateYZTaxApportionZlb(dataMap, orgId, startdate, enddate, taxPayerType);
            String draftId = pageCache.get("draftId");
            String draftpurpose = pageCache.get("draftpurpose");
            if (draftId == null && (draftData = TcvatDraftService.queryDraftData(draftpurpose, Collections.singletonList(draftTemplateType = TcvatDraftService.getDraftTemplateType(draftpurpose, taxPayerType)), Long.parseLong(orgId), DateUtils.stringToDate((String)startdate), DateUtils.stringToDate((String)enddate))) != null) {
                draftId = draftData.getString("id");
            }
            YbhzZlbCalculateService.calculateYZEjjgSeftZlb(dataMap, draftId, draftpurpose, orgId, startdate, enddate, taxPayerType);
        } else if ("draft_zzsybnsr_yz_zjg_sjjt".equals(templateType)) {
            dataMap = FormulaService.query((IPageCache)pageCache, (String)"draft_zzsybnsr_ybhz_sjjt", (String)orgId, (String)startdate, (String)enddate, (boolean)true);
            zlbsbbTemplateType = "draft_zzsybnsr_ybhz_sjjt";
        }
        String draftId = pageCache.get("draftId");
        String draftpurpose = pageCache.get("draftpurpose");
        this.draftService.calcDraftRiskInfoHasDraft(draftId, draftpurpose, orgId, startdate, enddate, zlbsbbTemplateType, dataMap, pageCache);
    }

    @Override
    public Boolean validDeductionDraft(DraftDto draftDto) {
        return Boolean.FALSE;
    }
}

