/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.draft.vatrta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import org.apache.commons.collections4.CollectionUtils;

public class VatRtaService {
    public static final String VATRTA_ENTITY = "tcvat_rta_query";

    public List<Long> queryYbnsrOrgIdsWithPerm(long userId, String appid, String entityid) {
        TaxResult result;
        List data;
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)entityid, (String)"47150e89000000ac");
        if (taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)taxResult.getData())) && (result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId((List)data)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
            return ((List)result.getData()).stream().filter(taxMain -> {
                DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
                return CollectionUtils.isNotEmpty((Collection)categoryentryentity) && "ybnsr".equals(((DynamicObject)categoryentryentity.get(0)).getString("taxpayertype")) && "1".equals(((DynamicObject)categoryentryentity.get(0)).getString("enable"));
            }).map(o -> o.getLong("orgid.id")).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Long> querySjjtDraftIds(Long orgId, String templatetype, Date startDate, Date endDate) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter and = new QFilter("org", "=", (Object)orgId).and(new QFilter("templatetype", "=", (Object)templatetype));
        filterList.add(and);
        filterList.add(new QFilter("skssqq", ">=", (Object)startDate).and(new QFilter("skssqz", "<=", (Object)endDate)));
        filterList.add(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)"tcvat_sjjt_draft_query", (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        return draftCollect.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> querySbbIds(Long orgId, String templatetype, Date startDate, Date endDate) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter and = new QFilter("org", "=", (Object)orgId).and(new QFilter("type", "=", (Object)templatetype));
        filterList.add(and);
        filterList.add(new QFilter("skssqq", ">=", (Object)startDate).and(new QFilter("skssqz", "<=", (Object)endDate)));
        filterList.add(new QFilter("declarestatus", "=", (Object)"declared"));
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)"tcvat_zzs_declare_list", (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        return draftCollect.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public List<Long> queryPayRecordIds(Long orgId, String templatetype, Date startDate, Date endDate) {
        List<Long> sbbIds = this.querySbbIds(orgId, templatetype, startDate, endDate);
        QFilter filter = new QFilter("sbbid", "in", (Object)sbbIds.stream().map(Object::toString).toArray());
        DynamicObjectCollection draftCollect = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"id", (QFilter[])new QFilter[]{filter});
        return draftCollect.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObject loadSingleVatRta(Long id) {
        if (id == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)VATRTA_ENTITY);
    }

    public DynamicObject queryOneVatRtaByBillno(String billNo) {
        if (StringUtils.isBlank((CharSequence)billNo)) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)VATRTA_ENTITY, (String)"id,generatebusinessdoc", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
    }

    public ListShowParameter getJointSearchParameter(String entityName, List<Long> linkQueryPkIds, Map<String, Object> customParams) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setBillFormId(entityName);
        for (Long pkId : linkQueryPkIds) {
            showParameter.addLinkQueryPkId((Object)pkId);
        }
        if (customParams != null && !customParams.isEmpty()) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return showParameter;
    }

    public void getLogResultMessage(OperationResult operationResult, StringBuilder successMessage, StringBuilder failMessage) {
        List successPkIds = operationResult.getSuccessPkIds();
        Map billNos = operationResult.getBillNos();
        Set entries = billNos.entrySet();
        for (Map.Entry entry : entries) {
            if (successPkIds.contains(Long.valueOf(entry.getKey().toString()))) {
                if (successMessage.length() > 0) {
                    successMessage.append(" ");
                }
                successMessage.append((String)entry.getValue());
                continue;
            }
            if (failMessage.length() > 0) {
                failMessage.append(" ");
            }
            failMessage.append((String)entry.getValue());
        }
    }

    public ListShowParameter getProvistonBillPageParameter(String appid, String orgId, String taxsystem, String draftBillNo, String taxtype) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        hashMap.put("appid", appid);
        hashMap.put("taxtype.number", taxtype);
        listShowParameter.setCustomParams(hashMap);
        return listShowParameter;
    }

    public String processJtdMsg(OperationResult operationResult, String entityId, String operateName) {
        StringBuilder successMessage = new StringBuilder();
        StringBuilder failMessage = new StringBuilder();
        this.getLogResultMessage(operationResult, successMessage, failMessage);
        StringBuilder resultMessage = new StringBuilder();
        if (failMessage.length() > 0) {
            resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s\u5931\u8d25\u3002", (String)"VatRtaService_0", (String)"taxc-tcvat", (Object[])new Object[0]), failMessage + operateName));
        }
        if (successMessage.length() > 0) {
            resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801: %s\u6210\u529f\u3002", (String)"VatRtaService_1", (String)"taxc-tcvat", (Object[])new Object[0]), successMessage + operateName));
        }
        OperatorDialogUtils.operateDialog((String)"zzs", (String)entityId, (String)operateName, (String)resultMessage.toString());
        return String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"VatRtaService_2", (String)"taxc-tcvat", (Object[])new Object[0]), operateName);
    }
}

