/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.dynamicrow;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.assist.AssistService;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DynamicRowFetchService {
    private static final String YZ_ZLB_EJJGSEFT = "tcvat_zlb_yz_ejjgseft";

    private DynamicRowFetchService() {
    }

    public static List<String> getZsxmList() {
        return Arrays.asList(ResManager.loadKDString((String)"\u57ce\u5e02\u7ef4\u62a4\u5efa\u8bbe\u7a0e", (String)"DynamicRowFetchService_0", (String)"taxc-tcvat", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6559\u80b2\u8d39\u9644\u52a0", (String)"DynamicRowFetchService_1", (String)"taxc-tcvat", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5730\u65b9\u6559\u80b2\u9644\u52a0", (String)"DynamicRowFetchService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
    }

    public static Map<Long, DynamicObject> queryFjsfEnableMap(List<Long> suborgList) {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainFjsfByOrgId(suborgList);
        return ((List)result.getData()).stream().filter(d -> EmptyCheckUtils.isNotEmpty((Object)d.getDynamicObjectCollection("categoryentryentity"))).collect(Collectors.toMap(d -> d.getLong("taxorg.id"), d -> (DynamicObject)d.getDynamicObjectCollection("categoryentryentity").get(0), (m, n) -> m));
    }

    public static DynamicObjectCollection queryZlbJgfpb(String orgId, String startData, String endData) {
        long org = Long.parseLong(orgId);
        Date start = DateUtils.stringToDate((String)startData);
        Date end = DateUtils.stringToDate((String)endData);
        DynamicObject orgDeclarePlan = OrgUtils.getOrgDeclarePlan((Long)org, (Date)start, (Date)end);
        if (null == orgDeclarePlan) {
            return new DynamicObjectCollection();
        }
        Long hzOrgId = orgDeclarePlan.getDynamicObjectCollection("orgrow").stream().filter(o -> "2".equals(o.getString("declaration"))).map(o -> o.getLong("orgid.id")).findFirst().orElse(0L);
        QFilter orgIdFilter = new QFilter("org", "=", (Object)hzOrgId).and(new QFilter("parentid", "=", (Object)org)).and(new QFilter("suborg", "!=", (Object)org));
        QFilter startFilter = new QFilter("startdate", "=", (Object)start);
        QFilter endFilter = new QFilter("enddate", "=", (Object)end);
        return QueryServiceHelper.query((String)YZ_ZLB_EJJGSEFT, (String)"id,org,parentid,levelname,xssr,fpbl,fpse,jzjtfpbl,jzjtfpse,jzjtxssr,ysfwxssr,ysfwfpbl,ysfwfpse,ysfwjzjtxssr,ysfwjzjtfpbl,ysfwjzjtfpse,masterid,suborg,startdate,enddate", (QFilter[])new QFilter[]{orgIdFilter, startFilter, endFilter}, (String)"parentid,levelname");
    }

    public static Map<Long, DynamicObject> queryOrgUnifiedsocialcodeAndTaxpayer(List<Long> orgIds) {
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org, unifiedsocialcode, taxpayer", (QFilter[])new QFilter[]{orgFilter});
        return dynamicObject.stream().collect(Collectors.toMap(o -> o.getLong("org"), o -> o));
    }

    public static String getPolicyParams(String param, String startdate, String enddate, String orgId) {
        List paramList = AssistService.queryAssistParams((String)param, (String)orgId, (String)startdate, (String)enddate);
        if (paramList.size() > 0) {
            return (String)paramList.get(0);
        }
        return "0";
    }
}

