/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IPageCache;
import kd.bos.schedule.executor.AbstractTask;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.impl.DeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.DiffDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.IncomeEngine;
import kd.taxc.tcvat.business.service.engine.impl.PerpreEngine;
import kd.taxc.tcvat.business.service.engine.impl.RollOutEngine;
import kd.taxc.tcvat.business.service.engine.impl.SmallScaleCurrentPaymentEngine;
import kd.taxc.tcvat.business.service.engine.impl.SmallScaleDiffDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.SmallScaleIncomeEngine;
import kd.taxc.tcvat.business.service.engine.impl.SmallScaleTaxReductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.TaxReductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.WaitDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.YbnsrDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.YbnsrJzjtJxseEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.HzDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.HzDiffDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzIncomeEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzJzjtJxseEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzPerpreEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzRollOutEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzTaxReductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz.YbhzWaitDeductionEngine;
import kd.taxc.tcvat.business.service.engine.impl.ybnsr.YbnsrIncomeEngine;
import kd.taxc.tcvat.business.service.taxrefund.engine.AccountRecalcEngine;

public class TcvatEngineModel
extends EngineModel {
    private DraftMetaDataDTO draftMetaDataDTO;
    private Map<String, Map<String, Object>> errorMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private Set<String> entryIds = new HashSet<String>();
    private AbstractTask draftEngineCalcTask;

    public AbstractTask getDraftEngineCalcTask() {
        return this.draftEngineCalcTask;
    }

    public void setDraftEngineCalcTask(AbstractTask draftEngineCalcTask) {
        this.draftEngineCalcTask = draftEngineCalcTask;
    }

    public TcvatEngineModel(String orgId, String startDate, String endDate) {
        super(orgId, startDate, endDate);
    }

    public TcvatEngineModel(String orgId, String startDate, String endDate, String declareType, IPageCache pageCache) {
        super(orgId, startDate, endDate, declareType, pageCache);
    }

    public Map<String, Map<String, Object>> getErrorMap() {
        return this.errorMap;
    }

    public void setErrorMap(Map<String, Map<String, Object>> errorMap) {
        this.errorMap = errorMap;
    }

    public synchronized void addErrorMap(Map<String, Map<String, Object>> errorMap) {
        this.errorMap.putAll(errorMap);
    }

    public Set<String> getEntryIds() {
        return new HashSet<String>(this.entryIds);
    }

    public void setEntryIds(Set<String> entryIds) {
        this.entryIds = new HashSet<String>(entryIds);
    }

    public DraftMetaDataDTO getDraftMetaDataDTO() {
        return this.draftMetaDataDTO;
    }

    public void setDraftMetaDataDTO(DraftMetaDataDTO draftMetaDataDTO) {
        this.draftMetaDataDTO = draftMetaDataDTO;
    }

    public static List<EngineTask<TcvatEngineModel, DynamicObject>[]> getEngineList(String taxPayerType) {
        ArrayList<EngineTask<TcvatEngineModel, DynamicObject>[]> engineTaskList = new ArrayList<EngineTask<TcvatEngineModel, DynamicObject>[]>();
        if ("zzsybnsr".equals(taxPayerType)) {
            engineTaskList.add(new EngineTask[]{new IncomeEngine(), new YbnsrIncomeEngine()});
            engineTaskList.add(new EngineTask[]{new DiffDeductionEngine()});
            engineTaskList.add(new EngineTask[]{new RollOutEngine(), new YbnsrDeductionEngine(), new DeductionEngine(), new YbnsrJzjtJxseEngine(), new WaitDeductionEngine(), new TaxReductionEngine(), new PerpreEngine()});
        }
        if ("zzsybnsr_ybhz".equals(taxPayerType)) {
            engineTaskList.add(new EngineTask[]{new YbhzIncomeEngine(), new HzDiffDeductionEngine(), new YbhzTaxReductionEngine(), new YbhzWaitDeductionEngine()});
            engineTaskList.add(new EngineTask[]{new YbhzRollOutEngine(), new YbhzDeductionEngine(), new HzDeductionEngine(), new YbhzJzjtJxseEngine(), new YbhzPerpreEngine()});
        }
        if ("zzsxgmnsr".equals(taxPayerType)) {
            engineTaskList.add(new EngineTask[]{new SmallScaleIncomeEngine(), new SmallScaleDiffDeductionEngine(), new SmallScaleTaxReductionEngine()});
            engineTaskList.add(new EngineTask[]{new SmallScaleCurrentPaymentEngine()});
        }
        if ("tcvat_taxrefund".equals(taxPayerType)) {
            engineTaskList.add(new EngineTask[]{new AccountRecalcEngine()});
        }
        return engineTaskList;
    }
}

