/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.business.service.account.DeductionService;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.DeductEngineService;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.collections4.CollectionUtils;

public class DeductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(DeductionEngine.class);
    private DeductEngineService deductEngineService = new DeductEngineService();

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fdb\u9879\u62b5\u6263\u5f15\u64ce");
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO dto = model.getDraftMetaDataDTO();
        if ("sjjt".equals(dto.getDraftPurpose())) {
            return null;
        }
        ArrayList<DynamicObject> deductionSummaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> inputPTServicesList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getDeduction());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        DraftEngineEnum.YBNSR.deleteDeduction(model);
        List<String> dateList = TaxDeclarationService.getRealQuarter(dto.getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        String taxPayerType = (String)model.getCustom().get("taxPayerType");
        List ruleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.DEDUCT, (String)taxPayerType.replace("zzs", ""), (String)rulePurpose).get(RuleTypeEnum.DEDUCT);
        Map<String, List<DynamicObject>> deductRuleMap = ruleList.stream().filter(d -> d.getDynamicObject("deducttype").getString("number").startsWith("VAT_JXDK_BQDK") && !DeductionService.DOWN_DEDUCTION.contains(d.getDynamicObject("deducttype").getString("number"))).collect(Collectors.groupingBy(d -> d.getDynamicObject("deducttype").getString("number")));
        LinkedHashMap<String, String> deductTypeMap = this.deductEngineService.getDeductTypeMap();
        DraftMetaDataInfo deduction = dto.getDeduction();
        for (String date : dateList) {
            for (Map.Entry<String, String> entry : deductTypeMap.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                List<DynamicObject> values = deductRuleMap.get(key);
                String uuid = UUID.randomUUID();
                DynamicObject deductionSummary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)deduction.getAccountMetaDataName()));
                BigDecimal countSum = BigDecimal.ZERO;
                BigDecimal amountSum = BigDecimal.ZERO;
                BigDecimal taxSum = BigDecimal.ZERO;
                String ruleName = "";
                if (CollectionUtils.isNotEmpty(values)) {
                    ruleName = values.get(0).getString("name");
                    for (DynamicObject deductRule : values) {
                        countSum = countSum.add(this.getExecuteCalculateTask(model, detailList, uuid, deductRule, "entryentity11", "11", "count", date));
                        amountSum = amountSum.add(this.getExecuteCalculateTask(model, detailList, uuid, deductRule, "entryentity", "", "amount", date));
                        taxSum = taxSum.add(this.getExecuteCalculateTask(model, detailList, uuid, deductRule, "entryentity1", "1", "taxamount", date));
                    }
                }
                this.deductEngineService.buildSummaryObject(model, ruleName, val, uuid, deductionSummary, countSum.longValue(), amountSum, taxSum, date);
                List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, deductionSummary, "deductiontype");
                Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                DraftEditService.updateDraftEditOriginAmount(deductionSummary, rowEditAmountMap, editList);
                DraftEditService.addEditAmount(deductionSummary, rowEditAmountMap);
                deductionSummaryList.add(deductionSummary);
            }
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(deductionSummaryList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(inputPTServicesList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(detailList));
        DraftEditService.updateNewDraftId(deductionSummaryList, oldDraftList, draftEditArr, "deductiontype");
        return null;
    }

    private BigDecimal getExecuteCalculateTask(TcvatEngineModel model, List<DynamicObject> detailList, String uuid, DynamicObject deductRule, String entryentity, String suffix, String type, String date) throws Exception {
        NewRuleSettingTask settingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), deductRule, model, deductRule.getDynamicObjectCollection(entryentity), uuid, model.getDraftMetaDataDTO().getDeduction().getDetailMetaDataNameMap().get(DraftConstant.YBNSR_DEDUCTION_DETAIL_BILL), null, suffix, type, date.substring(0, 7));
        List futureList = ThreadPoolsService.getInstance().submitReturnFuture((Task)settingTask);
        List draftDetailList = DeductionEngine.getFutureList((List)futureList);
        detailList.addAll(draftDetailList);
        return draftDetailList.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

