/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.NewRuleSettingTask;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.collections.CollectionUtils;

public class PerpreEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(PerpreEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u72ec\u7acb\u5206\u6b21\u9884\u7f34\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataInfo perpreDraftMetaData = model.getDraftMetaDataDTO().getPerpre();
        String rulePurpose = (String)model.getCustom().get("rulePurpose");
        String taxpayertype = ((String)model.getCustom().get("taxPayerType")).replace("zzs", "");
        String deadLine = (String)model.getCustom().get("deadLine");
        List rules = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.PERPRE, (String)taxpayertype, (String)rulePurpose).get(RuleTypeEnum.PERPRE);
        List sortedRules = RuleUtils.sortPerpreRules((List)rules);
        if (CollectionUtils.isNotEmpty((Collection)sortedRules)) {
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(sortedRules.size());
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getPerpre());
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            for (String date : dateList) {
                for (DynamicObject rule : sortedRules) {
                    String serialno = UUID.randomUUID();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)perpreDraftMetaData.getAccountMetaDataName());
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    summary.set("ruleid", (Object)rule.getLong("id"));
                    summary.set("serialno", (Object)serialno);
                    summary.set("org", (Object)model.getOrgId());
                    summary.set("bizname", rule.get("name"));
                    summary.set("perpreproject", rule.get("perpreproduct"));
                    summary.set("taxperiod", (Object)date);
                    summary.set("deadline", (Object)deadLine);
                    NewRuleSettingTask ruleSettingTask = new NewRuleSettingTask(new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, perpreDraftMetaData.getDetailMetaDataNameMap().get(DraftConstant.YBNSR_PERPRE_DETAIL), null, "", "currentamount", date);
                    List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                    List accountingList = PerpreEngine.getFutureList((List)futures);
                    summaryAccountingList.addAll(accountingList);
                    BigDecimal accountingamount = IncomeUtils.getAccountingAmount(accountingList);
                    summary.set("currentamount", (Object)accountingamount);
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                    DraftEditService.addEditAmount(summary, rowEditAmountMap);
                    summaryList.add(summary);
                }
            }
            DraftEngineEnum.YBNSR.deletePerpre(model);
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        } else {
            DraftEngineEnum.YBNSR.deletePerpre(model);
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u72ec\u7acb\u5206\u6b21\u9884\u7f34\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }
}

