/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.RuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class RollOutEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(RollOutEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fdb\u9879\u8f6c\u51fa\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataInfo rolloutMetaData = model.getDraftMetaDataDTO().getRollOut();
        String taxpayertype = ((String)model.getCustom().get("taxPayerType")).replace("zzs", "");
        List rules = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.ROLL_OUT, (String)taxpayertype, (String)model.getDraftMetaDataDTO().getDraftPurpose()).get(RuleTypeEnum.ROLL_OUT);
        List sortedRules = RuleUtils.sortRolloutRules((List)rules);
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
        if (sortedRules != null && sortedRules.size() > 0) {
            List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getRollOut());
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
            QFilter periodFilter = new QFilter("taxperiod", "in", dateList);
            QFilter jzjtFlag = new QFilter("jzjt", "=", (Object)"1");
            DynamicObjectCollection incomeDraftJzjtCollection = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"sum(taxamount) as taxamount", (QFilter[])new QFilter[]{orgFilter, periodFilter, jzjtFlag});
            BigDecimal jzjtSum = incomeDraftJzjtCollection.size() > 0 ? ((DynamicObject)incomeDraftJzjtCollection.get(0)).getBigDecimal(0) : new BigDecimal(0);
            DynamicObjectCollection incomeDraftCollection = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"sum(taxamount) as taxamount", (QFilter[])new QFilter[]{orgFilter, periodFilter});
            BigDecimal totalSum = incomeDraftCollection.size() > 0 ? ((DynamicObject)incomeDraftCollection.get(0)).getBigDecimal(0) : new BigDecimal(0);
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            ArrayList<DynamicObject> addJzjtDraftEditList = new ArrayList<DynamicObject>();
            ArrayList<Long> delJzjtDraftEditList = new ArrayList<Long>();
            for (String date : dateList) {
                for (DynamicObject rule : sortedRules) {
                    String jzjtflag = rule.getString("jzjt");
                    String serialno = UUID.randomUUID();
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)rolloutMetaData.getAccountMetaDataName());
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    String rollouttype = rule.getDynamicObject("rollouttype").getString("number");
                    RuleSettingTask ruleSettingTask = new RuleSettingTask(rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, rolloutMetaData.getDetailMetaDataNameMap().get("tcvat_accdetail_rollout"), null, date);
                    List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                    List accountingList = RollOutEngine.getFutureList((List)futures);
                    this.handleJzjtRolloutAmount(jzjtflag, accountingList, jzjtSum, totalSum);
                    summaryAccountingList.addAll(accountingList);
                    this.setCommon(model, accountingList, rule, serialno, rollouttype, summary, date);
                    List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                    Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                    DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                    DraftEditService.addEditAmount(summary, rowEditAmountMap);
                    this.handleJzjtAmountFinal(jzjtflag, summary, editList, addJzjtDraftEditList, delJzjtDraftEditList);
                    summaryList.add(summary);
                }
            }
            DraftEngineEnum.YBNSR.deleteRollOut(model);
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
            if (!CollectionUtils.isEmpty(delJzjtDraftEditList)) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)DraftConstant.TCVAT_DRAFT_EDIT), (Object[])delJzjtDraftEditList.toArray());
            }
            if (!CollectionUtils.isEmpty(addJzjtDraftEditList)) {
                DraftEditService.updateNewDraftId(summaryList, oldDraftList, addJzjtDraftEditList.toArray(new DynamicObject[0]), "ruleid");
            }
        } else {
            DraftEngineEnum.YBNSR.deleteRollOut(model);
        }
        logger.info("\u7ed3\u675f\u6267\u884c\u8fdb\u9879\u8f6c\u51fa\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }

    private void handleJzjtAmountFinal(String jzjtFlag, DynamicObject summary, List<DynamicObject> editList, List<DynamicObject> addJzjtDraftEditList, List<Long> delJzjtDraftEditList) {
        if ("1".equals(jzjtFlag)) {
            BigDecimal jzjtrolloutamount;
            BigDecimal accountingamount = summary.getBigDecimal("accountingamount");
            if (!accountingamount.equals(jzjtrolloutamount = summary.getBigDecimal("jzjtrolloutamount"))) {
                List<DynamicObject> rowEditList = editList.stream().filter(e -> "accountingamount".equals(e.getString("rowcode"))).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(rowEditList)) {
                    return;
                }
                ArrayList newRowEditList = new ArrayList(rowEditList.size());
                rowEditList.forEach(r -> {
                    DynamicObject t = BusinessDataServiceHelper.newDynamicObject((String)r.getDataEntityType().getName());
                    BeanCopyUtils.copyDynamicObjectWithoutEntityid((DynamicObject)r, (DynamicObject)t);
                    t.set("rowcode", (Object)"jzjtrolloutamount");
                    newRowEditList.add(t);
                });
                addJzjtDraftEditList.addAll(newRowEditList);
                summary.set("jzjtrolloutamount", (Object)accountingamount);
            }
        } else if ("0".equals(jzjtFlag)) {
            summary.set("jzjtrolloutamount", (Object)0);
            List rowEditIdList = editList.stream().filter(e -> "jzjtrolloutamount".equals(e.getString("rowcode"))).map(e -> e.getLong("id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(rowEditIdList)) {
                return;
            }
            delJzjtDraftEditList.addAll(rowEditIdList);
        }
    }

    private void setCommon(EngineModel model, List<DynamicObject> accountingList, DynamicObject rule, String serialno, String rollouttype, DynamicObject dynamicObject, String taxperiod) {
        dynamicObject.set("serialno", (Object)serialno);
        dynamicObject.set("org", (Object)model.getOrgId());
        dynamicObject.set("taxperiod", (Object)taxperiod);
        if (model.getCustom().get("rulePurpose").equals("sjjt")) {
            dynamicObject.set("taxperioddate", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate2((String)taxperiod, (String)"yyyy-MM")));
        }
        dynamicObject.set("ruleid", rule.get("id"));
        dynamicObject.set("rollouttype", (Object)rollouttype);
        dynamicObject.set("description", (Object)rule.getString("name"));
        dynamicObject.set("jzjt", (Object)rule.getString("jzjt"));
        BigDecimal accountingamount = this.getTotalAmount(accountingList, "amount");
        BigDecimal jzjtRolloutAmount = this.getTotalAmount(accountingList, "jzjtrolloutamount");
        dynamicObject.set("accountingamount", (Object)accountingamount);
        dynamicObject.set("jzjtrolloutamount", (Object)jzjtRolloutAmount);
        Object deadLine = model.getCustom().get("deadLine");
        dynamicObject.set("deadline", deadLine);
    }

    private BigDecimal getTotalAmount(List<DynamicObject> list, String fieldName) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (list != null) {
            for (DynamicObject invoice : list) {
                totalAmount = totalAmount.add(invoice.getBigDecimal(fieldName));
            }
        }
        return totalAmount;
    }

    private void handleJzjtRolloutAmount(String jzjt, List<DynamicObject> accountingList, BigDecimal jzjtIncomeAccountSum, BigDecimal incomeAccountSum) {
        for (DynamicObject t : accountingList) {
            if (StringUtils.equals((CharSequence)"2", (CharSequence)jzjt)) {
                t.set("jzjtxse", (Object)jzjtIncomeAccountSum);
                t.set("xsehe", (Object)incomeAccountSum);
                if (incomeAccountSum.intValue() == 0) {
                    t.set("hfbl", (Object)0);
                    t.set("jzjtrolloutamount", (Object)0);
                    continue;
                }
                t.set("hfbl", (Object)jzjtIncomeAccountSum.divide(incomeAccountSum, 4, 4));
                t.set("jzjtrolloutamount", (Object)t.getBigDecimal("amount").multiply(t.getBigDecimal("hfbl")));
                continue;
            }
            if (StringUtils.equals((CharSequence)"1", (CharSequence)jzjt)) {
                t.set("jzjtxse", (Object)0);
                t.set("xsehe", (Object)0);
                t.set("hfbl", (Object)0);
                t.set("jzjtrolloutamount", (Object)t.getBigDecimal("amount"));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)jzjt)) continue;
            t.set("jzjtxse", (Object)0);
            t.set("xsehe", (Object)0);
            t.set("hfbl", (Object)0);
            t.set("jzjtrolloutamount", (Object)0);
        }
    }
}

