/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.hzsb.NewHzRuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.collections.CollectionUtils;

public class HzDiffDeductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(HzDiffDeductionEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u5dee\u989d\u6263\u9664\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        DraftMetaDataInfo diff = draftMetaDataDTO.getDiff();
        String summaryEntity = diff.getAccountMetaDataName();
        Map<String, String> detailMap = diff.getDetailMetaDataNameMap();
        String rulePurpose = draftMetaDataDTO.getDraftPurpose();
        String taxPayerType = draftMetaDataDTO.getTaxPayerType();
        Object hzsbOrgList = model.getCustom().get("hzsbOrgList");
        String orglistStr = !CollectionUtils.isEmpty((Collection)((Collection)hzsbOrgList)) ? hzsbOrgList.toString() : model.getCustom().get("orglist").toString();
        Map declareMap = (Map)model.getCustom().get("declaremap");
        List orglist = JSON.parseArray((String)orglistStr, Long.class);
        orglist = orglist.stream().distinct().collect(Collectors.toList());
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getDiff());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        for (Long suborgid : orglist) {
            List rules = (List)RuleUtils.getSharingAndOrgRules((Long)suborgid, (RuleTypeEnum)RuleTypeEnum.DIFF, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.DIFF);
            List sortedRules = RuleUtils.sortDiffRules((List)rules);
            if (!CollectionUtils.isNotEmpty((Collection)sortedRules)) continue;
            String levelName = (String)declareMap.get(suborgid.toString());
            String declaretype = "1".equals(levelName) ? "2" : "1";
            for (DynamicObject rule : sortedRules) {
                String diffType = rule.getDynamicObject("difftype").getString("number");
                String serialno = UUID.randomUUID();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)summaryEntity);
                DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                summary.set("serialno", (Object)serialno);
                summary.set("rowno", rule.getDynamicObject("difftype").get("number"));
                summary.set("org", (Object)model.getOrgId());
                summary.set("suborg", (Object)suborgid);
                summary.set("levelname", (Object)levelName);
                summary.set("declaretype", (Object)declaretype);
                summary.set("project", rule.get("name"));
                if (summary.containsProperty("ruleid")) {
                    summary.set("ruleid", (Object)rule.getLong("id"));
                }
                summary.set("difftype", rule.get("difftype"));
                summary.set("deductiontype", rule.get("deductiontype"));
                summary.set("startdate", (Object)DateUtils.stringToDate((String)model.getStartDate()));
                summary.set("enddate", (Object)DateUtils.stringToDate((String)model.getEndDate()));
                summary.set("taxpayertype", (Object)taxPayerType);
                summary.set("jzjt", rule.get("jzjt"));
                NewHzRuleSettingTask ruleSettingTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(1), suborgid, new ConcurrentHashMap<String, Map<String, Object>>(1), rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, detailMap.get(DraftConstant.YBHZ_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "", "currentamount");
                List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                List accountingList = HzDiffDeductionEngine.getFutureList((List)futures);
                summaryAccountingList.addAll(accountingList);
                BigDecimal accountingamount = IncomeUtils.getAccountingAmount(accountingList);
                summary.set("currentamount", (Object)accountingamount);
                if ("ybnsr".equals(rule.getString("taxpayertype")) && !rule.getBoolean("qzkce")) {
                    NewHzRuleSettingTask deductRuleSettingTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(1), suborgid, new ConcurrentHashMap<String, Map<String, Object>>(1), rule, model, rule.getDynamicObjectCollection("entryentity1"), serialno, detailMap.get(DraftConstant.YBHZ_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "1", "deductamount");
                    List deductFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)deductRuleSettingTask);
                    List deductAccountingList = HzDiffDeductionEngine.getFutureList((List)deductFutures);
                    summaryAccountingList.addAll(deductAccountingList);
                    BigDecimal deductAccountingAmount = IncomeUtils.getAccountingAmount(deductAccountingList);
                    summary.set("deductamount", (Object)deductAccountingAmount);
                } else if ("ybnsr".equals(rule.getString("taxpayertype")) && rule.getBoolean("qzkce")) {
                    NewHzRuleSettingTask ruleSettingTask2 = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(1), suborgid, new ConcurrentHashMap<String, Map<String, Object>>(1), rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, detailMap.get(DraftConstant.YBHZ_DIFF_DETAIL), IncomeUtils.getDiffRates().get(diffType), "", "deductamount");
                    List futures2 = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask2);
                    List accountingList2 = HzDiffDeductionEngine.getFutureList((List)futures2);
                    summaryAccountingList.addAll(accountingList2);
                    BigDecimal accountingamount2 = IncomeUtils.getAccountingAmount(accountingList2);
                    summary.set("deductamount", (Object)accountingamount2);
                }
                List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                DraftEditService.addEditAmount(summary, rowEditAmountMap);
                summaryList.add(summary);
            }
        }
        DraftEngineEnum.YBHZ.deleteDiff(model);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
        DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        logger.info("\u7ed3\u675f\u6267\u884c\u5dee\u989d\u6263\u9664\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }
}

