/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.IAccountEngine;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import org.apache.commons.lang.StringUtils;

public class YbhzAddDeductionEngine
implements IAccountEngine<TcvatEngineModel> {
    private static Log logger = LogFactory.getLog(YbhzAddDeductionEngine.class);
    private static final String ORGID_KEY = "orgid";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String ROLLOUTTYPE_10 = "10";
    private static final String ROLLOUTTYPE_11 = "11";

    public void execute(TcvatEngineModel model) {
        logger.info("\u5f00\u59cb\u6267\u884c\u8fdb\u9879\u7a0e\u989d\u52a0\u8ba1\u62b5\u51cf\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        this.insertData(model, model.getOrgId(), DateUtils.stringToDate((String)model.getStartDate()), DateUtils.stringToDate((String)model.getEndDate()));
        logger.info("\u7ed3\u675f\u6267\u884c\u8fdb\u9879\u7a0e\u989d\u52a0\u8ba1\u62b5\u51cf\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
    }

    public void insertData(TcvatEngineModel model, String orgId, Date startdate, Date enddate) {
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        String deductionEntity = draftMetaDataDTO.getDeduction().getAccountMetaDataName();
        String jzjtjxseEntity = draftMetaDataDTO.getJzjtjxse().getAccountMetaDataName();
        String rollOutEntity = draftMetaDataDTO.getRollOut().getAccountMetaDataName();
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter taxPeriodFilter = new QFilter(START_DATE, "=", (Object)startdate).and(new QFilter(END_DATE, "=", (Object)enddate));
        QFilter payerTypeFilter = new QFilter("taxpayertype", "=", model.getCustom().get("taxPayerType"));
        DynamicObjectCollection deductionSummary = QueryServiceHelper.query((String)deductionEntity, (String)"deductiontype,taxamount,inputtaxamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, payerTypeFilter});
        DynamicObjectCollection rollOutSummary = QueryServiceHelper.query((String)rollOutEntity, (String)"jzjt,rollouttype,accountingamount,jzjtrolloutamount", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, payerTypeFilter});
        DynamicObjectCollection jzjtjxseSummary = QueryServiceHelper.query((String)jzjtjxseEntity, (String)"jzjtjxtax,jzjtlx,suborg,declaretype", (QFilter[])new QFilter[]{orgFilter, taxPeriodFilter, payerTypeFilter});
        Set<Map.Entry<String, String>> entries = this.getAddDeductRow().entrySet();
        Iterator<Map.Entry<String, String>> it = entries.iterator();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(entries.size());
        String deductionRate = this.getDeductionRate(model, orgId, startdate, enddate);
        while (it.hasNext()) {
            Map.Entry<String, String> map = it.next();
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)draftMetaDataDTO.getAddDeduction().getAccountMetaDataName());
            entity.set("org", (Object)orgId);
            entity.set("servicetype", (Object)map.getValue());
            entity.set("currentamount", (Object)this.getCurrentAmount(deductionRate, deductionSummary, jzjtjxseSummary, map.getKey()));
            entity.set("currentdecrease", (Object)this.getCurrentDecreaseAmount(deductionRate, rollOutSummary, map.getKey()));
            entity.set("taxpayertype", model.getCustom().get("taxPayerType"));
            entity.set("rowno", (Object)map.getKey());
            entity.set(START_DATE, (Object)startdate);
            entity.set(END_DATE, (Object)enddate);
            result.add(entity);
        }
        try (TXHandle h = TX.required();){
            try {
                DraftEngineEnum.YBHZ.deleteAddDeduction(model);
                SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }

    private String getDeductionRate(TcvatEngineModel model, String orgId, Date startdate, Date enddate) {
        QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgId));
        QFilter taxperiodFilter = new QFilter(START_DATE, ">=", (Object)DateUtils.getDayFirst((Date)startdate)).and(new QFilter(END_DATE, "<=", (Object)DateUtils.getDayLast((Date)enddate)));
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)model.getDraftMetaDataDTO().getDraftPurpose());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)model.getDraftMetaDataDTO().getPolicyConfirm().getAccountMetaDataName(), (String)"deductionrate", (QFilter[])new QFilter[]{orgFilter, taxperiodFilter, draftPurposeFilter});
        return "N".equals(dynamicObject.getString("deductionrate")) ? "0" : BigDecimalUtil.divideObject((Object)BigDecimalUtil.toBigDecimal((Object)dynamicObject.getString("deductionrate").replace("%", "")), (Object)100, (int)2).toPlainString();
    }

    private BigDecimal getCurrentAmount(String deductionRate, DynamicObjectCollection list, DynamicObjectCollection jzjtjxseSummarys, String key) {
        BigDecimal totalTaxAmoumt = BigDecimal.ZERO;
        BigDecimal totalInputTaxAmount = BigDecimal.ZERO;
        if (StringUtils.isEmpty((String)deductionRate)) {
            return BigDecimal.ZERO;
        }
        for (DynamicObject object : list) {
            totalTaxAmoumt = totalTaxAmoumt.add(object.getBigDecimal("taxamount"));
        }
        for (DynamicObject object : jzjtjxseSummarys) {
            totalInputTaxAmount = totalInputTaxAmount.add(object.getBigDecimal("jzjtjxtax"));
        }
        if ("1".equals(key)) {
            return BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)totalTaxAmoumt, (Object)totalInputTaxAmount), (Object)new BigDecimal(deductionRate), (int)2, (int)4);
        }
        return BigDecimalUtil.multiplyObject((Object)totalInputTaxAmount, (Object)new BigDecimal(deductionRate), (int)2, (int)4);
    }

    private BigDecimal getCurrentDecreaseAmount(String deductionRate, DynamicObjectCollection list, String key) {
        BigDecimal totalTaxAmoumt = BigDecimal.ZERO;
        BigDecimal jzjtTotalRolloutAmount = BigDecimal.ZERO;
        if (StringUtils.isEmpty((String)deductionRate)) {
            return BigDecimal.ZERO;
        }
        for (DynamicObject object : list) {
            String jzjt = object.getString("jzjt");
            String rollouttype = object.getString("rollouttype");
            if (!ROLLOUTTYPE_10.equals(rollouttype) && !ROLLOUTTYPE_11.equals(rollouttype)) {
                totalTaxAmoumt = totalTaxAmoumt.add(object.getBigDecimal("accountingamount"));
            }
            if (!"1".equals(jzjt) && !"2".equals(jzjt)) continue;
            jzjtTotalRolloutAmount = jzjtTotalRolloutAmount.add(object.getBigDecimal("jzjtrolloutamount"));
        }
        if ("1".equals(key)) {
            return BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.subtractObject((Object)totalTaxAmoumt, (Object)jzjtTotalRolloutAmount), (Object)new BigDecimal(deductionRate), (int)2, (int)4);
        }
        return BigDecimalUtil.multiplyObject((Object)jzjtTotalRolloutAmount, (Object)new BigDecimal(deductionRate), (int)2, (int)4);
    }

    public Map<String, String> getAddDeductRow() {
        return new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("1", ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e\u9879\u76ee", (String)"YbhzAddDeductionEngine_0", (String)"taxc-tcvat", (Object[])new Object[0]));
                this.put("2", ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000\u9879\u76ee", (String)"YbhzAddDeductionEngine_1", (String)"taxc-tcvat", (Object[])new Object[0]));
            }
        };
    }
}

