/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.service.JzjtJxseEngineService;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.hzsb.NewHzRuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class YbhzJzjtJxseEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbhzJzjtJxseEngine.class);
    private JzjtJxseEngineService engineService = new JzjtJxseEngineService();

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5f15\u64ce");
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        this.calcData(model);
        return null;
    }

    public void calcData(TcvatEngineModel model) throws Exception {
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, draftMetaDataDTO.getJzjtjxse());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        DraftEngineEnum.YBHZ.deleteJzjtJxse(model);
        DraftMetaDataInfo deductionMetaData = draftMetaDataDTO.getJzjtjxse();
        String rulePurpose = draftMetaDataDTO.getDraftPurpose();
        Object taxPayerType = model.getCustom().get("taxPayerType");
        Long orgid = Long.parseLong(model.getOrgId());
        List<Object> orglist = new ArrayList<Long>();
        if ("zzsybnsr_ybhz".equals(taxPayerType) || "zzsybnsr_hz_zjg".equals(taxPayerType) || "zzsybnsr_yz_zjg".equals(taxPayerType)) {
            String orglistStr = model.getCustom().get("orglist").toString();
            orglist = JSON.parseArray((String)orglistStr, Long.class).stream().distinct().collect(Collectors.toList());
        } else {
            orglist.add(Long.parseLong(model.getOrgId()));
        }
        if (orglist.isEmpty()) {
            return;
        }
        DynamicObject dynamicObject = TcvatDraftService.loadPolicyConfirm(draftMetaDataDTO.getDraftPurpose(), draftMetaDataDTO.getTaxPayerType(), draftMetaDataDTO.getTemplateType(), model.getOrgId(), model.getStartDate(), model.getEndDate());
        if (dynamicObject == null) {
            return;
        }
        DynamicObjectCollection hzPlanCollection = dynamicObject.getDynamicObjectCollection("hzentryentity");
        Map<String, String> orgToLeveMap = hzPlanCollection.stream().collect(Collectors.toMap(k -> k.getDynamicObject("assignorg").getString("id"), v -> v.getString("levelname"), (k1, k2) -> k1));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(model.getOrgId()));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        QFilter dateFilter = new QFilter("startdate", "=", (Object)startDate).and(new QFilter("enddate", "=", (Object)endDate));
        QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", model.getCustom().get("taxpayertype"));
        DynamicObjectCollection incomeAccountCollection = QueryServiceHelper.query((String)model.getDraftMetaDataDTO().getIncome().getAccountMetaDataName(), (String)"startdate,taxamount,jzjt,nrjzjtjs,suborg", (QFilter[])new QFilter[]{orgFilter.and(dateFilter), taxpayertypeFilter});
        Map jzjttsclBatch = SystemParamUtil.getAppParameterBatch((String)"tcvat", (String)"jzjttscl", orglist);
        int splitRateScale = TaxDeclarationService.getJzjtJxseSplitRateScale(orgid);
        Map<String, BigDecimal> resultMap = this.engineService.getHzIncomePeriodAmount(incomeAccountCollection, jzjttsclBatch, splitRateScale);
        BigDecimal jzjtSellAmount = resultMap.get("jzjtSellAmount");
        BigDecimal totalSellAmount = resultMap.get("totalSellAmount");
        BigDecimal splitRate = resultMap.get("splitRate");
        Set<Object> skipSuborg = new HashSet();
        if ("zzsybnsr_ybhz".equals(taxPayerType)) {
            DynamicObjectCollection srEntryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            skipSuborg = srEntryentity.stream().filter(a -> !a.getBoolean("nrhzsb")).map(a -> a.getLong("suborg.id")).collect(Collectors.toSet());
        }
        for (Long l : orglist) {
            if (skipSuborg.contains(l)) continue;
            List ruleList = (List)RuleUtils.getSharingAndOrgRules((Long)l, (RuleTypeEnum)RuleTypeEnum.JZJTSE, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.JZJTSE);
            for (DynamicObject rule : ruleList) {
                String uuid = UUID.randomUUID();
                DynamicObject summary = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)deductionMetaData.getAccountMetaDataName()));
                String jzjtlx = rule.getString("jzjtlx");
                BigDecimal inputTax = this.getExecuteCalculateTask(l, model, detailList, uuid, rule, jzjtlx);
                summary.set("org", (Object)orgid);
                summary.set("serialno", (Object)uuid);
                summary.set("ruleid", rule.get("id"));
                summary.set("bizname", (Object)rule.getString("name"));
                summary.set("jzjtlx", (Object)jzjtlx);
                summary.set("inputtax", (Object)inputTax);
                if ("wfhf".equals(jzjtlx)) {
                    summary.set("jzjtamount", (Object)jzjtSellAmount);
                    summary.set("amountsum", (Object)totalSellAmount);
                    summary.set("splitrate", (Object)splitRate);
                }
                summary.set("suborg", (Object)l);
                String level = orgToLeveMap.get(l.toString());
                summary.set("levelname", (Object)level);
                summary.set("declaretype", (Object)("1".equals(level) ? "2" : "1"));
                summary.set("startdate", (Object)DateUtils.stringToDate((String)model.getStartDate()));
                summary.set("enddate", (Object)DateUtils.stringToDate((String)model.getEndDate()));
                summary.set("taxpayertype", taxPayerType);
                List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                DraftEditService.addEditAmount(summary, rowEditAmountMap);
                inputTax = summary.getBigDecimal("inputtax");
                this.engineService.calcJzjtjxTax(summary, inputTax);
                summaryList.add(summary);
            }
        }
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(detailList));
        DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
    }

    private BigDecimal getExecuteCalculateTask(Long suborgid, TcvatEngineModel model, List<DynamicObject> detailList, String uuid, DynamicObject rule, String jzjtlx) throws Exception {
        String entryentity = "entryentity";
        String suffix = "";
        if ("wfhf".equals(jzjtlx)) {
            entryentity = "entryentity1";
            suffix = "1";
        }
        String meta = model.getDraftMetaDataDTO().getJzjtjxse().getDetailMetaDataNameMap().get(DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL);
        NewHzRuleSettingTask settingTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(1), suborgid, new ConcurrentHashMap<String, Map<String, Object>>(1), rule, model, rule.getDynamicObjectCollection(entryentity), uuid, meta, null, suffix, null);
        List futureList = ThreadPoolsService.getInstance().submitReturnFuture((Task)settingTask);
        List draftDetailList = YbhzJzjtJxseEngine.getFutureList((List)futureList);
        detailList.addAll(draftDetailList);
        BigDecimal resultSum = draftDetailList.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return resultSum;
    }
}

