/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.hzsb.NewHzRuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.collections.CollectionUtils;

public class YbhzPerpreEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbhzPerpreEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u6c47\u603b\u5206\u6b21\u9884\u7f34\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        DraftMetaDataInfo perpre = draftMetaDataDTO.getPerpre();
        String summaryEntity = perpre.getAccountMetaDataName();
        Map<String, String> detailMap = perpre.getDetailMetaDataNameMap();
        String rulePurpose = draftMetaDataDTO.getDraftPurpose();
        String taxPayerType = draftMetaDataDTO.getTaxPayerType();
        Object hzsbOrgList = model.getCustom().get("hzsbOrgList");
        String orglistStr = !CollectionUtils.isEmpty((Collection)((Collection)hzsbOrgList)) ? hzsbOrgList.toString() : model.getCustom().get("orglist").toString();
        Map declareMap = (Map)model.getCustom().get("declaremap");
        List orglist = JSON.parseArray((String)orglistStr, Long.class);
        orglist = orglist.stream().distinct().collect(Collectors.toList());
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getPerpre());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        for (Long suborgid : orglist) {
            List rules = (List)RuleUtils.getSharingAndOrgRules((Long)suborgid, (RuleTypeEnum)RuleTypeEnum.PERPRE, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.PERPRE);
            List sortedRules = RuleUtils.sortPerpreRules((List)rules);
            if (!CollectionUtils.isNotEmpty((Collection)sortedRules)) continue;
            String levelName = (String)declareMap.get(suborgid.toString());
            String declaretype = "1".equals(levelName) ? "2" : "1";
            for (DynamicObject rule : sortedRules) {
                String serialno = UUID.randomUUID();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)summaryEntity);
                DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                summary.set("serialno", (Object)serialno);
                if (summary.containsProperty("ruleid")) {
                    summary.set("ruleid", (Object)rule.getLong("id"));
                }
                summary.set("org", (Object)model.getOrgId());
                summary.set("suborg", (Object)suborgid);
                summary.set("levelname", (Object)levelName);
                summary.set("declaretype", (Object)declaretype);
                summary.set("bizname", rule.get("name"));
                summary.set("perpreproject", rule.get("perpreproduct"));
                summary.set("startdate", (Object)DateUtils.stringToDate((String)model.getStartDate()));
                summary.set("enddate", (Object)DateUtils.stringToDate((String)model.getEndDate()));
                summary.set("taxpayertype", (Object)taxPayerType);
                NewHzRuleSettingTask ruleSettingTask = new NewHzRuleSettingTask(new ConcurrentHashMap<String, String>(), suborgid, new ConcurrentHashMap<String, Map<String, Object>>(), rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, detailMap.get(DraftConstant.YBHZ_PERPRE_DET), null, "", "currentamount");
                List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                List accountingList = YbhzPerpreEngine.getFutureList((List)futures);
                summaryAccountingList.addAll(accountingList);
                BigDecimal accountingamount = IncomeUtils.getAccountingAmount(accountingList);
                summary.set("currentamount", (Object)accountingamount);
                List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                DraftEditService.addEditAmount(summary, rowEditAmountMap);
                summaryList.add(summary);
            }
        }
        DraftEngineEnum.YBHZ.deletePerpre(model);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
        DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        logger.info("\u7ed3\u675f\u6267\u884c\u6c47\u603b\u5206\u6b21\u9884\u7f34\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }
}

