/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.hzsb.ybhz;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.impl.utils.ReductionUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.hzsb.HzRuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;
import org.apache.commons.collections.CollectionUtils;

public class YbhzTaxReductionEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbhzTaxReductionEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884c\u51cf\u514d\u7a0e\u53f0\u8d26\u5f15\u64ce");
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        DraftMetaDataInfo taxReduction = draftMetaDataDTO.getTaxReduction();
        String summaryEntity = taxReduction.getAccountMetaDataName();
        Map<String, String> detailMap = taxReduction.getDetailMetaDataNameMap();
        String rulePurpose = draftMetaDataDTO.getDraftPurpose();
        String taxPayerType = draftMetaDataDTO.getTaxPayerType();
        Date lastMonthLastDay = DateUtils.stringToDate((String)model.getEndDate());
        Date lastMonthFirstDay = DateUtils.stringToDate((String)model.getStartDate());
        Object hzsbOrgList = model.getCustom().get("hzsbOrgList");
        String orglistStr = !CollectionUtils.isEmpty((Collection)((Collection)hzsbOrgList)) ? hzsbOrgList.toString() : model.getCustom().get("orglist").toString();
        List orglist = JSON.parseArray((String)orglistStr, Long.class);
        orglist = orglist.stream().distinct().collect(Collectors.toList());
        Map suborgDeclarationMap = (Map)model.getCustom().get("declaremap");
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
        DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getTaxReduction());
        DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
        for (Long suborgid : orglist) {
            List rules = (List)RuleUtils.getSharingAndOrgRules((Long)suborgid, (RuleTypeEnum)RuleTypeEnum.REDUCE, (String)"ybnsr", (String)rulePurpose).get(RuleTypeEnum.REDUCE);
            if (rules == null || rules.size() <= 0) continue;
            for (DynamicObject rule : rules) {
                String serialno = UUID.randomUUID();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)summaryEntity);
                DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                HzRuleSettingTask ruleSettingTask = new HzRuleSettingTask(suborgid, suborgDeclarationMap, rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, detailMap.get(DraftConstant.YBHZ_TAX_REDUCTION_DETAIL), null, true);
                List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                List accountingList = YbhzTaxReductionEngine.getFutureList((List)futures);
                summaryAccountingList.addAll(accountingList);
                this.setCommon(suborgid, suborgDeclarationMap, model, accountingList, rule, serialno, summary);
                summary.set("startdate", (Object)lastMonthFirstDay);
                summary.set("enddate", (Object)lastMonthLastDay);
                List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
                Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
                DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
                DraftEditService.addEditAmount(summary, rowEditAmountMap);
                summaryList.add(summary);
            }
        }
        DraftEngineEnum.YBHZ.deleteTaxReduce(model);
        List<DynamicObject> groupSummaryDataList = ReductionUtils.groupSummaryData(taxPayerType, model, summaryList);
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
        ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
        DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        logger.info("\u7ed3\u675f\u6267\u884c\u51cf\u514d\u7a0e\u53f0\u8d26\u5f15\u64ce\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return null;
    }

    public void setCommon(Long suborgid, Map<String, String> suborgDeclarationMap, EngineModel model, List<DynamicObject> accountingList, DynamicObject rule, String serialno, DynamicObject dynamicObject) {
        String levename = suborgDeclarationMap.get(String.valueOf(suborgid));
        dynamicObject.set("serialno", (Object)serialno);
        dynamicObject.set("org", (Object)model.getOrgId());
        dynamicObject.set("suborg", (Object)suborgid);
        dynamicObject.set("declaretype", (Object)("1".equals(levename) ? "2" : "3"));
        dynamicObject.set("levelname", (Object)levename);
        dynamicObject.set("description", (Object)rule.getString("name"));
        dynamicObject.set("ruleid", rule.get("id"));
        dynamicObject.set("taxreductionid", rule.getDynamicObject("deductiontype").get("id"));
        dynamicObject.set("taxreductioncode", rule.getDynamicObject("deductiontype").get("number"));
        dynamicObject.set("taxreductionname", (Object)rule.getDynamicObject("deductiontype").getString("name"));
        dynamicObject.set("taxreductiontype", (Object)rule.getString("reductiontype"));
        BigDecimal totalAmount = IncomeUtils.getInvoiceTotalAmount(accountingList, "amount");
        dynamicObject.set("currentamount", (Object)totalAmount);
        dynamicObject.set("creater", (Object)RequestContext.get().getUserId());
        dynamicObject.set("createdate", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        dynamicObject.set("modifydate", (Object)new Date());
        dynamicObject.set("deadline", model.getCustom().get("deadLine"));
        dynamicObject.set("taxpayertype", model.getCustom().get("taxPayerType"));
    }
}

