/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.constant.DraftConstant;

public class IncomeUtils {
    private static final Map<String, String> diff_rates = new HashMap<String, String>();
    private static final String FIELD_SEPARATER = "|";

    public static Map<String, String> getDiffRates() {
        return diff_rates;
    }

    public static List<DynamicObject> groupSummaryData(String type, TcvatEngineModel model, List<DynamicObject> summaryOriginalList) {
        ArrayList<DynamicObject> summaryGroupList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>();
        if (summaryOriginalList.size() > 0) {
            for (DynamicObject dynamicObject : summaryOriginalList) {
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)dynamicObject.getString("taxreductiontype"))) continue;
                summaryGroupList.add(dynamicObject);
            }
            if (summaryGroupList.size() > 0) {
                String serialno = ((DynamicObject)summaryGroupList.get(0)).getString("serialno");
                HashMap currentDataMap = new HashMap(summaryGroupList.size());
                for (DynamicObject dynamicObject : summaryGroupList) {
                    List<DynamicObject> collection;
                    String code = dynamicObject.getString("taxreductioncode");
                    String name = dynamicObject.getString("taxreductionname");
                    Long id = dynamicObject.getLong("taxreductionid");
                    String uniqueKey = id + FIELD_SEPARATER + code + FIELD_SEPARATER + name;
                    if (null != currentDataMap.get(uniqueKey) && ((List)currentDataMap.get(uniqueKey)).size() > 0) {
                        collection = (List)currentDataMap.get(uniqueKey);
                        collection.add(dynamicObject);
                        currentDataMap.put(uniqueKey, collection);
                        continue;
                    }
                    collection = new ArrayList<DynamicObject>();
                    collection.add(dynamicObject);
                    currentDataMap.put(uniqueKey, collection);
                }
                int index = 4;
                for (Map.Entry entry : currentDataMap.entrySet()) {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)model.getDraftMetaDataDTO().getIncome().getDetailMetaDataNameMap().get("tcvat_taxdeduce_sum"));
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    summary.set("serialno", (Object)serialno);
                    String key = (String)entry.getKey();
                    String[] strings = key.split("\\|");
                    BigDecimal currentTotalAmount = BigDecimal.ZERO;
                    for (DynamicObject dyo : (List)entry.getValue()) {
                        String property = "taxamount";
                        if ("SmallScaleIncomeEngine".equals(type)) {
                            property = "totalinvoiceamount";
                        }
                        currentTotalAmount = currentTotalAmount.add(dyo.getBigDecimal(property));
                    }
                    if (currentTotalAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    summary.set("mzzzsxmxse", (Object)currentTotalAmount);
                    summary.set("creater", (Object)RequestContext.get().getUserId());
                    summary.set("createdate", (Object)new Date());
                    summary.set("modifier", (Object)RequestContext.get().getUserId());
                    summary.set("modifydate", (Object)new Date());
                    summary.set("ewbhxh", (Object)index);
                    summary.set("taxreductionid", (Object)Long.parseLong(strings[0]));
                    summary.set("taxreductioncode", (Object)strings[1]);
                    summary.set("taxreductionname", (Object)strings[2]);
                    summary.set("uniquekey", (Object)(strings[1] + FIELD_SEPARATER + strings[2]));
                    summary.set("org", (Object)model.getOrgId());
                    summary.set("taxperiod", model.getCustom().get("taxperiod"));
                    if ("SmallScaleIncomeEngine".equals(type) || "IncomeEngine".equals(type)) {
                        summary.set("taxperiod", (Object)model.getStartDate().substring(0, 7));
                        summary.set("deadline", model.getCustom().get("deadLine"));
                    }
                    summaryGroupDataList.add(summary);
                    ++index;
                }
            }
        }
        return summaryGroupDataList;
    }

    public static List<DynamicObject> groupSummaryData(Long orgid, TcvatEngineModel model, List<DynamicObject> summaryOriginalList) {
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        Map<String, String> incomeSummaryDetailMap = draftMetaDataDTO.getIncome().getDetailMetaDataNameMap();
        ArrayList<DynamicObject> summaryGroupList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> summaryGroupDataList = new ArrayList<DynamicObject>();
        if (summaryOriginalList.size() > 0) {
            for (DynamicObject dynamicObject : summaryOriginalList) {
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)dynamicObject.getString("taxreductiontype"))) continue;
                summaryGroupList.add(dynamicObject);
            }
            if (summaryGroupList.size() > 0) {
                String serialno = ((DynamicObject)summaryGroupList.get(0)).getString("serialno");
                HashMap currentDataMap = new HashMap(summaryGroupList.size());
                for (DynamicObject dynamicObject : summaryGroupList) {
                    List<DynamicObject> collection;
                    String code = dynamicObject.getString("taxreductioncode");
                    String name = dynamicObject.getString("taxreductionname");
                    Long id = dynamicObject.getLong("taxreductionid");
                    String uniqueKey = id + FIELD_SEPARATER + code + FIELD_SEPARATER + name;
                    if (null != currentDataMap.get(uniqueKey) && ((List)currentDataMap.get(uniqueKey)).size() > 0) {
                        collection = (List)currentDataMap.get(uniqueKey);
                        collection.add(dynamicObject);
                        currentDataMap.put(uniqueKey, collection);
                        continue;
                    }
                    collection = new ArrayList<DynamicObject>();
                    collection.add(dynamicObject);
                    currentDataMap.put(uniqueKey, collection);
                }
                int index = 4;
                for (Map.Entry entry : currentDataMap.entrySet()) {
                    MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)incomeSummaryDetailMap.get(DraftConstant.YBHZ_HZ_TAX_DEDUCTION_SUM));
                    DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                    summary.set("serialno", (Object)serialno);
                    String key = (String)entry.getKey();
                    String[] strings = key.split("\\|");
                    BigDecimal currentTotalAmount = BigDecimal.ZERO;
                    for (DynamicObject dyo : (List)entry.getValue()) {
                        currentTotalAmount = currentTotalAmount.add(dyo.getBigDecimal("taxamount"));
                    }
                    if (currentTotalAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    summary.set("mzzzsxmxse", (Object)currentTotalAmount);
                    summary.set("creater", (Object)RequestContext.get().getUserId());
                    summary.set("createdate", (Object)new Date());
                    summary.set("modifier", (Object)RequestContext.get().getUserId());
                    summary.set("modifydate", (Object)new Date());
                    summary.set("ewbhxh", (Object)index);
                    summary.set("taxreductionid", (Object)Long.parseLong(strings[0]));
                    summary.set("taxreductioncode", (Object)strings[1]);
                    summary.set("taxreductionname", (Object)strings[2]);
                    summary.set("uniquekey", (Object)(strings[1] + FIELD_SEPARATER + strings[2]));
                    summary.set("org", (Object)model.getOrgId());
                    summary.set("startdate", (Object)DateUtils.stringToDate((String)model.getStartDate()));
                    summary.set("enddate", (Object)DateUtils.stringToDate((String)model.getEndDate()));
                    summary.set("taxpayertype", model.getCustom().get("taxPayerType"));
                    summaryGroupDataList.add(summary);
                    ++index;
                }
            }
        }
        return summaryGroupDataList;
    }

    public static BigDecimal getAccountingAmount(List<DynamicObject> accountingList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : accountingList) {
            totalAmount = totalAmount.add(invoice.getBigDecimal("amount"));
        }
        return totalAmount;
    }

    public static BigDecimal getAccountingTaxAmount(List<DynamicObject> accountingList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : accountingList) {
            totalAmount = totalAmount.add(invoice.getBigDecimal("taxamount"));
        }
        return totalAmount;
    }

    public static BigDecimal getInvoiceTotalAmount(List<DynamicObject> invoiceList, String propertyName) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject invoice : invoiceList) {
            totalAmount = totalAmount.add(invoice.getBigDecimal(propertyName));
        }
        return totalAmount;
    }

    public static DynamicObject getIncomeRule(Long incomeid, List<DynamicObject> rules) {
        if (rules == null || rules.size() == 0) {
            return null;
        }
        for (DynamicObject rule : rules) {
            if (!rule.getPkValue().equals(incomeid)) continue;
            return rule;
        }
        return null;
    }

    public static DynamicObject createAccountDetailDynamicObject(String entity, Map<String, Object> amountMap, String taxaccountserialno, EngineModel model, String taxperiod, String skssqq, String skssqz, DynamicObject rule, DynamicObject setting, String suffix, String type) {
        DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        object.set("org", (Object)Long.parseLong(model.getOrgId()));
        boolean isZyfp = "invoiceentity".equalsIgnoreCase(setting.getDynamicObjectType().getName());
        if (null != object.getDataEntityType().getProperties().get((Object)"bizname")) {
            object.set("bizname", isZyfp ? setting.get("invoicebizname") : setting.get("bizname" + suffix));
        }
        if (null != object.getDataEntityType().getProperties().get((Object)"differenceinvoice") && setting.containsProperty("differenceinvoice" + suffix)) {
            object.set("differenceinvoice", setting.get("differenceinvoice" + suffix));
        }
        DynamicObject table = setting.getDynamicObject("table" + suffix);
        object.set("table", (Object)table.getLong("id"));
        object.set("amountfield", (Object)setting.getDynamicObject("amountfield" + suffix).getLong("id"));
        object.set("datatype", setting.get("datatype" + suffix));
        object.set("datadirection", setting.get("datadirection" + suffix));
        object.set("filtercondition", isZyfp ? setting.get("invoicefiltercondition") : setting.get("filtercondition" + suffix));
        object.set("conditionjson", isZyfp ? setting.get("invoiceconditionjson") : setting.get("conditionjson" + suffix));
        object.set("absolute", (Object)setting.getBoolean("absolute" + suffix));
        object.set("type", (Object)type);
        object.set("accountorg", amountMap.get("accountorg") != null ? amountMap.get("accountorg") : Long.valueOf(0L));
        object.set("bizdimensiontype", amountMap.get("bizdimensiontype") != null ? amountMap.get("bizdimensiontype") : "");
        object.set("bizdimensionname", amountMap.get("bizdimensionname") != null ? amountMap.get("bizdimensionname") : "");
        object.set("bizdimensionid", amountMap.get("bizdimensionid") != null ? amountMap.get("bizdimensionid") : "");
        object.set("taxaccountserialno", (Object)taxaccountserialno);
        taxperiod = taxperiod == null ? model.getStartDate() : taxperiod;
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        Date lastDayOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        if (DraftConstant.YBNSR_INCOME_INVOICE_DETAIL.equals(entity)) {
            object.set("taxperiod", (Object)taxperiod);
        } else {
            object.set("skssqq", (Object)firstDayOfMonth);
            object.set("skssqz", (Object)lastDayOfMonth);
        }
        return object;
    }

    static {
        diff_rates.put("VAT_CEKCLX_001", "13%");
        diff_rates.put("VAT_CEKCLX_002", "9%");
        diff_rates.put("VAT_CEKCLX_003", "6%");
        diff_rates.put("VAT_CEKCLX_004", "6%");
        diff_rates.put("VAT_CEKCLX_005", "5%");
        diff_rates.put("VAT_CEKCLX_006", "3%");
    }
}

