/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataInfo;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.common.constant.DraftConstant;

public class ReductionUtils {
    private static final String FIELD_SEPARATER = "|";
    private static final String PAGE_FZ_TAX_REDUCETION_SUM = "tcvat_fz_taxreduce_sum";
    private static final String TCVAT_YBNSR_JSXM = "tcvat_ybnsr_jsxm";

    public static List<DynamicObject> groupSummaryData(String templateType, TcvatEngineModel model, List<DynamicObject> summaryList) {
        ArrayList<DynamicObject> summaryGroupList = new ArrayList<DynamicObject>();
        DraftMetaDataInfo taxReductionMetaData = model.getDraftMetaDataDTO().getTaxReduction();
        Map<String, String> detailMap = taxReductionMetaData.getDetailMetaDataNameMap();
        if (summaryList.size() > 0) {
            String serialno = summaryList.get(0).getString("serialno");
            HashMap currentDataMap = new HashMap(summaryList.size());
            for (DynamicObject dynamicObject : summaryList) {
                List<DynamicObject> collection;
                String code = dynamicObject.getString("taxreductioncode");
                String name = dynamicObject.getString("taxreductionname");
                Long id = dynamicObject.getLong("taxreductionid");
                String uniqueKey = id + FIELD_SEPARATER + code + FIELD_SEPARATER + name;
                if (null != currentDataMap.get(uniqueKey) && ((List)currentDataMap.get(uniqueKey)).size() > 0) {
                    collection = (List)currentDataMap.get(uniqueKey);
                    collection.add(dynamicObject);
                    currentDataMap.put(uniqueKey, collection);
                    continue;
                }
                collection = new ArrayList<DynamicObject>();
                collection.add(dynamicObject);
                currentDataMap.put(uniqueKey, collection);
            }
            int index = 2;
            for (Map.Entry entry : currentDataMap.entrySet()) {
                QFilter keyFilter;
                Long sbbid;
                QFilter idFilter;
                DynamicObject jsxmData;
                DynamicObject lastData;
                Map<String, Date> mapDate;
                List<String> list;
                MainEntityType entityType = "zzsybnsr_zjg".equals(templateType) || "zzsybnsr_ybhz".equals(templateType) || "zzsybnsr_hz_zjg".equals(templateType) || "zzsybnsr_yz_zjg".equals(templateType) ? EntityMetadataCache.getDataEntityType((String)detailMap.get(DraftConstant.YBHZ_TAX_REDUCETION_SUM)) : ("zzsybnsr_fzjg".equals(templateType) ? EntityMetadataCache.getDataEntityType((String)PAGE_FZ_TAX_REDUCETION_SUM) : EntityMetadataCache.getDataEntityType((String)detailMap.get("tcvat_taxreduce_sum")));
                DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                summary.set("serialno", (Object)serialno);
                String key = (String)entry.getKey();
                String[] strings = key.split("\\|");
                String uniqueKey = strings[1] + FIELD_SEPARATER + strings[2];
                Long swsxdmId = Long.parseLong(strings[0]);
                BigDecimal currentTotalAmount = BigDecimal.ZERO;
                BigDecimal qcye = BigDecimal.ZERO;
                for (DynamicObject dyo : (List)entry.getValue()) {
                    currentTotalAmount = currentTotalAmount.add(dyo.getBigDecimal("currentamount"));
                }
                if ("zzsxgmnsr".equals(templateType)) {
                    list = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
                    mapDate = PeriodService.preTaxPeriod(model.getOrgId(), DateUtils.stringToDate((String)(list.get(0) + "-01")));
                    lastData = YbnsrService.queryYbnsr((String)model.getOrgId(), (String)"zzsxgmnsr", (String)DateUtils.format((Date)mapDate.get("startDate")), (String)DateUtils.format((Date)mapDate.get("endDate")), (int)0, null);
                    summary.set("taxperiod", (Object)model.getStartDate().substring(0, 7));
                } else {
                    if ("zzsybnsr_zjg".equals(templateType) || "zzsybnsr_ybhz".equals(templateType)) {
                        summary.set("taxpayertype", model.getCustom().get("taxPayerType"));
                    }
                    if ("zzsybnsr_zjg".equals(templateType) || "zzsybnsr_ybhz".equals(templateType) || "zzsybnsr_hz_zjg".equals(templateType) || "zzsybnsr_fzjg".equals(templateType) || "zzsybnsr_yz_zjg".equals(templateType)) {
                        summary.set("startdate", (Object)DateUtils.stringToDate((String)model.getStartDate()));
                        summary.set("enddate", (Object)DateUtils.stringToDate((String)model.getEndDate()));
                        if (summary.containsProperty("taxpayertype")) {
                            summary.set("taxpayertype", (Object)templateType);
                        }
                    } else {
                        summary.set("taxperiod", model.getCustom().get("taxperiod"));
                    }
                    if ("zzsybnsr".equals(templateType)) {
                        list = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
                        mapDate = PeriodService.preTaxPeriod(model.getOrgId(), DateUtils.stringToDate((String)(list.get(0) + "-01")));
                        lastData = YbnsrService.queryYbnsr((String)model.getOrgId(), (String)templateType, (String)DateUtils.format((Date)mapDate.get("startDate")), (String)DateUtils.format((Date)mapDate.get("endDate")), (int)0, null);
                    } else {
                        lastData = YbnsrService.queryYbnsr((String)model.getOrgId(), (String)templateType, (String)model.getStartDate(), (String)model.getEndDate(), (int)-1, null);
                    }
                }
                if (null != lastData && null != (jsxmData = QueryServiceHelper.queryOne((String)TCVAT_YBNSR_JSXM, (String)"id,qmye", (QFilter[])new QFilter[]{idFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbid = Long.valueOf(lastData.getLong("id")))), keyFilter = new QFilter("swsxdmjsmsextval", "=", (Object)uniqueKey).or(new QFilter("swsxdm", "=", (Object)swsxdmId))}))) {
                    qcye = jsxmData.getBigDecimal("qmye");
                }
                if (qcye.compareTo(BigDecimal.ZERO) == 0 && currentTotalAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                summary.set("qcye", (Object)qcye);
                summary.set("bqfse", (Object)currentTotalAmount);
                BigDecimal bqydjse = qcye.add(currentTotalAmount);
                summary.set("bqydjse", (Object)bqydjse);
                summary.set("creater", (Object)RequestContext.get().getUserId());
                summary.set("createdate", (Object)new Date());
                summary.set("modifier", (Object)RequestContext.get().getUserId());
                summary.set("modifydate", (Object)new Date());
                summary.set("ewbhxh", (Object)index);
                summary.set("taxreductionid", (Object)swsxdmId);
                summary.set("taxreductioncode", (Object)strings[1]);
                summary.set("taxreductionname", (Object)strings[2]);
                summary.set("uniquekey", (Object)uniqueKey);
                summary.set("org", (Object)model.getOrgId());
                summary.set("deadline", model.getCustom().get("deadLine"));
                summaryGroupList.add(summary);
                ++index;
            }
        }
        return summaryGroupList;
    }

    public static void setCommon(EngineModel model, List<DynamicObject> accountingList, DynamicObject rule, String serialno, DynamicObject dynamicObject) {
        dynamicObject.set("serialno", (Object)serialno);
        dynamicObject.set("org", (Object)model.getOrgId());
        dynamicObject.set("description", (Object)rule.getString("name"));
        dynamicObject.set("ruleid", rule.get("id"));
        dynamicObject.set("taxreductionid", rule.getDynamicObject("deductiontype").get("id"));
        dynamicObject.set("taxreductioncode", rule.getDynamicObject("deductiontype").get("number"));
        dynamicObject.set("taxreductionname", (Object)rule.getDynamicObject("deductiontype").getString("name"));
        dynamicObject.set("taxreductiontype", (Object)rule.getString("reductiontype"));
        BigDecimal totalAmount = IncomeUtils.getInvoiceTotalAmount(accountingList, "amount");
        dynamicObject.set("currentamount", (Object)totalAmount);
        dynamicObject.set("creater", (Object)RequestContext.get().getUserId());
        dynamicObject.set("createdate", (Object)new Date());
        dynamicObject.set("modifier", (Object)RequestContext.get().getUserId());
        dynamicObject.set("modifydate", (Object)new Date());
        dynamicObject.set("deadline", model.getCustom().get("deadLine"));
        dynamicObject.set("taxpayertype", model.getCustom().get("taxPayerType"));
    }
}

