/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.impl.ybnsr;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.constant.TaxRateConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineTask;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.draft.TaxDeclarationService;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.engine.impl.service.DraftEditService;
import kd.taxc.tcvat.business.service.engine.impl.utils.IncomeUtils;
import kd.taxc.tcvat.business.service.engine.task.PartitionSaveTask;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.ybnsr.YbnsrNewRuleSettingTask;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import kd.taxc.tcvat.common.enums.DraftEngineEnum;
import kd.taxc.tcvat.common.util.UUID;

public class YbnsrIncomeEngine
extends EngineTask<TcvatEngineModel, DynamicObject> {
    private static Log logger = LogFactory.getLog(YbnsrIncomeEngine.class);

    protected DynamicObject execute() throws Exception {
        logger.info("{}\u5f00\u59cb\u6267\u884c\u5206\u7ef4\u5ea6\u6536\u5165\u5f15\u64ce", (Object)RequestContext.get().getRequestId());
        long start = System.currentTimeMillis();
        TcvatEngineModel model = (TcvatEngineModel)this.getEngineModel();
        DraftMetaDataDTO draftMetaDataDTO = model.getDraftMetaDataDTO();
        String policyConfirm = draftMetaDataDTO.getPolicyConfirm().getAccountMetaDataName();
        String incomeSummary = draftMetaDataDTO.getIncome().getAccountMetaDataName();
        Map<String, String> incomeSummaryDetailMap = draftMetaDataDTO.getIncome().getDetailMetaDataNameMap();
        String orgId = model.getOrgId();
        String ruleAndDraftPurpose = draftMetaDataDTO.getDraftPurpose();
        Object deadLine = model.getCustom().get("deadLine");
        String taxPayerType = (String)model.getCustom().get("taxPayerType");
        Date lastMonthLastDay = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)model.getEndDate()));
        Date lastMonthFirstDay = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)model.getStartDate()));
        DynamicObject provisionSharePlanObj = DeclareServiceHelper.queryOneProvisionPlan(Collections.singletonList(Long.valueOf(orgId)), (Date)DateUtils.stringToDate((String)model.getEndDate()), (Date)DateUtils.stringToDate((String)model.getEndDate()), (Long)1L, (Long)1L, (String)ruleAndDraftPurpose);
        if (null == provisionSharePlanObj) {
            return null;
        }
        QFilter orgidFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        QFilter reportPeriodFilter = new QFilter("reportperiod", ">=", (Object)lastMonthFirstDay).and(new QFilter("reportperiod", "<=", (Object)lastMonthLastDay));
        QFilter taxPayerTypeFilter = new QFilter("taxplayeraptitude", "=", (Object)taxPayerType);
        QFilter draftPurposeFilter = new QFilter("draftpurpose", "=", (Object)model.getDraftMetaDataDTO().getDraftPurpose());
        DynamicObject[] dynamicObjectAry = BusinessDataServiceHelper.load((String)policyConfirm, (String)"ruledata_tag", (QFilter[])new QFilter[]{orgidFilter, reportPeriodFilter, taxPayerTypeFilter, draftPurposeFilter});
        DynamicObject dynamicObject = new DynamicObject();
        if (dynamicObjectAry != null && dynamicObjectAry.length > 0) {
            dynamicObject = dynamicObjectAry[0];
        }
        logger.info("\u6536\u5165\u5f15\u64ce\u6761\u4ef6orgidFilter:" + JsonUtil.toJson((Object)orgidFilter) + "reportPeriodFilter" + JsonUtil.toJson((Object)reportPeriodFilter));
        String ruledata_tag = dynamicObject.getString("ruledata_tag");
        JSONObject object = JSONObject.parseObject((String)ruledata_tag);
        JSONArray incomerules = null;
        if (object != null) {
            incomerules = object.getJSONArray(RuleTypeEnum.INCOME.name());
        }
        List incomeRuleList = (List)RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.INCOME, (String)taxPayerType.replace("zzs", ""), (String)ruleAndDraftPurpose).get(RuleTypeEnum.INCOME);
        if (incomerules != null && incomerules.size() > 0) {
            ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> summaryAccountingList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> summaryInvoiceList = new ArrayList<DynamicObject>();
            ConcurrentHashMap<String, String> allInvoiceItemIdBeUsedByIncomeRuleXseMap = new ConcurrentHashMap<String, String>(16);
            ConcurrentHashMap<String, String> allInvoiceItemIdBeUsedByIncomeRuleSeMap = new ConcurrentHashMap<String, String>(16);
            ConcurrentHashMap<String, Map<String, Object>> repeatInvoiceDataMap = new ConcurrentHashMap<String, Map<String, Object>>(16);
            List<String> dateList = TaxDeclarationService.getRealQuarter(model.getDraftMetaDataDTO().getDraftPurpose(), model.getOrgId(), (String)model.getCustom().get("skssqq"), (String)model.getCustom().get("skssqz"));
            DynamicObjectCollection oldDraftList = DraftEditService.getDraftList(model, model.getDraftMetaDataDTO().getIncome());
            DynamicObject[] draftEditArr = DraftEditService.getDraftEditList(oldDraftList);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)incomeSummary);
            String serialno = UUID.randomUUID();
            for (String date : dateList) {
                HashMap<String, String> dimensionMap = new HashMap<String, String>(64);
                for (int i = 0; i < incomerules.size(); ++i) {
                    Map<String, List<DynamicObject>> wkpTaxDetailMap;
                    List<DynamicObject> wkpTaxList;
                    Map<String, List<DynamicObject>> otherTaxDetailMap;
                    List<DynamicObject> otherTaxList;
                    Map<String, List<DynamicObject>> specialTaxDetailMap;
                    List<DynamicObject> invoiceTaxList;
                    BigDecimal accountingamount;
                    dimensionMap.clear();
                    JSONObject incomerule = incomerules.getJSONObject(i);
                    DynamicObject rule = IncomeUtils.getIncomeRule(incomerule.getLong("id"), incomeRuleList);
                    if (rule == null) continue;
                    String taxrate = incomerule.getJSONObject("taxrate").getJSONObject("name").getString("zh_CN");
                    taxrate = NewRuleSettingUtils.trimTaxRate(taxrate);
                    BigDecimal taxrateBig = new BigDecimal(taxrate.replaceAll("%", "")).divide(NewRuleSettingUtils.ONE_HUNDRED);
                    boolean invoiceseqs = rule.getBoolean("invoiceseqs");
                    boolean qtfpseqs = rule.getBoolean("qtfpseqs");
                    boolean wkpseqs = rule.getBoolean("wkpseqs");
                    YbnsrNewRuleSettingTask invoiceTask = new YbnsrNewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("invoiceentity"), serialno, incomeSummaryDetailMap.get("tcvat_income_invoice"), taxrate, "12", RuleSettingConstant.GET_DATE_TYPE_ZYSR, date);
                    List invoiceFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)invoiceTask);
                    YbnsrNewRuleSettingTask otherInvoiceTask = new YbnsrNewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity1"), serialno, incomeSummaryDetailMap.get("tcvat_accdetail_income"), taxrate, "1", RuleSettingConstant.GET_DATE_TYPE_QTSR, date);
                    List otherFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)otherInvoiceTask);
                    YbnsrNewRuleSettingTask ruleSettingTask = new YbnsrNewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleXseMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity"), serialno, incomeSummaryDetailMap.get("tcvat_accdetail_income"), taxrate, "", RuleSettingConstant.GET_DATE_TYPE_WKPSR, date);
                    List futures = ThreadPoolsService.getInstance().submitReturnFuture((Task)ruleSettingTask);
                    List invoiceTaxFutures = null;
                    if (invoiceseqs) {
                        YbnsrNewRuleSettingTask invoiceTaxTask = new YbnsrNewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity2"), serialno, incomeSummaryDetailMap.get("tcvat_income_invoice"), taxrate, "2", RuleSettingConstant.GET_DATE_TYPE_ZYSE, date);
                        invoiceTaxFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)invoiceTaxTask);
                    }
                    List otherTaxFutures = null;
                    if (qtfpseqs) {
                        YbnsrNewRuleSettingTask otherInvoiceTaxTask = new YbnsrNewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity11"), serialno, incomeSummaryDetailMap.get("tcvat_accdetail_income"), taxrate, "11", RuleSettingConstant.GET_DATE_TYPE_QTSE, date);
                        otherTaxFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)otherInvoiceTaxTask);
                    }
                    List wkpseFutures = null;
                    if (wkpseqs) {
                        YbnsrNewRuleSettingTask wkpseTask = new YbnsrNewRuleSettingTask(allInvoiceItemIdBeUsedByIncomeRuleSeMap, repeatInvoiceDataMap, rule, model, rule.getDynamicObjectCollection("entryentity3"), serialno, incomeSummaryDetailMap.get("tcvat_accdetail_income"), taxrate, "3", RuleSettingConstant.GET_DATE_TYPE_WKPSE, date);
                        wkpseFutures = ThreadPoolsService.getInstance().submitReturnFuture((Task)wkpseTask);
                    }
                    List invoiceList = YbnsrIncomeEngine.getFutureList((List)invoiceFutures);
                    Map<String, List<DynamicObject>> salesAmountDetailMap = this.groupByAccountOrgAndDimension(invoiceList, dimensionMap);
                    summaryInvoiceList.addAll(invoiceList);
                    List otherAccountingList = YbnsrIncomeEngine.getFutureList((List)otherFutures);
                    Map<String, List<DynamicObject>> otherSalesAmountDetailMap = this.groupByAccountOrgAndDimension(otherAccountingList, dimensionMap);
                    summaryAccountingList.addAll(otherAccountingList);
                    List accountingList = YbnsrIncomeEngine.getFutureList((List)futures);
                    Map<String, List<DynamicObject>> wkpSalesAmountDetailMap = this.groupByAccountOrgAndDimension(accountingList, dimensionMap);
                    summaryAccountingList.addAll(accountingList);
                    BigDecimal initaccountingamount = accountingamount = IncomeUtils.getAccountingAmount(accountingList);
                    if (invoiceseqs && invoiceTaxFutures != null) {
                        invoiceTaxList = YbnsrIncomeEngine.getFutureList((List)invoiceTaxFutures);
                        summaryInvoiceList.addAll(invoiceTaxList);
                        if (EmptyCheckUtils.isNotEmpty(invoiceTaxList)) {
                            invoiceTaxList.forEach(a -> a.set("taxamount", a.get("invoiceamount")));
                        }
                        specialTaxDetailMap = this.groupByAccountOrgAndDimension(invoiceTaxList, dimensionMap);
                    } else {
                        invoiceTaxList = NewRuleSettingUtils.buildTaxDetail(invoiceList, taxrateBig, DraftConstant.YBNSR_INCOME_INVOICE_DETAIL, RuleSettingConstant.GET_DATE_TYPE_ZYSE);
                        specialTaxDetailMap = this.groupByAccountOrgAndDimension(invoiceTaxList, dimensionMap);
                        summaryInvoiceList.addAll(invoiceTaxList);
                    }
                    if (qtfpseqs && otherTaxFutures != null) {
                        otherTaxList = YbnsrIncomeEngine.getFutureList((List)otherTaxFutures);
                        summaryAccountingList.addAll(otherTaxList);
                        if (EmptyCheckUtils.isNotEmpty(otherTaxList)) {
                            otherTaxList.forEach(a -> a.set("taxamount", a.get("amount")));
                        }
                        otherTaxDetailMap = this.groupByAccountOrgAndDimension(otherTaxList, dimensionMap);
                    } else {
                        otherTaxList = NewRuleSettingUtils.buildTaxDetail(otherAccountingList, taxrateBig, DraftConstant.YBNSR_INCOME_DETAIL, RuleSettingConstant.GET_DATE_TYPE_QTSE);
                        otherTaxDetailMap = this.groupByAccountOrgAndDimension(otherTaxList, dimensionMap);
                        summaryAccountingList.addAll(otherTaxList);
                    }
                    if (wkpseqs && wkpseFutures != null) {
                        wkpTaxList = YbnsrIncomeEngine.getFutureList((List)wkpseFutures);
                        summaryAccountingList.addAll(wkpTaxList);
                        if (EmptyCheckUtils.isNotEmpty(wkpTaxList)) {
                            wkpTaxList.forEach(a -> a.set("taxamount", a.get("amount")));
                        }
                        wkpTaxDetailMap = this.groupByAccountOrgAndDimension(wkpTaxList, dimensionMap);
                    } else {
                        wkpTaxList = NewRuleSettingUtils.buildTaxDetail(accountingList, taxrateBig, DraftConstant.YBNSR_INCOME_DETAIL, RuleSettingConstant.GET_DATE_TYPE_WKPSE);
                        wkpTaxDetailMap = this.groupByAccountOrgAndDimension(wkpTaxList, dimensionMap);
                        summaryAccountingList.addAll(wkpTaxList);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.info("salesAmountDetailMap:{}", (Object)SerializationUtils.toJsonString(salesAmountDetailMap));
                        logger.info("otherSalesAmountDetailMap:{}", (Object)SerializationUtils.toJsonString(otherSalesAmountDetailMap));
                        logger.info("wkpSalesAmountDetailMap:{}", (Object)SerializationUtils.toJsonString(wkpSalesAmountDetailMap));
                        logger.info("specialTaxDetailMap:{}", (Object)SerializationUtils.toJsonString(specialTaxDetailMap));
                        logger.info("otherTaxDetailMap:{}", (Object)SerializationUtils.toJsonString(otherTaxDetailMap));
                        logger.info("wkpTaxDetailMap:{}", (Object)SerializationUtils.toJsonString(wkpTaxDetailMap));
                        logger.info("dimensionMap:{}", (Object)SerializationUtils.toJsonString(dimensionMap));
                    }
                    HashMap<String, String> dimensionInfoMap = new HashMap<String, String>(8);
                    for (Map.Entry<String, String> entry : dimensionMap.entrySet()) {
                        dimensionInfoMap.clear();
                        String summaryAndDetailRelationSerialno = UUID.randomUUID();
                        BigDecimal specialSaleAmount = this.getSaleAmountOrTaxAmount(summaryAndDetailRelationSerialno, salesAmountDetailMap, entry, "invoiceamount", dimensionInfoMap);
                        BigDecimal otherSaleAmount = this.getSaleAmountOrTaxAmount(summaryAndDetailRelationSerialno, otherSalesAmountDetailMap, entry, "amount", dimensionInfoMap);
                        BigDecimal wkpSaleAmount = this.getSaleAmountOrTaxAmount(summaryAndDetailRelationSerialno, wkpSalesAmountDetailMap, entry, "amount", dimensionInfoMap);
                        BigDecimal specialTaxAmount = this.getSaleAmountOrTaxAmount(summaryAndDetailRelationSerialno, specialTaxDetailMap, entry, "taxamount", dimensionInfoMap);
                        BigDecimal otherTaxAmount = this.getSaleAmountOrTaxAmount(summaryAndDetailRelationSerialno, otherTaxDetailMap, entry, "taxamount", dimensionInfoMap);
                        BigDecimal wkpTaxAmount = this.getSaleAmountOrTaxAmount(summaryAndDetailRelationSerialno, wkpTaxDetailMap, entry, "taxamount", dimensionInfoMap);
                        if (BigDecimal.ZERO.compareTo(wkpTaxAmount) == 0 && incomerule.getBoolean("iswkpwscl").booleanValue()) {
                            wkpSaleAmount = BigDecimal.ZERO;
                        }
                        DynamicObject newSummaryObject = this.buildAccountSummary(model, draftMetaDataDTO, orgId, date, rule, incomerule, summaryAndDetailRelationSerialno, entityType, deadLine, specialSaleAmount, otherSaleAmount, wkpSaleAmount, initaccountingamount, specialTaxAmount, otherTaxAmount, wkpTaxAmount, oldDraftList, draftEditArr, dimensionInfoMap);
                        summaryList.add(newSummaryObject);
                    }
                }
            }
            model.addErrorMap(repeatInvoiceDataMap);
            allInvoiceItemIdBeUsedByIncomeRuleXseMap.putAll(allInvoiceItemIdBeUsedByIncomeRuleSeMap);
            model.setEntryIds(allInvoiceItemIdBeUsedByIncomeRuleXseMap.keySet());
            List<DynamicObject> groupSummaryDataList = IncomeUtils.groupSummaryData("IncomeEngine", model, summaryList);
            logger.info("exec IncomeEngine15\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            DraftEngineEnum.YBNSR.deleteIncome(model);
            logger.info("exec IncomeEngine16\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            logger.info("summaryInvoiceList", (Object)SerializationUtils.toJsonString(summaryInvoiceList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryAccountingList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryInvoiceList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(summaryList));
            ThreadPoolsService.getInstance().submit((Task)new PartitionSaveTask(groupSummaryDataList));
            DraftEditService.updateNewDraftId(summaryList, oldDraftList, draftEditArr, "ruleid");
        } else {
            DraftEngineEnum.YBNSR.deleteIncome(model);
        }
        logger.info("{}\u7ed3\u675f\u6267\u884c\u6536\u5165\u5f15\u64ce\uff0c\u8017\u65f6\uff1a{}", (Object)RequestContext.get().getRequestId(), (Object)(System.currentTimeMillis() - start));
        return null;
    }

    private BigDecimal getSaleAmountOrTaxAmount(String serialno, Map<String, List<DynamicObject>> amountDetailMap, Map.Entry<String, String> entry, String invoiceamount, Map<String, String> dimensionInfoMap) {
        BigDecimal totalSaleAmountOrTaxAmount = BigDecimal.ZERO;
        if (null == amountDetailMap.get(entry.getKey())) {
            return totalSaleAmountOrTaxAmount;
        }
        for (DynamicObject ruleDetailObj : amountDetailMap.get(entry.getKey())) {
            if (ruleDetailObj.containsProperty(invoiceamount)) {
                totalSaleAmountOrTaxAmount = totalSaleAmountOrTaxAmount.add(ruleDetailObj.getBigDecimal(invoiceamount));
            }
            dimensionInfoMap.put("accountorg", "null".equals(ruleDetailObj.getString("accountorg")) ? "0" : ruleDetailObj.getString("accountorg"));
            dimensionInfoMap.put("bizdimensionid", ruleDetailObj.getString("bizdimensionid"));
            dimensionInfoMap.put("bizdimensiontype", ruleDetailObj.getString("bizdimensiontype"));
            dimensionInfoMap.put("bizdimensionname", ruleDetailObj.getString("bizdimensionname"));
            ruleDetailObj.set("taxaccountserialno", (Object)serialno);
        }
        return totalSaleAmountOrTaxAmount;
    }

    private Map<String, List<DynamicObject>> groupByAccountOrgAndDimension(List<DynamicObject> invoiceList, Map<String, String> dimensionMap) {
        Map<String, List<DynamicObject>> resultMap = invoiceList.stream().collect(Collectors.groupingBy(s -> s.getString("accountorg") + "#" + s.getString("bizdimensionid")));
        for (Map.Entry<String, List<DynamicObject>> stringListEntry : resultMap.entrySet()) {
            String s2 = stringListEntry.getValue().size() > 0 ? stringListEntry.getValue().get(0).getString("bizdimensionname") : "";
            dimensionMap.put(stringListEntry.getKey(), s2);
        }
        return resultMap;
    }

    private DynamicObject buildAccountSummary(TcvatEngineModel model, DraftMetaDataDTO draftMetaDataDTO, String orgId, String date, DynamicObject rule, JSONObject incomerule, String serialno, MainEntityType entityType, Object deadLine, BigDecimal invoiceamount, BigDecimal otherAccount, BigDecimal accountingamount, BigDecimal initaccountingamount, BigDecimal invoiceTax, BigDecimal otherTax, BigDecimal wkpTax, DynamicObjectCollection oldDraftList, DynamicObject[] draftEditArr, Map<String, String> dimensionInfoMap) {
        DynamicObject deductionRule;
        DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
        summary.set("serialno", (Object)serialno);
        summary.set("jzjt", rule.get("jzjt"));
        summary.set("org", (Object)orgId);
        summary.set("taxperiod", (Object)date);
        if ("nssb".equals(draftMetaDataDTO.getDraftPurpose())) {
            summary.set("extendtaxperiod", (Object)DateUtils.stringToDate2((String)((String)model.getCustom().get("skssqq"))));
        }
        summary.set("ruleid", (Object)incomerule.getLong("id"));
        DynamicObjectCollection businesstypeList = rule.getDynamicObjectCollection("businesstype");
        if (businesstypeList.size() > 0) {
            DynamicObject businesstype = (DynamicObject)businesstypeList.get(0);
            summary.set("businesstype", (Object)businesstype.getDynamicObject("fbasedataid"));
        }
        summary.set("description", (Object)incomerule.getJSONObject("name").getString("zh_CN"));
        JSONObject taxmethodValue = incomerule.getJSONObject("taxation");
        summary.set("taxmethod", (Object)taxmethodValue.getJSONObject("name").getString("zh_CN"));
        summary.set("taxmethodtype", taxmethodValue.get((Object)"id"));
        String taxrate = incomerule.getJSONObject("taxrate").getJSONObject("name").getString("zh_CN");
        summary.set("taxrate", (Object)taxrate);
        if (StringUtils.equals((CharSequence)((CharSequence)TaxRateConstant.getTaxmethodMap().get(TaxRateConstant.getExcludeTaxCN())), (CharSequence)taxmethodValue.get((Object)"number").toString()) && null != (deductionRule = rule.getDynamicObject("deductiontype"))) {
            summary.set("taxreductionid", deductionRule.get("id"));
            summary.set("taxreductioncode", deductionRule.get("number"));
            summary.set("taxreductionname", (Object)deductionRule.getString("name"));
            summary.set("taxreductiontype", (Object)deductionRule.getString("deductiontype"));
        }
        summary.set("invoiceamount", (Object)invoiceamount);
        summary.set("invoicetaxamount", (Object)BigDecimalUtil.addObject((Object)invoiceamount, (Object)invoiceTax));
        summary.set("specialinvoiceamount", (Object)invoiceamount);
        summary.set("specialtaxamount", (Object)invoiceTax);
        summary.set("otherinvoiceamount", (Object)otherAccount);
        summary.set("othertaxamount", (Object)otherTax);
        summary.set("accountingamount", (Object)accountingamount);
        summary.set("initaccountingamount", (Object)initaccountingamount);
        summary.set("nonetaxamount", (Object)wkpTax);
        summary.set("deadline", deadLine);
        List<DynamicObject> editList = DraftEditService.matchDraftEditList(oldDraftList, draftEditArr, summary, "ruleid");
        Map<String, BigDecimal> rowEditAmountMap = DraftEditService.getEditAmountBeforeReFetch(editList);
        DraftEditService.updateDraftEditOriginAmount(summary, rowEditAmountMap, editList);
        if (rowEditAmountMap.get("specialinvoiceamount") != null) {
            invoiceamount = invoiceamount.add(rowEditAmountMap.get("specialinvoiceamount"));
            summary.set("specialinvoiceamount", (Object)invoiceamount);
        }
        if (rowEditAmountMap.get("specialtaxamount") != null) {
            invoiceTax = invoiceTax.add(rowEditAmountMap.get("specialtaxamount"));
            summary.set("specialtaxamount", (Object)invoiceTax);
        }
        if (rowEditAmountMap.get("otherinvoiceamount") != null) {
            otherAccount = otherAccount.add(rowEditAmountMap.get("otherinvoiceamount"));
            summary.set("otherinvoiceamount", (Object)otherAccount);
        }
        if (rowEditAmountMap.get("othertaxamount") != null) {
            otherTax = otherTax.add(rowEditAmountMap.get("othertaxamount"));
            summary.set("othertaxamount", (Object)otherTax);
        }
        if (rowEditAmountMap.get("noneinvoiceamount") != null) {
            accountingamount = accountingamount.add(rowEditAmountMap.get("noneinvoiceamount"));
            summary.set("accountingamount", (Object)accountingamount);
        }
        if (rowEditAmountMap.get("noneinvoiceamount") != null) {
            initaccountingamount = initaccountingamount.add(rowEditAmountMap.get("noneinvoiceamount"));
            summary.set("initaccountingamount", (Object)initaccountingamount);
        }
        if (rowEditAmountMap.get("nonetaxamount") != null) {
            wkpTax = wkpTax.add(rowEditAmountMap.get("nonetaxamount"));
            summary.set("nonetaxamount", (Object)wkpTax);
        }
        BigDecimal totalAmount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{invoiceamount, otherAccount, accountingamount});
        summary.set("taxamount", (Object)totalAmount);
        BigDecimal totaltaxamount = BigDecimalUtil.addWithHalfUp((BigDecimal[])new BigDecimal[]{invoiceTax, otherTax, wkpTax});
        summary.set("totaltaxamount", (Object)totaltaxamount);
        summary.set("pricetaxamount", (Object)BigDecimalUtil.addObject((Object)totalAmount, (Object)totaltaxamount));
        summary.set("accountorg", (Object)Long.valueOf(dimensionInfoMap.getOrDefault("accountorg", "0")));
        summary.set("bizdimensionid", (Object)dimensionInfoMap.get("bizdimensionid"));
        summary.set("bizdimensiontype", (Object)dimensionInfoMap.getOrDefault("bizdimensiontype", ""));
        summary.set("bizdimensionname", (Object)dimensionInfoMap.getOrDefault("bizdimensionname", ""));
        return summary;
    }
}

