/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.PeriodService;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import org.apache.commons.lang.StringUtils;

public class RuleSettingTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(RuleSettingTask.class);
    private int batchSize = 5;
    private DynamicObject rule;
    private EngineModel model;
    private DynamicObjectCollection collection;
    private String taxaccountserialno;
    private String entityType;
    private String taxRate;
    private String taxperiod;

    public RuleSettingTask(DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate) {
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.taxperiod = null == model.getCustom().get("taxperiod") ? PeriodService.getTaxPeriod(model.getStartDate()) : (String)model.getCustom().get("taxperiod");
    }

    public RuleSettingTask(DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, String taxperiod) {
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.taxperiod = taxperiod;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        for (DynamicObject setting : settings) {
            DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityType));
            if ("tcvat_prepay_account_deta".equals(this.entityType)) {
                object.set("taxrate", (Object)this.taxRate);
            }
            this.taxperiod = this.taxperiod == null ? PeriodService.getTaxPeriod(this.model.getStartDate()) : this.taxperiod;
            Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)this.taxperiod, (String)"yyyy-MM"));
            Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)this.taxperiod, (String)"yyyy-MM"));
            RuleSettingUtils.setDynamicObject(object, this.taxaccountserialno, this.model, setting, filterList);
            object.set("skssqq", (Object)startDate);
            object.set("skssqz", (Object)endDate);
            DynamicObject table = setting.getDynamicObject("table");
            String entryName = table.getString("name");
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            String dataField = (String)fieldMap.get("datastate");
            if (null != dataField) {
                QFilter startFilter = new QFilter(dataField, ">=", (Object)DateUtils.getDayFirst((Date)startDate));
                QFilter endFilter = new QFilter(dataField, "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate));
                filterList.add(startFilter);
                filterList.add(endFilter);
            }
            if (StringUtils.equals((String)"tcvat_prepay_account_deta", (String)this.entityType) && StringUtils.equals((String)"rim_invoice", (String)entryName) && null != this.model.getCustom().get("projectid")) {
                QFilter projectFilter = new QFilter("project", "=", (Object)Long.parseLong(this.model.getCustom().get("projectid").toString()));
                filterList.add(projectFilter);
            }
            RuleSettingUtils.setFilter(this.rule, fieldMap, this.model, filterList, this.taxperiod, entryName);
            QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)DeclareTaxType.ZZS.getBaseTaxId(), (Long)table.getLong("id"), Collections.singletonList(Long.valueOf(this.model.getOrgId())), (Date)startDate, (Date)endDate);
            if (mappingQfilter != null) {
                filterList.add(mappingQfilter);
            }
            RuleSettingUtils.calAmount(Long.parseLong(this.model.getOrgId()), setting, entryName, filterList, this.entityType, this.rule, this.model, object, this.taxRate, list, "tcvat_accdetail_rollout", this.taxperiod);
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + ":" + list.size());
        return list;
    }
}

