/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import org.apache.commons.lang.StringUtils;

public class RuleTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(RuleTask.class);
    private static final int batchSize = 5;
    private Long orgId;
    private Date startdate;
    private Date enddate;
    private DynamicObject rule;
    private DynamicObjectCollection settings;
    private QFilter[] defaultFilter;

    public RuleTask(Long orgId, Date startdate, Date enddate, DynamicObject rule, DynamicObjectCollection settings, String selectFields, QFilter[] defaultFilter) {
        this.orgId = orgId;
        this.startdate = startdate;
        this.enddate = enddate;
        this.rule = rule;
        this.settings = settings;
        this.defaultFilter = defaultFilter;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.settings, (int)5);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u89c4\u5219\u914d\u7f6e\u53d6\u6570\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (DynamicObject setting : settings) {
            DynamicObject table = setting.getDynamicObject("table");
            String entryName = table.getString("name");
            String selectFields = this.setSelectFields(entryName);
            List<QFilter> filterList = this.setFilter(setting);
            DynamicObjectCollection query = QueryServiceHelper.query((String)entryName, (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]));
            list.addAll((Collection<DynamicObject>)query);
        }
        logger.info("\u89c4\u5219\u914d\u7f6e\u53d6\u6570\u8ba1\u7b97\u5f00\u59cb\u6267\u884c\uff0c\u8017\u65f6\u4e3a:{},\u6267\u884c\u7684\u7ed3\u679c\u96c6\u4e3a:{}", (Object)(System.currentTimeMillis() - start), list);
        return list;
    }

    private List<QFilter> setFilter(DynamicObject setting) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        DynamicObject table = setting.getDynamicObject("table");
        String entryName = table.getString("name");
        filterList.addAll(Arrays.asList(this.defaultFilter));
        String conditionjson = setting.getString("conditionjson");
        if (StringUtils.isNotBlank((String)conditionjson)) {
            QFilter conditionFilter = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName);
            conditionFilter = this.setConditionFilter(entryName, conditionFilter, conditionjson);
            filterList.add(conditionFilter);
        }
        return filterList;
    }

    private QFilter setConditionFilter(String entryName, QFilter conditionFilter, String conditionjson) {
        if ((entryName.equals("sim_vatinvoice") || entryName.equals("sim_vatinvoice_vehicles")) && conditionjson.contains("taxrate")) {
            conditionFilter = RuleSettingUtils.dealRate(conditionFilter);
        }
        return conditionFilter;
    }

    private String setSelectFields(String entryName) {
        String result = "";
        if ("sim_vatinvoice".equals(entryName)) {
            result = "id, items.id, invoicecode, invoiceno";
        }
        return result;
    }
}

