/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.account.AccountSelectFormService;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.common.dto.draft.DraftDto;

public class TcvatDraftEngineCalcTask
extends AbstractTask {
    private String message;
    private DraftDto draftDto = new DraftDto();

    public String getMessage() {
        return this.message;
    }

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e", (String)"TcvatDraftPlugin_37", (String)"taxc-tcvat", (Object[])new Object[0]), null);
        String orgId = (String)params.get("orgid");
        if (StringUtil.isBlank((CharSequence)orgId)) {
            orgId = (String)params.get("orgId");
        }
        String orgName = (String)params.get("orgname");
        Date startdate = DateUtils.stringToDate2((String)((String)params.get("startdate")));
        Date enddate = DateUtils.stringToDate2((String)((String)params.get("enddate")));
        String taxpayertype = (String)params.get("taxpayertype");
        String prelevyrate = (String)params.get("prelevyrate");
        String planid = (String)params.get("planid");
        String draftpurpose = (String)params.get("draftpurpose");
        this.draftDto.setOrgId(null == orgId ? 0L : Long.parseLong(orgId));
        this.draftDto.setStartDate(startdate);
        this.draftDto.setEndDate(enddate);
        this.draftDto.setTaxPayerType(taxpayertype);
        this.draftDto.setDraftPurpose(draftpurpose);
        this.draftDto.setPrelevyrate(prelevyrate);
        TcvatStrategy strategy = TcvatDraftService.getStrategy(this.draftDto);
        TcvatEngineModel engineModel = TaxDeclareHelper.buildEngineModel(this.draftDto, null);
        engineModel.setDraftEngineCalcTask(this);
        engineModel.addCustom("calcType", params.get("calcType"));
        engineModel.addCustom("remove_adjust_by_hand", params.get("remove_adjust_by_hand"));
        this.message = String.format(ResManager.loadKDString((String)"\u201c%1$S\u201d\u5728\u201c%2$S\u201d\u81f3\u201c%3$S\u201d\u7684\u201c%4$S\u201d\u5e95\u7a3f\u8ba1\u7b97\u4efb\u52a1", (String)"TcvatDraftEngineCalcTask_0", (String)"taxc-tcvat", (Object[])new Object[0]), orgName, params.get("startdate"), params.get("enddate"), "nssb".equals(draftpurpose) ? ResManager.loadKDString((String)"\u8ba1\u7a0e", (String)"TcvatDraftPlugin_39", (String)"taxc-tcvat", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8ba1\u63d0", (String)"TcvatDraftPlugin_36", (String)"taxc-tcvat", (Object[])new Object[0]));
        this.feedbackProgress(10, this.message, null);
        if ("refetch".equals(params.get("calcType"))) {
            this.updateRuleSetting(engineModel);
        }
        try (TXHandle h = TX.required();){
            try {
                strategy.engineExecute(engineModel);
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
        if ("refetch".equals(params.get("calcType"))) {
            EngineHandler handler = EngineHandlerFactory.createHandler((String)taxpayertype);
            IEngine iEngine = (IEngine)handler.getEngineList().get(2);
            iEngine.deleteData((EngineModel)engineModel);
            iEngine.runEngine((EngineModel)engineModel);
        }
        this.feedbackProgress(90, this.message, null);
        strategy.insertCheckData(engineModel, orgId, (String)params.get("startdate"), (String)params.get("enddate"), planid);
        this.feedbackProgress(100, this.message, null);
        params.put("success", "true");
        params.put("message", this.message);
        this.feedbackCustomdata(params);
    }

    private void updateRuleSetting(TcvatEngineModel engineModel) {
        String accountMetaDataName = engineModel.getDraftMetaDataDTO().getPolicyConfirm().getAccountMetaDataName();
        if ("tcvat_ybhz_policy_confirm".equals(accountMetaDataName)) {
            return;
        }
        AccountSelectFormService accountSelectFormService = new AccountSelectFormService();
        DynamicObject policy = accountSelectFormService.queryPolicyConfirm(engineModel.getOrgId(), engineModel.getStartDate(), engineModel.getEndDate(), engineModel.getDraftMetaDataDTO().getDraftPurpose(), (String)engineModel.getCustom().get("taxPayerType"), accountMetaDataName);
        Map rules = RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(engineModel.getOrgId()), (RuleTypeEnum)RuleTypeEnum.ALL, (String)((String)engineModel.getCustom().get("taxPayerType")).replace("zzs", ""), (String)engineModel.getDraftMetaDataDTO().getDraftPurpose());
        String ruledata = SerializationUtils.toJsonString((Object)rules);
        policy.set("ruledata_tag", (Object)ruledata);
        OperationServiceHelper.executeOperate((String)"save", (String)accountMetaDataName, (DynamicObject[])new DynamicObject[]{policy}, (OperateOption)OperateOption.create());
    }

    public void customFeedbackProgress(int progress, String desc, Map<String, Object> customData) {
        this.feedbackProgress(progress, desc, customData);
    }
}

