/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.hzsb;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import org.apache.commons.lang.StringUtils;

public class HzRuleSettingTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(HzRuleSettingTask.class);
    private int batchSize = 5;
    private Map<String, String> suborgDeclarationMap;
    private DynamicObject rule;
    private EngineModel model;
    private DynamicObjectCollection collection;
    private String taxaccountserialno;
    private String entityType;
    private String taxRate;
    private Long orgid;
    private boolean includingSubOrg = true;

    public HzRuleSettingTask(Long orgid, Map<String, String> suborgDeclarationMap, DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, boolean includingSubOrg) {
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.includingSubOrg = includingSubOrg;
        this.suborgDeclarationMap = suborgDeclarationMap;
        this.orgid = orgid;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        for (DynamicObject setting : settings) {
            DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityType));
            RuleSettingUtils.setDynamicObject(object, this.taxaccountserialno, this.model, setting, filterList);
            Date startDate = DateUtils.stringToDate((String)this.model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)this.model.getEndDate());
            object.set("startdate", (Object)startDate);
            object.set("enddate", (Object)endDate);
            object.set("taxpayertype", this.model.getCustom().get("taxPayerType"));
            if (this.includingSubOrg) {
                object.set("suborg", (Object)this.rule.getDynamicObject("org").getLong("id"));
                if (null != this.suborgDeclarationMap) {
                    String levelName = this.suborgDeclarationMap.get(this.rule.getDynamicObject("org").getString("id"));
                    object.set("declaretype", (Object)("1".equals(levelName) ? "2" : "3"));
                    object.set("levelname", (Object)levelName);
                }
            }
            DynamicObject table = setting.getDynamicObject("table");
            String taxperiod = this.model.getStartDate().substring(0, 7);
            String entryName = table.getString("name");
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            String dataField = (String)fieldMap.get("datastate");
            if (null != dataField) {
                if (StringUtils.equals((String)"til_in_transfer_out_bill", (String)entryName)) {
                    QFilter periodFilter = new QFilter(dataField, "=", (Object)startDate);
                    filterList.add(periodFilter);
                } else {
                    QFilter startFilter = new QFilter(dataField, ">=", (Object)startDate);
                    QFilter endFilter = new QFilter(dataField, "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate));
                    filterList.add(startFilter);
                    filterList.add(endFilter);
                }
            }
            RuleSettingUtils.setFilter(fieldMap, entryName, this.model, filterList, taxperiod, this.orgid);
            QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)DeclareTaxType.ZZS.getBaseTaxId(), (Long)table.getLong("id"), Collections.singletonList(this.orgid), (Date)startDate, (Date)endDate);
            if (mappingQfilter != null) {
                filterList.add(mappingQfilter);
            }
            RuleSettingUtils.calAmount(this.orgid, setting, entryName, filterList, this.entityType, this.rule, this.model, object, this.taxRate, list, "tcvat_hz_accdetail_rout", taxperiod);
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + ":" + list.size());
        return list;
    }
}

