/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.hzsb;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleCalcDetailParam;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import org.apache.commons.lang.StringUtils;

public class NewHzRuleSettingTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(NewHzRuleSettingTask.class);
    private int batchSize = 5;
    private Map<String, String> allInvoiceItemIdBeUsedMap;
    private Map<String, String> suborgDeclarationMap;
    private Map<String, Map<String, Object>> repeatInvoiceDataMap;
    private DynamicObject rule;
    private EngineModel model;
    private DynamicObjectCollection collection;
    private String taxaccountserialno;
    private String entityType;
    private String taxRate;
    private Long orgid;
    private boolean includingSubOrg = true;
    private String suffix = "";
    private String type;

    public NewHzRuleSettingTask(Map<String, String> allInvoiceItemIdBeUsedMap, Long orgid, Map<String, Map<String, Object>> repeatInvoiceDataMap, DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, String suffix, String type) {
        this.allInvoiceItemIdBeUsedMap = allInvoiceItemIdBeUsedMap;
        this.repeatInvoiceDataMap = repeatInvoiceDataMap;
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.orgid = orgid;
        this.suffix = suffix;
        this.type = type;
    }

    public NewHzRuleSettingTask(Map<String, String> allInvoiceItemIdBeUsedMap, Long orgid, Map<String, Map<String, Object>> repeatInvoiceDataMap, DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, String suffix, String type, Map<String, String> suborgDeclarationMap) {
        this.allInvoiceItemIdBeUsedMap = allInvoiceItemIdBeUsedMap;
        this.repeatInvoiceDataMap = repeatInvoiceDataMap;
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.orgid = orgid;
        this.suffix = suffix;
        this.type = type;
        this.suborgDeclarationMap = suborgDeclarationMap;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Date startDate = DateUtils.stringToDate((String)this.model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)this.model.getEndDate());
        Map<String, BigDecimal> exrateMap = RuleSettingUtils.getExrateMap(this.suffix, settings, startDate, endDate);
        for (DynamicObject setting : settings) {
            DynamicObject object = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.entityType));
            NewRuleSettingUtils.setDynamicObject(object, this.taxaccountserialno, this.model, setting, this.suffix, this.type);
            object.set("startdate", (Object)startDate);
            object.set("enddate", (Object)endDate);
            object.set("taxpayertype", this.model.getCustom().get("taxPayerType"));
            if (this.includingSubOrg) {
                object.set("suborg", (Object)this.orgid);
                if (null != this.suborgDeclarationMap) {
                    object.set("declaretype", (Object)("1".equals(this.suborgDeclarationMap.get(String.valueOf(this.orgid))) ? "2" : "3"));
                }
            }
            DynamicObject table = setting.getDynamicObject("table" + this.suffix);
            String taxperiod = this.model.getStartDate().substring(0, 7);
            String entryName = table.getString("name");
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            String dataField = (String)fieldMap.get("datastate");
            if (null != dataField) {
                if (StringUtils.equals((String)"til_in_transfer_out_bill", (String)entryName)) {
                    QFilter periodFilter = new QFilter(dataField, "=", (Object)startDate);
                    filterList.add(periodFilter);
                } else {
                    QFilter startFilter = new QFilter(dataField, ">=", (Object)startDate);
                    QFilter endFilter = new QFilter(dataField, "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate));
                    filterList.add(startFilter);
                    filterList.add(endFilter);
                }
            }
            NewRuleSettingUtils.setFilter(fieldMap, entryName, this.model, filterList, taxperiod, this.orgid);
            RuleSettingUtils.setPartialPrepayDefaultFilter(this.rule, entryName, filterList);
            QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)DeclareTaxType.ZZS.getBaseTaxId(), (Long)table.getLong("id"), Collections.singletonList(this.orgid), (Date)startDate, (Date)endDate);
            if (mappingQfilter != null) {
                filterList.add(mappingQfilter);
            }
            BigDecimal exrate = BigDecimal.ZERO;
            if (setting.containsProperty("exratejson" + this.suffix)) {
                String exratejson = setting.getString("exratejson" + this.suffix);
                exrate = exrateMap.getOrDefault(exratejson, BigDecimal.ZERO);
            }
            RuleCalcDetailParam detailParam = new RuleCalcDetailParam(entryName, this.suffix, this.entityType, this.taxRate, "tcvat_hz_accdetail_rout", exrate);
            NewRuleSettingUtils.calAmount(this.allInvoiceItemIdBeUsedMap, this.orgid, setting, filterList, this.rule, this.model, this.repeatInvoiceDataMap, object, list, detailParam, taxperiod);
        }
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + ":" + list.size());
        return list;
    }
}

