/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.strategy.DefaultStraegy;
import kd.taxc.tcvat.business.service.engine.task.util.strategy.InvoiceContext;
import kd.taxc.tcvat.business.service.engine.task.util.strategy.SimVatInvoiceStrategy;
import kd.taxc.tcvat.business.service.engine.task.util.strategy.SimVatInvoiceVehiclesStrategy;

public class InvoiceTaskUtils {
    private static RuleSettingUtils ruleSettingUtils = new RuleSettingUtils();

    public static void setOrgFilter(List<QFilter> filterList, EngineModel model, Map<String, String> fieldMap, String entryName, Long orgid) {
        String org = fieldMap.get("orgstate");
        if (null != org) {
            Map orgRelationMap = (Map)model.getCustom().get("OrgRelationMap");
            String entityKey = entryName;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
            }
            QFilter qfilter = EngineCalcFilterService.getOrgQfilterByRelation((Map)orgRelationMap, (Long)orgid, (String)entryName, (String)entityKey, (String)org);
            filterList.add(qfilter);
        }
    }

    public static void setRateFilter(List<QFilter> filterList, String property, BigDecimal rate, Boolean differenceinvoice, String entryName) {
        filterList.add(InvoiceTaskUtils.setRateFilter(property, rate, differenceinvoice, entryName));
    }

    public static QFilter setRateFilter(String property, BigDecimal rate, Boolean differenceinvoice, String tableNumber) {
        ArrayList<String> currentRuleRate = new ArrayList<String>(10);
        currentRuleRate.addAll(RuleSettingUtils.getRateScaleList(Collections.singletonList(rate.toString())));
        if (tableNumber.equals("sim_vatinvoice") && differenceinvoice.booleanValue()) {
            currentRuleRate.addAll(RuleSettingUtils.getRateScaleList(Collections.singletonList("0")));
        }
        if (0 == Double.compare(0.13, rate.doubleValue())) {
            currentRuleRate.addAll(RuleSettingUtils.getRateScaleList(Arrays.asList("0.16", "0.17")));
        } else if (0 == Double.compare(0.1, rate.doubleValue())) {
            currentRuleRate.addAll(RuleSettingUtils.getRateScaleList(Collections.singletonList("0.11")));
        } else if (0 == Double.compare(0.09, rate.doubleValue())) {
            currentRuleRate.addAll(RuleSettingUtils.getRateScaleList(Arrays.asList("0.1", "0.11")));
        } else if (0 == Double.compare(0.0, rate.doubleValue())) {
            currentRuleRate.addAll(RuleSettingUtils.getRateScaleList(Collections.singletonList("0")));
        }
        return new QFilter(property, "in", currentRuleRate);
    }

    public static DynamicObjectCollection queryInvoiceOutPutList(List<QFilter> filterList, String taxPayerType, DynamicObject setting, String filterIdName, String jzjtTag, Map<String, Object> customParams) {
        for (QFilter qFilter : filterList) {
            if (!"orgid".equals(qFilter.getProperty())) continue;
            qFilter.__setProperty("taxorg");
        }
        DynamicObject table = setting.getDynamicObject("table12");
        String entryName = table.getString("name");
        InvoiceContext context = null;
        if ("sim_vatinvoice".equals(entryName)) {
            context = new InvoiceContext(new SimVatInvoiceStrategy());
        }
        if ("sim_vatinvoice_vehicles".equals(entryName)) {
            context = new InvoiceContext(new SimVatInvoiceVehiclesStrategy());
        }
        if (null == context) {
            context = new InvoiceContext(new DefaultStraegy());
        }
        DynamicObjectCollection detail = context.executeStrategy(setting, filterList, jzjtTag, filterIdName, taxPayerType, customParams);
        return detail;
    }

    public static void setDataMapAndErrorMap(DynamicObject invoice, Map<String, String> dataMap, Map<String, Map<String, Object>> errorMap, DynamicObject rule, Map<String, String> invoiceTypeIdMap) {
        String entryId = invoice.getString("itemid");
        String entryIdData = dataMap.get(entryId);
        if (null != entryIdData) {
            Map map = errorMap.computeIfAbsent(entryId, k -> new HashMap());
            map.put("type", rule.getDataEntityType().getName());
            map.put("field", "invoice");
            map.put("goodsname", invoice.getString("goodsname"));
            map.put("goodscode", invoice.getString("goodscode"));
            map.put("invoicetype", invoiceTypeIdMap.get(invoice.getString("baseinvoicetype")));
            map.put("baseinvoicetype", invoice.getString("baseinvoicetype"));
            map.put("invoicedate", invoice.getDate("invoicedate"));
            map.put("invoicecode", invoice.get("invoicecode"));
            map.put("invoiceno", invoice.get("invoiceno"));
            map.put("taxrate", invoice.get("taxrate"));
            map.put("amount", invoice.getBigDecimal("amount"));
            map.put("taxamount", invoice.getBigDecimal("taxamount1"));
            map.put("total", ((BigDecimal)map.get("amount")).add((BigDecimal)map.get("taxamount")));
            map.put("org", invoice.getString("org"));
            Set set = (Set)map.computeIfAbsent("rulelist", k -> new HashSet());
            set.add(entryIdData);
            set.add(rule.getString("name"));
        }
        dataMap.put(entryId, rule.getString("name"));
    }

    public static void setInvoicedataMapAndErrorMap(DynamicObject invoice, Map<String, String> allInvoiceItemIdBeUsedMap, Map<String, Map<String, Object>> repeatInvoiceDataMap, DynamicObject rule, Map<String, String> invoiceTypeIdMap) {
        String entryId = invoice.getString("itemsid");
        String entryIdData = allInvoiceItemIdBeUsedMap.get(entryId);
        if (null != entryIdData) {
            Map map = repeatInvoiceDataMap.computeIfAbsent(entryId, k -> new HashMap());
            map.put("type", rule.getDataEntityType().getName());
            map.put("field", "invoice");
            map.put("goodsname", invoice.getString("goodsname"));
            map.put("goodscode", invoice.getString("goodscode"));
            map.put("invoicetype", invoiceTypeIdMap.get(invoice.getString("baseinvoicetype")));
            map.put("baseinvoicetype", invoice.getString("baseinvoicetype"));
            map.put("invoicedate", invoice.getDate("invoicedate"));
            map.put("invoicecode", invoice.get("invoicecode"));
            map.put("invoiceno", invoice.get("invoiceno"));
            map.put("taxrate", invoice.get("taxrate"));
            map.put("amount", invoice.getBigDecimal("amount"));
            map.put("taxamount", invoice.getBigDecimal("taxamount1"));
            map.put("total", ((BigDecimal)map.get("amount")).add((BigDecimal)map.get("taxamount")));
            map.put("org", invoice.getString("org"));
            Set set = (Set)map.computeIfAbsent("rulelist", k -> new HashSet());
            set.add(entryIdData);
            set.add(rule.getString("name"));
        }
        allInvoiceItemIdBeUsedMap.put(entryId, rule.getString("name"));
    }

    public static DynamicObjectCollection jzjtStrategy(DynamicObjectCollection simInvoiceCollection, String invoicePkIdFieldName, String invoiceIdFieldName, String jzjtTag) {
        List simInvoiceIdList = simInvoiceCollection.stream().map(s -> s.getLong(invoicePkIdFieldName)).collect(Collectors.toList());
        DynamicObjectCollection simInvoiceSignCollection = QueryServiceHelper.query((String)"tcvat_output_invoice_sign", (String)invoiceIdFieldName, (QFilter[])new QFilter[]{new QFilter(invoiceIdFieldName, "in", simInvoiceIdList), new QFilter("jzjtsign", "=", (Object)"1")});
        Map<String, String> mainInvoiceIdMap = simInvoiceSignCollection.stream().collect(Collectors.toMap(k -> k.getString(invoiceIdFieldName), v -> v.getString(invoiceIdFieldName), (k1, k2) -> k1));
        return simInvoiceCollection.stream().filter(d -> "1".equals(jzjtTag) ? mainInvoiceIdMap.containsKey(d.getString(invoicePkIdFieldName)) : !mainInvoiceIdMap.containsKey(d.getString(invoicePkIdFieldName))).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    public static List<DynamicObject> jzjtStrategy(List<DynamicObject> simInvoiceCollection, String invoicePkIdFieldName, String invoiceIdFieldName, String jzjtTag) {
        List simInvoiceIdList = simInvoiceCollection.stream().map(s -> s.getLong(invoicePkIdFieldName)).collect(Collectors.toList());
        DynamicObjectCollection simInvoiceSignCollection = QueryServiceHelper.query((String)"tcvat_output_invoice_sign", (String)invoiceIdFieldName, (QFilter[])new QFilter[]{new QFilter(invoiceIdFieldName, "in", simInvoiceIdList), new QFilter("jzjtsign", "=", (Object)"1")});
        Map<String, String> mainInvoiceIdMap = simInvoiceSignCollection.stream().collect(Collectors.toMap(k -> k.getString(invoiceIdFieldName), v -> v.getString(invoiceIdFieldName), (k1, k2) -> k1));
        return simInvoiceCollection.stream().filter(d -> "1".equals(jzjtTag) ? mainInvoiceIdMap.containsKey(d.getString(invoicePkIdFieldName)) : !mainInvoiceIdMap.containsKey(d.getString(invoicePkIdFieldName))).collect(Collectors.toList());
    }
}

