/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.mservice.ruleEngine.RuleFilterServiceImpl;
import kd.taxc.tcvat.business.service.engine.task.util.InvoiceTaskUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleCalcDetailParam;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import kd.taxc.tcvat.business.service.sql.SqlBuilder;
import kd.taxc.tcvat.common.constant.DraftConstant;
import kd.taxc.tcvat.common.constant.RuleSettingConstant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class NewRuleSettingUtils
extends RuleSettingUtils {
    private static Log logger = LogFactory.getLog(NewRuleSettingUtils.class);
    private static BigDecimal reverse = new BigDecimal(-1);
    private static Set<String> TEMPLATETYPE = Sets.newHashSet((Object[])new String[]{"zzsybnsr", "zzsybnsr_hz_zjg", "zzsybnsr_ybhz", "zzsybnsr_yz_zjg"});
    public static Set<String> qtfpIncomeRuleList = Sets.newHashSet((Object[])new String[]{"tcvat_accdetail_income", "tcvat_hz_accdetail_income"});
    public static Set<String> zyfpIncomeRuleList = Sets.newHashSet((Object[])new String[]{"tcvat_income_invoice", "tcvat_hz_income_invoice"});

    public static void calAmount(Map<String, String> allInvoiceItemIdBeUsedMap, Long orgid, DynamicObject setting, List<QFilter> filterList, DynamicObject rule, EngineModel model, Map<String, Map<String, Object>> repeatInvoiceDataMap, DynamicObject object, List<DynamicObject> list, RuleCalcDetailParam detailParam, String taxperiod) {
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        Date lastDayOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)taxperiod, (String)"yyyy-MM"));
        NewRuleSettingUtils.calAmount(allInvoiceItemIdBeUsedMap, orgid, setting, filterList, rule, model, repeatInvoiceDataMap, object, list, DateUtils.format((Date)firstDayOfMonth), DateUtils.format((Date)lastDayOfMonth), taxperiod, Arrays.asList(model.getStartDate().substring(0, 7), model.getEndDate().substring(0, 7)), detailParam);
    }

    public static void calAmount(Map<String, String> allInvoiceItemIdBeUsedMap, Long orgid, DynamicObject setting, List<QFilter> filterList, DynamicObject rule, EngineModel model, Map<String, Map<String, Object>> repeatInvoiceDataMap, DynamicObject object, List<DynamicObject> list, String startDate, String endDate, String taxperiod, List<String> dateList, RuleCalcDetailParam detailParam) {
        BigDecimal rate;
        String selectFields;
        boolean ybnsrIncomeNew;
        String selectFieldwithid;
        String entryName = detailParam.getSettingTable();
        String entityType = detailParam.getSaveEntity();
        String taxRate = detailParam.getTaxRate();
        String rollout = detailParam.getRolloutEntity();
        String settingSuffix = detailParam.getSettingSuffix();
        BigDecimal exrate = detailParam.getExrate() == null ? BigDecimal.ZERO : detailParam.getExrate();
        boolean isZyfpqsSim = zyfpIncomeRuleList.contains(entityType) && Arrays.asList("12", "2").contains(settingSuffix) && Objects.equals(entryName, "sim_vatinvoice");
        boolean isZyfpqsSimVeh = zyfpIncomeRuleList.contains(entityType) && Arrays.asList("12", "2").contains(settingSuffix) && Objects.equals(entryName, "sim_vatinvoice_vehicles");
        boolean isQtfpqsSim = qtfpIncomeRuleList.contains(entityType) && Arrays.asList("1", "11").contains(settingSuffix) && Objects.equals(entryName, "sim_vatinvoice");
        boolean isQtfpqsSimVeh = qtfpIncomeRuleList.contains(entityType) && Arrays.asList("1", "11").contains(settingSuffix) && Objects.equals(entryName, "sim_vatinvoice_vehicles");
        boolean isZyfp = "tcvat_income_invoice".equals(entityType) || "tcvat_hz_income_invoice".equals(entityType);
        Map<String, String> invoiceTypeIdMap = (Map<String, String>)model.getCustom().get("invoiceTypeIdMap");
        if (invoiceTypeIdMap == null) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
            invoiceTypeIdMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        }
        String amountField = setting.getDynamicObject("amountfield" + settingSuffix).getString("fieldname");
        String fieldsubname = setting.getDynamicObject("amountfield" + settingSuffix).getString("fieldsubname");
        String conditionjson = "invoiceentity".equals(setting.getDynamicObjectType().getName()) ? setting.getString("invoiceconditionjson") : setting.getString("conditionjson" + settingSuffix);
        taxRate = NewRuleSettingUtils.trimTaxRate(taxRate);
        QFilter conditionFilters = null;
        if (StringUtils.isNotBlank((String)conditionjson)) {
            if ((entryName.equals("gl_voucher") || entryName.equals("gl_balance")) && conditionjson.contains("assgrp")) {
                conditionjson = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleFilterService", (String)"setAssgrpConditionJson", (Object[])new Object[]{conditionjson});
            }
            if ((conditionFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)("tdm_finance_main".equalsIgnoreCase(entryName) ? "tdm_finance_lrb" : entryName))) != null) {
                if ((entryName.equals("sim_vatinvoice") || entryName.equals("sim_vatinvoice_vehicles")) && conditionjson.contains("taxrate")) {
                    conditionFilters = NewRuleSettingUtils.dealRate(conditionFilters);
                } else if (entryName.equals("gl_balance")) {
                    conditionFilters = GetGLBalanceCommonUtil.reBuildAccountFilter((QFilter)conditionFilters);
                }
                logger.info("0 \u89c4\u5219\u914d\u7f6e\u6761\u4ef6" + JsonUtil.toJson((Object)conditionFilters.toString()));
                filterList.add(conditionFilters);
            }
        }
        ArrayList<QFilter> noDetailFilters = new ArrayList<QFilter>();
        if (entryName.equals("sim_vatinvoice")) {
            filterList.add(QFilter.isNotNull((String)"items.goodscode").and("items.goodscode", "!=", (Object)" ").and("items.goodscode", "!=", (Object)"").or(new QFilter("issuetype", "=", (Object)"1")));
        }
        if (entryName.equals("tdm_invoice_output")) {
            filterList.add(new QFilter("invoicestatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "3"})));
        }
        String selectField = amountField;
        if (!entryName.equals(fieldsubname)) {
            selectField = fieldsubname + "." + amountField;
            selectFieldwithid = "er_tripreimbursebill".equals(entryName) && "entryentity".equals(fieldsubname) ? "tripentry." + fieldsubname + ".id as id,tripentry." + fieldsubname + "." + amountField : fieldsubname + ".id as id," + fieldsubname + "." + amountField;
        } else {
            selectFieldwithid = "id," + amountField;
        }
        boolean bl = ybnsrIncomeNew = entryName.equals("sim_vatinvoice") && qtfpIncomeRuleList.contains(entityType) && !Objects.equals(amountField, "tax");
        if (ybnsrIncomeNew) {
            selectFieldwithid = !entryName.equals(fieldsubname) ? selectFieldwithid + "," + fieldsubname + ".tax" : selectFieldwithid + ",items.tax";
        }
        Boolean differenceinvoice = Boolean.FALSE;
        if (setting.containsProperty("differenceinvoice" + settingSuffix)) {
            differenceinvoice = setting.getBoolean("differenceinvoice" + settingSuffix);
        }
        if (isQtfpqsSim || isZyfpqsSim) {
            selectFields = "orgid as org, issuetime as invoicedate,invoicecode,invoiceno,baseinvoicetype,items.id as itemsid ,items.id as itemid ,items.taxrate as taxrate,items.amount as amount,items.tax as taxamount1,items.goodsname as goodsname, items.goodscode as goodscode";
            selectFieldwithid = selectFieldwithid + "," + selectFields;
            rate = new BigDecimal(taxRate.replaceAll("%", "")).divide(ONE_HUNDRED).setScale(2);
            InvoiceTaskUtils.setRateFilter(filterList, "items.taxrate", rate, differenceinvoice, entryName);
            InvoiceTaskUtils.setRateFilter(noDetailFilters, "items.taxrate", rate, differenceinvoice, entryName);
            logger.info("1 \u7a0e\u7387\u914d\u7f6e\u6761\u4ef6" + JsonUtil.toJson((Object)filterList.toString()));
        }
        if (isQtfpqsSimVeh || isZyfpqsSimVeh) {
            selectFields = "orgid as org, issuetime as invoicedate,invoicecode,invoiceno, '961641829533496320' as baseinvoicetype, id as itemsid ,id as itemid , taxrate, invoiceamount as amount,totaltax as taxamount1,'' as goodsname, goodscode";
            selectFieldwithid = selectFieldwithid + "," + selectFields;
            rate = new BigDecimal(taxRate.replaceAll("%", "")).divide(ONE_HUNDRED).setScale(2);
            InvoiceTaskUtils.setRateFilter(filterList, "taxrate", rate, differenceinvoice, entryName);
            logger.info("2 \u7a0e\u7387\u914d\u7f6e\u6761\u4ef6" + JsonUtil.toJson((Object)filterList.toString()));
        }
        if ("tdm_withholding_tax".equals(entryName) && !"taxcode".equals(amountField)) {
            selectFieldwithid = selectFieldwithid + ",taxcode";
        }
        if (StringUtils.equals((String)rollout, (String)entityType) && StringUtils.equals((String)"tcvat_input_invoice_sign", (String)entryName)) {
            QFilter signStatusFilter = new QFilter("signstatus", "=", (Object)"1");
            filterList.add(signStatusFilter);
        }
        logger.info("{} \u6570\u636e\u6e90:" + entryName + " \u8fc7\u6ee4\u6761\u4ef6:" + JsonUtil.toJson((Object)filterList.toString()), (Object)RequestContext.get().getRequestId());
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        BigDecimal detailTotalTaxAmount = BigDecimal.ZERO;
        boolean isBeginOrEnd = GetGLBalanceCommonUtil.conditionCheck((String)fieldsubname, (String)amountField);
        int dataCount = 0;
        if (StringUtils.equals((String)rollout, (String)entityType) && StringUtils.equals((String)"tcvat_input_invoice_sign", (String)entryName) && selectFieldwithid.contains("avaliabletaxamount")) {
            BigDecimal sumRolloutTaxAmount = SqlBuilder.querySumTaxAmount(orgid, "rollouttaxamount", "tcvat_rollout_register", model, conditionFilters);
            BigDecimal sumSignedTaxAmount = SqlBuilder.querySumTaxAmount(orgid, "currentsigntaxamount", entryName, model, conditionFilters);
            detailTotalAmount = BigDecimalUtil.subtractObject((Object)sumRolloutTaxAmount, (Object)sumSignedTaxAmount, (int)2);
        } else {
            DynamicObjectCollection accountingList;
            if ("tcvat_invoice_sign_bill".equals(entryName)) {
                accountingList = NewRuleSettingUtils.getReportData(Long.parseLong((String)model.getCustom().get("taxorg")), model, conditionFilters);
            } else if (isBeginOrEnd) {
                accountingList = taxperiod.equals(dateList.get(0)) && StringUtil.startsWith((CharSequence)amountField, (CharSequence)"begin") ? GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)amountField, (String)startDate, (String)endDate, filterList) : (taxperiod.equals(dateList.get(dateList.size() - 1)) && StringUtil.startsWith((CharSequence)amountField, (CharSequence)"end") ? GetGLBalanceCommonUtil.queryAccountingList((String)entryName, (String)selectFieldwithid, (String)amountField, (String)startDate, (String)endDate, filterList) : new DynamicObjectCollection());
            } else if ("sim_vatinvoice".equals(entryName)) {
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"NewRuleSettingUtils.sim_vatinvoice", (String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]), null);
                DynamicObjectCollection detail = ORM.create().toPlainDynamicObjectCollection(dataSet);
                String incomeRuleName = ((DynamicObject)setting.getParent()).getDynamicObjectType().getName();
                String taxPayerType = model.getCustom().getOrDefault("taxpayertype", "zzsybnsr");
                if ("tcvat_rule_income".equals(incomeRuleName) && TEMPLATETYPE.contains(taxPayerType) && ObjectUtils.isNotEmpty((Object)setting.getDynamicObject("table" + settingSuffix)) && "1835580761286481920".equals(setting.getDynamicObject("table" + settingSuffix).getString("id"))) {
                    detail = InvoiceTaskUtils.jzjtStrategy(detail, "id", "subinvoiceid", rule.getString("jzjt"));
                }
                accountingList = detail;
            } else if ("tdm_finance_main".equals(entryName)) {
                QFilter q;
                String datatype = setting.getString("datatype" + settingSuffix);
                DynamicObject table = setting.getDynamicObject("table" + settingSuffix);
                Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
                String entryentityconf = setting.getString("entryentityconfjson" + settingSuffix);
                RuleTimeFilterDto ruleTimeFilterDto = new RuleTimeFilterDto(entryentityconf, DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)model.getEndDate()), filterList, fieldsubname, fieldMap, entryName);
                if ("zjqs".equals(datatype)) {
                    RuleFilterServiceImpl rulefilterservice = new RuleFilterServiceImpl();
                    rulefilterservice.setQueryDateByAdvanceConf(ruleTimeFilterDto);
                }
                List<String> sbbids = NewRuleSettingUtils.getSbbIds(Collections.singletonList(orgid), ruleTimeFilterDto.getStartdate(), ruleTimeFilterDto.getEnddate(), setting.getDynamicObject("table" + settingSuffix), entryName);
                QFilter filter = new QFilter("sbbid", "in", sbbids);
                if (StringUtils.isNotBlank((String)conditionjson) && StringUtils.isNotBlank((String)fieldsubname) && (q = FilterBuilderUtils.buildFilter((String)conditionjson, (String)fieldsubname)) != null) {
                    filter = filter.and(q);
                }
                accountingList = QueryServiceHelper.query((String)fieldsubname, (String)selectFieldwithid, (QFilter[])new QFilter[]{filter});
                selectField = amountField;
            } else {
                accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
                isBeginOrEnd = GetGLBalanceCommonUtil.tdmBalanceNew((String)fieldsubname, (String)amountField);
            }
            dataCount = accountingList.size();
            if ("tdm_withholding_tax".equals(entryName)) {
                long taxcode = accountingList.stream().map(s -> s.getString("taxcode")).distinct().count();
                dataCount = (int)taxcode;
            }
            for (DynamicObject dynamicObject : accountingList) {
                Object o2;
                Boolean flag;
                if (ybnsrIncomeNew) {
                    detailTotalTaxAmount = detailTotalTaxAmount.add(dynamicObject.getBigDecimal(fieldsubname + ".tax"));
                }
                if (isQtfpqsSim || isQtfpqsSimVeh) {
                    InvoiceTaskUtils.setInvoicedataMapAndErrorMap(dynamicObject, allInvoiceItemIdBeUsedMap, repeatInvoiceDataMap, rule, invoiceTypeIdMap);
                } else if (isZyfpqsSim || isZyfpqsSimVeh) {
                    detailTotalTaxAmount = detailTotalTaxAmount.add(dynamicObject.getBigDecimal("taxamount1"));
                    InvoiceTaskUtils.setInvoicedataMapAndErrorMap(dynamicObject, allInvoiceItemIdBeUsedMap, repeatInvoiceDataMap, rule, invoiceTypeIdMap);
                }
                if (!"er_tripreimbursebill".equals(entryName) || !"entryentity".equals(fieldsubname) ? null == dynamicObject.getString(selectField) || !dynamicObject.getString(selectField).matches("-?\\d+(\\.\\d+)?") : (flag = Boolean.valueOf(Objects.nonNull(o2 = dynamicObject.get(selectField = selectField.startsWith("tripentry.") ? selectField : "tripentry." + selectField)) && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{o2.toString()}) && (o2 instanceof BigDecimal || o2 instanceof Integer))) == false) continue;
                detailTotalAmount = detailTotalAmount.add(isBeginOrEnd ? dynamicObject.getBigDecimal(selectField) : NewRuleSettingUtils.getAbsAmount(setting.getBoolean("absolute" + settingSuffix), selectField, dynamicObject));
            }
        }
        BigDecimal bigDecimal = isBeginOrEnd ? (setting.getBoolean("absolute" + settingSuffix) ? detailTotalAmount.abs() : detailTotalAmount) : (detailTotalAmount = detailTotalAmount);
        if (object.containsProperty("type")) {
            if (StringUtils.equals((String)"count", (String)object.getString("type"))) {
                object.set("fetchamount", (Object)dataCount);
            } else {
                object.set("fetchamount", (Object)detailTotalAmount);
            }
        }
        String datadirection = setting.getString("datadirection" + settingSuffix);
        String dataType = setting.getString("datatype" + settingSuffix);
        taxRate = RuleSettingUtils.getCalculateTaxRate(setting, rule, object, taxRate, settingSuffix);
        BigDecimal amount = RuleSettingUtils.getAmount(taxRate, dataType, detailTotalAmount, datadirection);
        if (object.containsProperty("exrate")) {
            object.set("exrate", (Object)exrate);
            if (BigDecimal.ZERO.compareTo(exrate) < 0) {
                amount = amount.multiply(exrate).setScale(10, 4);
            }
        }
        object.set(isZyfp ? "invoiceamount" : "amount", (Object)amount);
        if ("tcvat_wait_deduction_det".equals(entityType) || "tcvat_hz_wait_deduct_det".equals(entityType)) {
            if (StringUtils.equals((String)"count", (String)object.getString("type"))) {
                object.set("amount", (Object)dataCount);
            } else {
                object.set("fetchamount", (Object)amount);
            }
        }
        if (DraftConstant.YBNSR_JZJT_JXSE_ACCDETAIL.equals(entityType) || DraftConstant.YBHZ_JZJT_JXSE_ACCDETAIL.equals(entityType)) {
            object.set("fetchamount", (Object)detailTotalAmount);
        }
        if (DraftConstant.YBNSR_DEDUCTION_DETAIL_BILL.equals(entityType) || DraftConstant.YBHZ_DEDUCT_DETAIL.equals(entityType) || DraftConstant.PAGE_WAIT_DEDUCTION_DETAIL.equals(entityType) || DraftConstant.YBHZ_HZ_WAIT_DEDUCT_DET.equals(entityType)) {
            object.set("amount", (Object)amount);
            object.set("fetchamount", (Object)amount);
            if ("zjjs".equals(dataType)) {
                if ("reverse".equals(datadirection)) {
                    dataCount = new BigDecimal(dataCount).multiply(reverse).intValue();
                }
                object.set("amount", (Object)dataCount);
                object.set("fetchamount", (Object)dataCount);
            }
        }
        if (ybnsrIncomeNew || isZyfpqsSim || isZyfpqsSimVeh) {
            object.set("taxamount", (Object)detailTotalTaxAmount);
        }
        list.add(object);
        filterList.clear();
    }

    public static void setDynamicObject(DynamicObject object, String taxaccountserialno, EngineModel model, DynamicObject setting, String suffix, String type) {
        object.set("taxaccountserialno", (Object)taxaccountserialno);
        object.set("org", (Object)Long.parseLong(model.getOrgId()));
        boolean isZyfp = "invoiceentity".equalsIgnoreCase(setting.getDynamicObjectType().getName());
        if (null != object.getDataEntityType().getProperties().get((Object)"bizname")) {
            object.set("bizname", isZyfp ? setting.get("invoicebizname") : setting.get("bizname" + suffix));
        }
        if (null != object.getDataEntityType().getProperties().get((Object)"differenceinvoice") && setting.containsProperty("differenceinvoice" + suffix)) {
            object.set("differenceinvoice", setting.get("differenceinvoice" + suffix));
        }
        DynamicObject table = setting.getDynamicObject("table" + suffix);
        object.set("table", (Object)table.getLong("id"));
        object.set("amountfield", (Object)setting.getDynamicObject("amountfield" + suffix).getLong("id"));
        object.set("datatype", setting.get("datatype" + suffix));
        object.set("datadirection", setting.get("datadirection" + suffix));
        object.set("filtercondition", isZyfp ? setting.get("invoicefiltercondition") : setting.get("filtercondition" + suffix));
        object.set("conditionjson", isZyfp ? setting.get("invoiceconditionjson") : setting.get("conditionjson" + suffix));
        object.set("absolute", (Object)setting.getBoolean("absolute" + suffix));
        if (object.containsProperty("type")) {
            object.set("type", (Object)type);
        }
    }

    public static List<DynamicObject> buildTaxDetail(List<DynamicObject> accountingList, BigDecimal taxrateBig, String entityNumber, String type) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(accountingList.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (DynamicObject income : accountingList) {
            BigDecimal taxamount;
            DynamicObject taxDetail = new DynamicObject((DynamicObjectType)entityType);
            taxDetail.set("taxaccountserialno", income.get("taxaccountserialno"));
            taxDetail.set("org", income.get("org"));
            String amountField = "amount";
            if ("tcvat_hz_accdetail_income".equals(entityNumber)) {
                taxDetail.set("startdate", income.get("startdate"));
                taxDetail.set("enddate", income.get("enddate"));
                taxDetail.set("suborg", income.get("suborg"));
            } else if ("tcvat_hz_income_invoice".equals(entityNumber)) {
                taxDetail.set("startdate", income.get("startdate"));
                taxDetail.set("enddate", income.get("enddate"));
                taxDetail.set("suborg", income.get("suborg"));
                amountField = "invoiceamount";
            } else if ("tcvat_income_invoice".equals(entityNumber)) {
                taxDetail.set("taxperiod", income.get("taxperiod"));
                amountField = "invoiceamount";
            } else {
                taxDetail.set("skssqq", income.get("skssqq"));
                taxDetail.set("skssqz", income.get("skssqz"));
            }
            taxDetail.set("table", income.get("table"));
            taxDetail.set("amountfield", income.get("amountfield"));
            taxDetail.set("datatype", income.get("datatype"));
            taxDetail.set("datadirection", income.get("datadirection"));
            taxDetail.set("filtercondition", income.get("filtercondition"));
            taxDetail.set("conditionjson", income.get("conditionjson"));
            taxDetail.set("absolute", income.get("absolute"));
            BigDecimal amount = income.get(amountField) == null ? BigDecimal.ZERO : income.getBigDecimal(amountField);
            taxDetail.set("fetchamount", income.get("fetchamount"));
            taxDetail.set(amountField, (Object)amount);
            taxDetail.set("differenceinvoice", income.get("differenceinvoice"));
            if ((zyfpIncomeRuleList.contains(entityNumber) && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_ZYSE) || qtfpIncomeRuleList.contains(entityNumber) && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_QTSE)) && Arrays.asList("1163062995127970816", "1835580761286481920").contains(String.valueOf(income.get("table")))) {
                BigDecimal exrate;
                taxamount = income.getBigDecimal("taxamount");
                if (taxDetail.containsProperty("exrate") && income.containsProperty("exrate") && BigDecimal.ZERO.compareTo(exrate = income.getBigDecimal("exrate")) < 0) {
                    taxamount = taxamount.multiply(exrate).setScale(2, 4);
                }
                taxDetail.set("taxamount", (Object)taxamount);
            } else if (qtfpIncomeRuleList.contains(entityNumber) && Objects.equals(type, RuleSettingConstant.GET_DATE_TYPE_WKPSE)) {
                taxamount = amount.multiply(taxrateBig).setScale(4, 4);
                taxDetail.set("taxamount", (Object)taxamount);
            } else {
                taxamount = amount.multiply(taxrateBig).setScale(2, 4);
                taxDetail.set("taxamount", (Object)taxamount);
            }
            if (taxDetail.containsProperty("exrate") && income.containsProperty("exrate")) {
                taxDetail.set("exrate", income.get("exrate"));
            }
            if (taxDetail.containsProperty("accountorg") && taxDetail.containsProperty("bizdimensiontype")) {
                taxDetail.set("accountorg", (Object)income.getLong("accountorg"));
                taxDetail.set("bizdimensionname", (Object)income.getString("bizdimensionname"));
                taxDetail.set("bizdimensionid", (Object)income.getString("bizdimensionid"));
                taxDetail.set("bizdimensiontype", income.get("bizdimensiontype"));
            }
            taxDetail.set("type", (Object)type);
            taxDetail.set("taxrate", (Object)taxrateBig);
            list.add(taxDetail);
        }
        return list;
    }

    private static List<String> getSbbIds(List<Long> orgIds, Date startDate, Date endDate, DynamicObject table, String entryName) {
        List<String> sbbIds = new ArrayList<String>();
        QFilter tableid = new QFilter("id", "=", (Object)table.getLong("id"));
        QFilter[] filters = new QFilter[]{tableid};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,subname,ischild,entryentity.id,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])filters);
        DynamicObject orgstate = collection.stream().filter(s -> "true".equals(s.getString("entryentity.orgstate"))).findFirst().orElseGet(() -> new DynamicObject());
        DynamicObject datastate = collection.stream().filter(s -> "true".equals(s.getString("entryentity.datastate"))).findFirst().orElseGet(() -> new DynamicObject());
        QFilter orgFilter = new QFilter(orgstate.getString("entryentity.fieldname"), "in", orgIds);
        QFilter skssqqFilter = new QFilter(datastate.getString("entryentity.fieldname"), ">=", (Object)DateUtils.getDayFirst((Date)startDate));
        QFilter skssqzFilter = new QFilter(datastate.getString("entryentity.fieldname"), "<=", (Object)DateUtils.getDayLast((Date)endDate));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            sbbIds = dynamicObjects.stream().map(s -> s.getString("id")).collect(Collectors.toList());
        }
        return sbbIds;
    }

    public static DynamicObjectCollection getResultByRule(Long orgid, DynamicObject setting, QFilter filter, String fields) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        DynamicObject table = setting.getDynamicObject("table");
        String entryName = table.getString("name");
        filterList.add(filter);
        Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
        RuleSettingUtils.setFilter(fieldMap, filterList, String.valueOf(orgid), null);
        String conditionjson = setting.getString("conditionjson");
        if (StringUtils.isNotBlank((String)conditionjson)) {
            QFilter invoiceSettingFilter = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName);
            filterList.add(invoiceSettingFilter);
        }
        return QueryServiceHelper.query((String)entryName, (String)fields, (QFilter[])filterList.toArray(new QFilter[0]));
    }
}

