/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.util.dimension;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.enums.ruletemplate.RuleConfigEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCustomSourceDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.utils.EntityUtils;
import kd.taxc.bdtaxr.common.utils.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.utils.rule.RuleAccessUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DimensionServiceHelper {
    private static final Log logger = LogFactory.getLog(DimensionServiceHelper.class);

    public List<Map<String, Object>> queryGroupBizData(Long orgId, Date startDate, Date endDate, Long tableId, String selectKey, String amountField, String selectKeyEntity, List<QFilter> filterList, String accesslogic, Long categoryId, String draftPurpose) {
        CustomSource customSource;
        Map<Long, QFilter> longQFilterMap = this.handledataSourceMappingMap(tableId, orgId, categoryId, startDate, endDate);
        List<Long> raltionOrgIds = this.getOrgListByRelation(Collections.singletonList(orgId), startDate, endDate, tableId);
        boolean hasDataSourceMapping = DimensionServiceHelper.isDimension(ObjectUtils.isNotEmpty(longQFilterMap), longQFilterMap.containsKey(tableId));
        if (hasDataSourceMapping) {
            if (logger.isDebugEnabled()) {
                logger.info("tableid: {} , hasDataSourceMapping:{}", (Object)tableId, (Object)SerializationUtils.toJsonString((Object)longQFilterMap.get(tableId)));
            }
            customSource = this.setCustomSourceValue(tableId, raltionOrgIds, SerializationUtils.toJsonString((Object)longQFilterMap.get(tableId)), DateUtils.formatHMS((Date)startDate), DateUtils.formatHMS((Date)endDate), accesslogic, selectKey, selectKeyEntity);
        } else {
            customSource = this.setCustomSourceValue(tableId, raltionOrgIds, DateUtils.formatHMS((Date)startDate), DateUtils.formatHMS((Date)endDate), accesslogic, selectKey, selectKeyEntity);
        }
        CustomSource.EntityField orgState = customSource.getOrgstate();
        String orgFileName = orgState.getFieldname();
        String mainEntity = customSource.getEntityname();
        String subEntity = customSource.getSubname();
        List accessmapFileds = customSource.getAllAccessmapFiled();
        String gruopFields = null;
        if (DimensionServiceHelper.isDimension(accessmapFileds.size() > 0, hasDataSourceMapping)) {
            gruopFields = accessmapFileds.stream().map(a -> a.getFieldsubname() + "." + a.getFieldname()).collect(Collectors.joining(","));
            gruopFields = gruopFields.replaceAll(selectKeyEntity + ".", "");
        }
        StringBuilder selectString = new StringBuilder(selectKey);
        String selectOrgField = this.generateKey(mainEntity, subEntity, orgState.getFieldsubname(), orgFileName);
        DimensionServiceHelper.buildKey(selectString, selectOrgField);
        DimensionServiceHelper.buildKey(selectString, gruopFields);
        if (logger.isDebugEnabled()) {
            logger.info("tableid: {} groupFields:{}", (Object)tableId, (Object)gruopFields);
        }
        DataSet data = TaxcCustomSourceDataServiceHelper.queryBizDataRetDoc((long)orgId, (String)DateUtils.formatHMS((Date)startDate), (String)DateUtils.formatHMS((Date)DateUtils.getLastDateOfMonth((Date)endDate)), (long)tableId, (String)selectString.toString(), filterList, (String)accesslogic);
        List<Map<String, Object>> result = this.handlerGroupResult(draftPurpose, customSource, amountField, data, orgId, categoryId, hasDataSourceMapping, tableId, startDate, endDate);
        return result;
    }

    private String generateKey(String mainEntity, String subEntity, String selectKeyEntity, String selectKey) {
        String[] keys = this.splitSelectKey(selectKey);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        if (mainEntity.equals("tpo_declare_main_tsd") || mainEntity.equals("tpo_declare_main_tsc")) {
            return selectKey;
        }
        String selectField = keys[0];
        if (null != mainEntityType.findProperty(selectField)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)mainEntity)) {
                return selectField;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)selectKeyEntity, (CharSequence)subEntity)) {
                if (mainEntityType.findProperty(selectKeyEntity) instanceof EntryProp) {
                    return subEntity + "." + selectField;
                }
                if (mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp) {
                    return "sum(" + mainEntityType.findProperty(selectKeyEntity).getParent().getName() + "." + selectKeyEntity + "." + selectField + ")";
                }
                return selectField;
            }
            if (mainEntityType.findProperty(selectKeyEntity) instanceof SubEntryProp && StringUtils.equalsIgnoreCase((CharSequence)mainEntityType.findProperty(selectKeyEntity).getParent().getName(), (CharSequence)subEntity)) {
                return subEntity + "." + selectKeyEntity + "." + selectField;
            }
            return null;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)selectKeyEntity);
        if (null == entityType || null == entityType.findProperty(selectField)) {
            return null;
        }
        return selectField;
    }

    private static void buildKey(StringBuilder stringBuilder, String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            if (StringUtils.isNotBlank((CharSequence)stringBuilder)) {
                stringBuilder.append(",").append(key);
            } else {
                stringBuilder.append(key);
            }
        }
    }

    private CustomSource setCustomSourceValue(long tableId, Object orgId, String startDate, String endDate, String accessLogic, String selectKey, String selectKeyEntity) {
        CustomSource customSource = TaxcCustomSourceDataServiceHelper.queryCustomSource((Long)tableId);
        customSource.setSelectKey(selectKey);
        customSource.setSelectKeyEntity(selectKeyEntity);
        customSource.getOrgstate().setValue(orgId);
        Date tempStartDate = DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)startDate));
        Date tempEndDate = DateUtils.getDayLast((Date)DateUtils.stringToDate((String)endDate));
        ImmutablePair<Date, Date> dataPair = ImmutablePair.of((Object)tempStartDate, (Object)tempEndDate);
        if (StringUtils.isNotEmpty((CharSequence)accessLogic)) {
            dataPair = this.setQueryDateByAccessLogic(tempStartDate, tempEndDate, accessLogic);
        }
        if (null != customSource.getDatastate()) {
            customSource.getDatastate().setValue((Object)new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        } else {
            customSource.getYearstate().setValue((Object)new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        }
        this.handleCustomDateOrYearState(customSource);
        return customSource;
    }

    private CustomSource setCustomSourceValue(long tableId, Object orgId, String orgMappingQfilter, String startDate, String endDate, String accessLogic, String selectKey, String selectKeyEntity) {
        CustomSource customSource = TaxcCustomSourceDataServiceHelper.queryCustomSource((Long)tableId);
        customSource.setSelectKey(selectKey);
        customSource.setSelectKeyEntity(selectKeyEntity);
        customSource.getOrgstate().setValue(orgId);
        customSource.getAccessmapstate().setValue(JSONObject.parseObject((String)orgMappingQfilter).get((Object)"value"));
        Date tempStartDate = DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)startDate));
        Date tempEndDate = DateUtils.getDayLast((Date)DateUtils.stringToDate((String)endDate));
        ImmutablePair<Date, Date> dataPair = ImmutablePair.of((Object)tempStartDate, (Object)tempEndDate);
        if (StringUtils.isNotEmpty((CharSequence)accessLogic)) {
            dataPair = this.setQueryDateByAccessLogic(tempStartDate, tempEndDate, accessLogic);
        }
        if (null != customSource.getDatastate()) {
            customSource.getDatastate().setValue((Object)new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        } else {
            customSource.getYearstate().setValue((Object)new Date[]{(Date)dataPair.getLeft(), (Date)dataPair.getRight()});
        }
        this.handleCustomDateOrYearState(customSource);
        return customSource;
    }

    private void handleCustomDateOrYearState(CustomSource customSource) {
        String fieldEntity;
        CustomSource.EntityField yearState;
        String fieldEntity2;
        String mainEntity = customSource.getEntityname();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        CustomSource.EntityField dataState = customSource.getDatastate();
        if (null != dataState && DimensionServiceHelper.isDimension(!StringUtils.equalsIgnoreCase((CharSequence)mainEntity, (CharSequence)(fieldEntity2 = dataState.getFieldsubname())), null != mainEntityType.findProperty(fieldEntity2))) {
            dataState.setFieldname(fieldEntity2 + "." + dataState.getFieldname());
        }
        if (null != (yearState = customSource.getYearstate()) && DimensionServiceHelper.isDimension(!StringUtils.equalsIgnoreCase((CharSequence)mainEntity, (CharSequence)(fieldEntity = yearState.getFieldsubname())), null != mainEntityType.findProperty(fieldEntity))) {
            yearState.setFieldname(fieldEntity + "." + yearState.getFieldname());
        }
    }

    public List<Map<String, Object>> handlerGroupResult(String draftPurpose, CustomSource customSource, String amountField, DataSet dataSet, Long orgId, Long categoryId, Boolean isHasMapping, Long tableId, Date startDate, Date endDate) {
        DynamicObject provisionPlan = DeclareServiceHelper.queryOneProvisionPlan(Collections.singletonList(orgId), (Date)startDate, (Date)endDate, (Long)1L, (Long)1L, (String)draftPurpose);
        String provisiondimension = provisionPlan.getString("ruleentity.rule.provisiondimension");
        Long defalulOrgId = null;
        DynamicObject businessdimensionObj = null;
        Long businessdimensionId = null;
        if (StringUtils.isNotEmpty((CharSequence)provisiondimension)) {
            defalulOrgId = this.buildDefaultOrg(orgId, tableId, provisiondimension, defalulOrgId);
            if (provisiondimension.contains("businessdimension") && provisionPlan != null) {
                businessdimensionId = provisionPlan.getLong("ruleentity.rule.businessdimension.fbasedataid.id");
                businessdimensionObj = this.getDefaultBusinessDimensionObj(orgId, categoryId, startDate, endDate, businessdimensionObj, businessdimensionId);
            }
        }
        CustomSource.EntityField orgState = customSource.getOrgstate();
        String orgFileName = orgState.getFieldname();
        CustomSource.EntityField accessmapstate = customSource.getAccessmapstate();
        String selectOrgField = this.generateKey(customSource.getEntityname(), customSource.getSubname(), orgState.getFieldsubname(), orgFileName);
        String selectAccessField = null;
        if (accessmapstate != null) {
            String accessField = accessmapstate.getFieldname();
            selectAccessField = this.generateKey(customSource.getEntityname(), customSource.getSubname(), accessmapstate.getFieldsubname(), accessField);
        }
        String entityName = null;
        TaxResult result = null;
        Map<Object, DynamicObject> mappingObjects = null;
        if (businessdimensionId != null) {
            result = TaxcOrgMappingDataServiceHelper.getOrgMappingPlanByIds(Collections.singletonList(businessdimensionId));
            if (result != null && CollectionUtils.isNotEmpty((Collection)((Collection)result.getData()))) {
                entityName = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObject("mapobject").getString("id");
            }
            if (DimensionServiceHelper.isDimension(Boolean.TRUE, accessmapstate != null && accessmapstate.getValue() != null)) {
                mappingObjects = DimensionServiceHelper.getMappingObject((List)accessmapstate.getValue(), entityName);
            }
        }
        if (dataSet == null || dataSet.isEmpty()) {
            Map<String, Object> dataMap = this.buildDefaultMap();
            if (defalulOrgId == null) {
                dataMap.put("accountorg", null);
            } else {
                dataMap.put("accountorg", defalulOrgId);
            }
            if (businessdimensionObj != null) {
                this.buildDefaultBusinessDimension(businessdimensionObj, dataMap);
            }
            return Collections.singletonList(dataMap);
        }
        return this.buildData(amountField, dataSet, isHasMapping, provisiondimension, defalulOrgId, businessdimensionObj, provisionPlan, selectOrgField, selectAccessField, entityName, mappingObjects);
    }

    private DynamicObject getDefaultBusinessDimensionObj(Long orgId, Long categoryId, Date startDate, Date endDate, DynamicObject businessdimensionObj, Long businessdimensionId) {
        Optional<DynamicObject> first;
        DynamicObjectCollection objs = DimensionServiceHelper.getOrgMappingByOrgIdAndCategoryIdAndGroup(orgId, categoryId, businessdimensionId, startDate, endDate);
        if (DimensionServiceHelper.isDimension(Boolean.TRUE, objs != null && objs.size() > 0) && (first = objs.stream().filter(o -> o.getBoolean("entryentity.isdefault")).findFirst()).isPresent()) {
            businessdimensionObj = first.get();
        }
        return businessdimensionObj;
    }

    private Map<String, Object> buildDefaultMap() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("fetchamount", BigDecimal.ZERO);
        dataMap.put("bizdimensiontype", null);
        dataMap.put("bizdimensionname", null);
        dataMap.put("bizdimensionid", null);
        dataMap.put("accountorg", null);
        return dataMap;
    }

    private Long buildDefaultOrg(Long orgId, Long tableId, String provisiondimension, Long defalulOrgId) {
        String orgFunc = DimensionServiceHelper.getOrgFunc(tableId);
        if (!OrgFuncEnum.ACCOUNT.getNumber().equals(orgFunc) || provisiondimension.contains("accountorg")) {
            defalulOrgId = DimensionServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId(orgId);
        }
        return defalulOrgId;
    }

    private List<Map<String, Object>> buildData(String amountField, DataSet dataSet, Boolean isHasMapping, String provisiondimension, Long defalulOrgId, DynamicObject businessdimensionObj, DynamicObject businessdimension, String selectOrgField, String selectAccessField, String entityName, Map<Object, DynamicObject> mappingObjects) {
        Map<String, List<DynamicObject>> groupByFieldsWithDetailMap;
        DynamicObjectCollection ruleDetailCollection;
        GroupbyDataSet groupbyDataSet;
        if (DimensionServiceHelper.isDimension(isHasMapping, StringUtils.isNotBlank((CharSequence)selectAccessField))) {
            groupbyDataSet = dataSet.copy().groupBy(new String[]{selectOrgField, selectAccessField});
            ruleDetailCollection = ORM.create().toPlainDynamicObjectCollection(dataSet.copy());
            groupByFieldsWithDetailMap = ruleDetailCollection.stream().collect(Collectors.groupingBy(d -> d.getString(selectOrgField) + d.getString(selectAccessField)));
        } else {
            groupbyDataSet = dataSet.copy().groupBy(new String[]{selectOrgField});
            ruleDetailCollection = ORM.create().toPlainDynamicObjectCollection(dataSet.copy());
            groupByFieldsWithDetailMap = ruleDetailCollection.stream().collect(Collectors.groupingBy(d -> d.getString(selectOrgField)));
        }
        groupbyDataSet.sum(amountField);
        DataSet newDataSet = groupbyDataSet.finish();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (Row subRow : newDataSet.copy()) {
            Map<String, Object> dataMap = this.buildDefaultMap();
            dataMap.put("fetchamount", subRow.get(amountField));
            if (subRow.get(selectOrgField) != null) {
                dataMap.put("accountorg", subRow.get(selectOrgField));
            } else {
                dataMap.put("accountorg", defalulOrgId);
            }
            if (provisiondimension.contains("businessdimension")) {
                if (mappingObjects != null && mappingObjects.containsKey(subRow.get(selectAccessField))) {
                    dataMap.put("bizdimensiontype", entityName);
                    dataMap.put("bizdimensionname", mappingObjects.get(subRow.get(selectAccessField)).getString("name"));
                    dataMap.put("bizdimensionid", subRow.get(selectAccessField));
                } else {
                    if (isHasMapping.booleanValue()) continue;
                    if (null != businessdimensionObj) {
                        this.buildDefaultBusinessDimension(businessdimensionObj, dataMap);
                    }
                }
            }
            if (DimensionServiceHelper.isDimension(isHasMapping, StringUtils.isNotBlank((CharSequence)selectAccessField))) {
                dataMap.put("ruleListDetail", groupByFieldsWithDetailMap.get(subRow.getString(selectOrgField) + subRow.getString(selectAccessField)));
            } else {
                dataMap.put("ruleListDetail", groupByFieldsWithDetailMap.get(subRow.getString(selectOrgField)));
            }
            data.add(dataMap);
        }
        return data;
    }

    private static boolean isDimension(Boolean isHasMapping, boolean notBlank) {
        return isHasMapping != false && notBlank;
    }

    private void buildDefaultBusinessDimension(DynamicObject businessdimensionObj, Map<String, Object> dataMap) {
        dataMap.put("bizdimensiontype", businessdimensionObj.get("group.mapobject.id"));
        dataMap.put("bizdimensionname", businessdimensionObj.getString("entryentity.businessname"));
        String id = businessdimensionObj.getString("entryentity.businessid");
        boolean longPk = EntityUtils.isLongPk((String)businessdimensionObj.getString("group.mapobject.id"));
        dataMap.put("bizdimensionid", longPk ? Long.valueOf(id) : id);
    }

    private String[] splitSelectKey(String selectKey) {
        String[] key = selectKey.split(",");
        return key;
    }

    private ImmutablePair<Date, Date> setQueryDateByAccessLogic(Date startDate, Date endDate, String accessLogic) {
        if (accessLogic.equals(RuleConfigEnum.CUMULATIVE.getRuleConfigCode())) {
            startDate = DateUtils.getFirstDateOfYear((Date)startDate);
        }
        if (accessLogic.equals(RuleConfigEnum.TOBEGIN.getRuleConfigCode())) {
            startDate = DateUtils.getFirstDateOfMonth((Date)startDate);
            endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        }
        if (accessLogic.equals(RuleConfigEnum.TOEND.getRuleConfigCode())) {
            startDate = DateUtils.getFirstDateOfMonth((Date)endDate);
            endDate = DateUtils.getLastDateOfMonth((Date)endDate);
        }
        if (accessLogic.equals(RuleConfigEnum.SQQMS.getRuleConfigCode())) {
            startDate = DateUtils.addMonth((Date)startDate, (int)-1);
            endDate = DateUtils.getLastDateOfMonth((Date)startDate);
        }
        if (accessLogic.equals(RuleConfigEnum.SNLJS.getRuleConfigCode())) {
            Date tempStartDate = startDate;
            startDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)startDate, (int)-1));
            endDate = DateUtils.getLastDateOfYear((Date)DateUtils.addYear((Date)tempStartDate, (int)-1));
        }
        if (accessLogic.equals(RuleConfigEnum.SNTQS.getRuleConfigCode())) {
            startDate = DateUtils.addMonth((Date)startDate, (int)-12);
            endDate = DateUtils.addMonth((Date)endDate, (int)-12);
        }
        if (accessLogic.equals(RuleConfigEnum.SNXQS.getRuleConfigCode())) {
            if (DateUtils.isSameDay((Date)startDate, (Date)endDate)) {
                startDate = DateUtils.addTime((Date)startDate, (int)-1, (int)0, (int)1);
                endDate = DateUtils.addTime((Date)endDate, (int)-1, (int)0, (int)1);
            } else {
                int monthOffSet = DateUtils.getMonthSpan((Date)startDate, (Date)endDate);
                startDate = DateUtils.addMonth((Date)startDate, (int)(-12 + monthOffSet));
                endDate = DateUtils.addMonth((Date)endDate, (int)(-12 + monthOffSet));
            }
        }
        if (accessLogic.equals(RuleConfigEnum.SNXXQS.getRuleConfigCode())) {
            if (DateUtils.isSameDay((Date)startDate, (Date)endDate)) {
                startDate = DateUtils.addTime((Date)startDate, (int)-1, (int)0, (int)2);
                endDate = DateUtils.addTime((Date)endDate, (int)-1, (int)0, (int)2);
            } else {
                int monthOffSet = DateUtils.getMonthSpan((Date)startDate, (Date)endDate);
                startDate = DateUtils.addMonth((Date)startDate, (int)(-12 + monthOffSet * 2));
                endDate = DateUtils.addMonth((Date)endDate, (int)(-12 + monthOffSet * 2));
            }
        }
        if (accessLogic.equals(RuleConfigEnum.SNZHQS.getRuleConfigCode())) {
            if (DateUtils.isSameDay((Date)startDate, (Date)endDate)) {
                Date lastYear = DateUtils.addTime((Date)startDate, (int)-1, (int)0, (int)0);
                Date lastYearLastDay = DateUtils.getLastDateOfYear((Date)lastYear);
                startDate = DateUtils.getDayFirst((Date)lastYearLastDay);
                endDate = DateUtils.getDayLast((Date)lastYearLastDay);
            } else {
                int monthOffSet = DateUtils.getMonthSpan((Date)startDate, (Date)endDate);
                endDate = DateUtils.addMonth((Date)endDate, (int)-12);
                endDate = DateUtils.getLastDateOfYear((Date)endDate);
                endDate = DateUtils.getLastDateOfMonth((Date)endDate);
                startDate = DateUtils.addMonth((Date)endDate, (int)(-monthOffSet + 1));
                startDate = DateUtils.getFirstDateOfMonth((Date)startDate);
            }
        }
        return ImmutablePair.of((Object)startDate, (Object)endDate);
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    private Map<Long, QFilter> handledataSourceMappingMap(Long tableId, Long orgId, Long categoryId, Date startDate, Date endDate) {
        Map<Long, Object> dataSourceResultMap = new HashMap<Long, QFilter>(8);
        TaxResult dataSourceMappingList = TaxcOrgMappingDataServiceHelper.getDataSourceMappingList(Collections.singletonList(tableId), (Long)orgId, (Date)startDate, (Date)endDate, (Long)categoryId);
        if (ObjectUtils.isNotEmpty((Object)dataSourceMappingList) && dataSourceMappingList.isSuccess() && ObjectUtils.isNotEmpty((Object)dataSourceMappingList.getData())) {
            Map dataSourceMap = (Map)dataSourceMappingList.getData();
            dataSourceResultMap = FilterBuilderUtils.buildMappingQfilter((Map)dataSourceMap);
        }
        return dataSourceResultMap;
    }

    private List<Long> getOrgListByRelation(List<Long> orgList, Date skssqq, Date skssqz, Long tableId) {
        DynamicObject dataSourceObject = BusinessDataServiceHelper.loadSingleFromCache((Object)tableId, (String)"tctb_custom_datasource");
        String entryName = dataSourceObject.getString("entityname");
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(orgList, (Date)skssqq, (Date)skssqz);
        Map fieldMap = RuleAccessUtil.getTableFields((Long)tableId);
        String org = (String)fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            orgList = TaxOrgTakeRelationServiceHelper.getOrgListByRelation((Map)orgRelationMap, orgList, (String)entryName, (String)entityKey, (String)orgFieldName);
        }
        return orgList;
    }

    private static Long getDefaultAccountingOrgIdByTaxcOrgId(Long taxOrgId) {
        TaxResult result = OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)taxOrgId);
        if (result != null && result.isSuccess() && result.getData() != null) {
            return (Long)result.getData();
        }
        return null;
    }

    private static String getOrgFunc(Long tableId) {
        Map fieldMap = RuleAccessUtil.getTableFields((Long)tableId);
        String entityName = (String)fieldMap.get("entity");
        String org = (String)fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entityName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            return MetadataUtil.getOrgFun((String)entityName, (String)entityKey, (String)orgFieldName);
        }
        return null;
    }

    private static DynamicObjectCollection getOrgMappingByOrgIdAndCategoryIdAndGroup(Long orgId, Long categoryId, Long mappingObjectId, Date startDate, Date endDate) {
        TaxResult result = TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIdAndCategoryIdAndGroup((Long)orgId, (Long)categoryId, (Long)mappingObjectId, (Date)startDate, (Date)endDate);
        if (result != null && result.isSuccess() && result.getData() != null) {
            return (DynamicObjectCollection)result.getData();
        }
        return null;
    }

    private static Map<Object, DynamicObject> getMappingObject(List<Object> ids, String entityName) {
        try {
            DynamicObject[] objects;
            boolean longPk = EntityUtils.isLongPk((String)entityName);
            if (longPk) {
                List idList = ids.stream().map(o -> Long.valueOf(String.valueOf(o))).collect(Collectors.toList());
                objects = BusinessDataServiceHelper.load((String)entityName, (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            } else {
                List idList = ids.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
                objects = BusinessDataServiceHelper.load((String)entityName, (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            }
            if (DimensionServiceHelper.isDimension(Boolean.TRUE, objects != null && objects.length > 0)) {
                return Arrays.stream(objects).collect(Collectors.toMap(d -> d.get("id"), v -> v));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

