/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.util.strategy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.task.util.InvoiceTaskUtils;
import kd.taxc.tcvat.business.service.engine.task.util.NewRuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.strategy.Strategy;
import kd.taxc.tcvat.business.service.rule.RuleService;

public class DefaultStraegy
implements Strategy<DynamicObjectCollection, DynamicObject, List<QFilter>, String, String, String, Map<String, Object>> {
    private RuleService ruleService = new RuleService();
    private final Set<String> TEMPLATETYPE = Sets.newHashSet((Object[])new String[]{"zzsybnsr", "zzsybnsr_hz_zjg", "zzsybnsr_ybhz", "zzsybnsr_yz_zjg"});

    @Override
    public DynamicObjectCollection queryInvoice(DynamicObject setting, List<QFilter> filterList, String taxRate, String filterIdName, String pkFieldName, Map<String, Object> customParams) {
        String amountName = (String)customParams.get("amountName");
        String entryName = (String)customParams.get("entityname");
        String conditionjson = (String)customParams.get("conditionjson");
        String entityType = (String)customParams.get("entityType");
        String fieldName = (String)customParams.get("fieldName");
        Boolean differenceInvoice = null != customParams.get("differenceinvoice") ? (Boolean)customParams.get("differenceinvoice") : Boolean.FALSE;
        String startDate = (String)customParams.get("startDate");
        String endDate = (String)customParams.get("endDate");
        Date start = DateUtils.stringToDate((String)startDate);
        Date end = DateUtils.stringToDate((String)endDate);
        String entryId = (String)customParams.get("entityid");
        String ruleEntry = (String)customParams.get("ruleEntry");
        String taxPayerType = (String)customParams.get("taxPayerType");
        QFilter conditionFilters = this.ruleService.parseCondition(conditionjson, entryName);
        if (conditionFilters != null) {
            filterList.add(conditionFilters);
        }
        ArrayList<QFilter> noDetailFilters = new ArrayList<QFilter>(filterList);
        boolean isQtfpqsAndXxsr = NewRuleSettingUtils.qtfpIncomeRuleList.contains(entityType) && Objects.equals(fieldName, "otherinvoiceamount") && Objects.equals(entryName, "sim_vatinvoice");
        boolean isQtfpseAndXxse = NewRuleSettingUtils.qtfpIncomeRuleList.contains(entityType) && Objects.equals(fieldName, "othertaxamount") && Objects.equals(entryName, "sim_vatinvoice");
        boolean isWkpseAndXxse = NewRuleSettingUtils.qtfpIncomeRuleList.contains(entityType) && Arrays.asList("otherinvoiceamount", "othertaxamount").contains(fieldName) && Objects.equals(entryName, "sim_vatinvoice_vehicles");
        this.ruleService.addRuleFilter(entityType, entryName, differenceInvoice, taxRate, isQtfpqsAndXxsr, isQtfpseAndXxse, isWkpseAndXxse, filterList);
        this.ruleService.setGlFilter(entryName, amountName, start, end, filterList);
        DynamicObjectCollection detailCollection = QueryServiceHelper.query((String)entryName, (String)filterIdName, (QFilter[])filterList.toArray(new QFilter[0]));
        String finalFilterId = filterIdName;
        List<Long> detailIds = detailCollection.stream().map(id -> id.getLong(finalFilterId)).collect(Collectors.toList());
        DynamicObjectCollection noSubEntryDetails = this.ruleService.queryNoDetailIds(entryName, differenceInvoice, isQtfpqsAndXxsr, isQtfpseAndXxse, taxRate, detailIds, noDetailFilters, filterIdName);
        detailCollection.addAll((Collection)noSubEntryDetails);
        detailCollection = this.simVatInvoiceHandler(entryId, entryName, ruleEntry, taxPayerType, filterIdName, setting, detailCollection);
        return detailCollection;
    }

    public DynamicObjectCollection simVatInvoiceHandler(String entryId, String entryName, String ruleEntry, String taxPayerType, String filterIdName, DynamicObject ruleObj, DynamicObjectCollection detailCollection) {
        if (entryName.equals("sim_vatinvoice") && "tcvat_rule_income".equals(ruleEntry) && this.TEMPLATETYPE.contains(taxPayerType) && "1835580761286481920".equals(entryId)) {
            detailCollection = InvoiceTaskUtils.jzjtStrategy(detailCollection, filterIdName, "subinvoiceid", null != ruleObj ? ruleObj.getString("jzjt") : "");
        }
        return detailCollection;
    }
}

