/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.engine.task.ybnsr;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.task.util.RuleCalcDetailParam;
import kd.taxc.tcvat.business.service.engine.task.util.RuleSettingUtils;
import kd.taxc.tcvat.business.service.engine.task.util.YbnsrNewRuleSettingUtils;
import org.apache.commons.lang.StringUtils;

public class YbnsrNewRuleSettingTask
extends Task<List<DynamicObject>> {
    private static Log logger = LogFactory.getLog(YbnsrNewRuleSettingTask.class);
    private int batchSize = 5;
    private Map<String, String> allInvoiceItemIdBeUsedMap;
    private Map<String, Map<String, Object>> repeatInvoiceDataMap;
    private DynamicObject rule;
    private EngineModel model;
    private DynamicObjectCollection collection;
    private String taxaccountserialno;
    private String entityType;
    private String taxRate;
    private String suffix = "";
    private String type;
    private String taxperiod;

    public YbnsrNewRuleSettingTask(Map<String, String> allInvoiceItemIdBeUsedMap, Map<String, Map<String, Object>> repeatInvoiceDataMap, DynamicObject rule, EngineModel model, DynamicObjectCollection collection, String taxaccountserialno, String entityType, String taxRate, String suffix, String type, String taxperiod) {
        this.allInvoiceItemIdBeUsedMap = allInvoiceItemIdBeUsedMap;
        this.repeatInvoiceDataMap = repeatInvoiceDataMap;
        this.rule = rule;
        this.model = model;
        this.collection = collection;
        this.taxaccountserialno = taxaccountserialno;
        this.entityType = entityType;
        this.taxRate = taxRate;
        this.suffix = suffix;
        this.type = type;
        this.taxperiod = taxperiod;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition((List)this.collection, (int)this.batchSize);
    }

    public List<DynamicObject> executor(List<DynamicObject> settings) {
        logger.info("{}\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c", (Object)RequestContext.get().getRequestId());
        long start = System.currentTimeMillis();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(settings.size());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        this.taxperiod = this.taxperiod == null ? this.model.getStartDate() : this.taxperiod;
        Date firstDayOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)this.taxperiod, (String)"yyyy-MM"));
        Date lastDayOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)this.taxperiod, (String)"yyyy-MM"));
        Map<String, BigDecimal> exrateMap = RuleSettingUtils.getExrateMap(this.suffix, settings, firstDayOfMonth, lastDayOfMonth);
        for (DynamicObject setting : settings) {
            DynamicObject table = setting.getDynamicObject("table" + this.suffix);
            String entryName = table.getString("name");
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            String dataField = (String)fieldMap.get("datastate");
            if (null != dataField) {
                if (StringUtils.equals((String)"til_in_transfer_out_bill", (String)entryName)) {
                    QFilter periodFilter = new QFilter(dataField, "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)firstDayOfMonth, (String)"yyyy-MM-dd HH:mm:ss")));
                    filterList.add(periodFilter);
                } else {
                    QFilter startFilter = new QFilter(dataField, ">=", (Object)firstDayOfMonth);
                    QFilter endFilter = new QFilter(dataField, "<=", (Object)lastDayOfMonth);
                    filterList.add(startFilter);
                    filterList.add(endFilter);
                }
            }
            YbnsrNewRuleSettingUtils.setFilter(this.rule, fieldMap, this.model, filterList, this.taxperiod, entryName);
            BigDecimal exrate = BigDecimal.ZERO;
            if (setting.containsProperty("exratejson" + this.suffix)) {
                String exratejson = setting.getString("exratejson" + this.suffix);
                exrate = exrateMap.getOrDefault(exratejson, BigDecimal.ZERO);
            }
            RuleCalcDetailParam detailParam = new RuleCalcDetailParam(entryName, this.suffix, this.entityType, this.taxRate, "tcvat_accdetail_rollout", exrate, this.type, this.taxaccountserialno);
            YbnsrNewRuleSettingUtils.calAmount(this.allInvoiceItemIdBeUsedMap, Long.parseLong(this.model.getOrgId()), setting, filterList, this.rule, this.model, this.repeatInvoiceDataMap, list, detailParam, this.taxperiod);
        }
        logger.info("{}\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + ":" + list.size(), (Object)RequestContext.get().getRequestId());
        return list;
    }
}

