/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.fpisa;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import org.apache.commons.lang3.StringUtils;

public class FpisaService {
    public static boolean impotValid(ImportBillData billData, ImportContext ctx, String entryName, ImportLogger logger, Set<String> uniqueFilter) {
        Map option;
        JSONObject data = billData.getData();
        JSONObject org = data.getJSONObject("org");
        String orgName = org.getString("name");
        String orgNumber = org.getString("number");
        Date periodFrom = data.getDate("periodfrom");
        Date periodTo = data.getDate("periodto");
        DynamicObject orgDyo = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        if (StringUtils.isNotBlank((CharSequence)orgName) && orgDyo != null && !orgName.equals(orgDyo.getString("name"))) {
            logger.log(Integer.valueOf(billData.getStartIndex()), ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7a0e\u52a1\u7ec4\u7ec7\u540d\u79f0\u662f\u5426\u6b63\u786e\u3002", (String)"FpisaService_0", (String)"taxc-tcvat", (Object[])new Object[0]));
            logger.fail();
            return false;
        }
        if (orgDyo != null) {
            if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgNum((String)orgNumber).getData()).booleanValue()) {
                logger.log(Integer.valueOf(billData.getStartIndex()), ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\u3002", (String)"FpisaService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                logger.fail();
                return false;
            }
            if (LicenseCheckServiceHelper.check((Object)orgDyo.getLong("id"), null, (String)"tcvat")) {
                logger.log(Integer.valueOf(billData.getStartIndex()), String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u8bb8\u53ef", (String)"FpisaService_2", (String)"taxc-tcvat", (Object[])new Object[0]), orgNumber));
                logger.fail();
                return false;
            }
        }
        if ("new".equals((option = ctx.getOption()).get("importtype").toString())) {
            String uniqueKey = orgNumber + periodFrom + periodTo;
            boolean exists = QueryServiceHelper.exists((String)entryName, (QFilter[])new QFilter[]{new QFilter("org.number", "=", (Object)orgNumber), new QFilter("periodfrom", "=", (Object)periodFrom), new QFilter("periodto", "=", (Object)periodTo)});
            if (!uniqueFilter.add(uniqueKey) || exists) {
                logger.log(Integer.valueOf(billData.getStartIndex()), ResManager.loadKDString((String)"\u6b64\u7a0e\u52a1\u7ec4\u7ec7\u7684\u6240\u5c5e\u7a0e\u671f\u5df2\u5bfc\u5165\u53f0\u8d26\uff0c\u8bf7\u786e\u8ba4\u5f15\u5165\u7c7b\u578b\u662f\u5426\u53d8\u4e3a\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u6216\u8005\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u589e\u52a0\u65b0\u6570\u636e\u201d\u3002", (String)"FpisaService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                logger.fail();
                return false;
            }
        }
        Date first = DateUtils.getFirstDateOfMonth((Date)periodFrom);
        Date last = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)periodFrom));
        if (!first.equals(periodFrom) || !last.equals(periodTo)) {
            logger.log(Integer.valueOf(billData.getStartIndex()), ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5e94\u8be5\u4e3a\u6574\u6708", (String)"FpisaService_4", (String)"taxc-tcvat", (Object[])new Object[0]));
            logger.fail();
            return false;
        }
        BigDecimal five = new BigDecimal("5");
        JSONArray entries = data.getJSONArray("entryentity");
        if (!entries.isEmpty()) {
            boolean isRm = false;
            Set stringSet = entries.stream().map(o -> ((JSONObject)JSON.toJSON((Object)o)).getString("taxexemcode")).collect(Collectors.toSet());
            DynamicObjectCollection queryNumbers = QueryServiceHelper.query((String)"tpo_taxdeduction", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", stringSet)});
            Set queryNumberSet = queryNumbers.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            for (Object entry : entries) {
                boolean exists;
                JSONObject json = (JSONObject)JSON.toJSON(entry);
                BigDecimal rvnInclDiff = BigDecimalUtil.toBigDecimal((Object)json.getString("totalrevenueincltax")).subtract(BigDecimalUtil.toBigDecimal((Object)json.getString("fprevenueincltax"))).subtract(BigDecimalUtil.toBigDecimal((Object)json.getString("loanrevenueincltax")));
                BigDecimal rvnExclDiff = BigDecimalUtil.toBigDecimal((Object)json.getString("totalrevenueexcltax")).subtract(BigDecimalUtil.toBigDecimal((Object)json.getString("fprevenueexcltax"))).subtract(BigDecimalUtil.toBigDecimal((Object)json.getString("loanrevenueexcltax")));
                BigDecimal costExclDiff = BigDecimalUtil.toBigDecimal((Object)json.getString("totalcostexcltax")).subtract(BigDecimalUtil.toBigDecimal((Object)json.getString("fpcostexcltax")));
                if (five.compareTo(rvnInclDiff.abs()) < 0 || five.compareTo(rvnExclDiff) < 0 || five.compareTo(costExclDiff.abs()) < 0) {
                    logger.log(json.getInteger("rowNum"), ResManager.loadKDString((String)"\u603b\u9500\u552e\u989d\u6216\u8005\u603b\u6210\u672c\u8ba1\u7b97\u9519\u8bef\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"FpisaService_5", (String)"taxc-tcvat", (Object[])new Object[0]));
                    if (isRm) continue;
                    logger.fail();
                    isRm = true;
                    continue;
                }
                String jmxzdm = json.getString("taxexemcode");
                if (!StringUtils.isNotBlank((CharSequence)jmxzdm) || (exists = queryNumberSet.contains(jmxzdm))) continue;
                logger.log(json.getInteger("rowNum"), ResManager.loadKDString((String)"\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u672a\u7ef4\u62a4\u5728\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u5bfc\u5165\u3002", (String)"FpisaService_6", (String)"taxc-tcvat", (Object[])new Object[0]));
                if (isRm) continue;
                logger.fail();
                isRm = true;
            }
            return !isRm;
        }
        return true;
    }

    public static void updateShowData(DynamicObject source, DynamicObject show) {
        if (show.getLong("id") == 0L) {
            source.getDynamicObjectType().getProperties().forEach(p -> show.set(p.getName(), source.get(p)));
        } else {
            DataEntityPropertyCollection showProp = show.getDynamicObjectType().getProperties();
            DataEntityPropertyCollection sourceProp = source.getDynamicObjectType().getProperties();
            if (showProp.containsKey((Object)"entryentity.totalrevenueincltax") && sourceProp.containsKey((Object)"entryentity.totalrevenueincltax")) {
                BigDecimal trit = show.getBigDecimal("entryentity.totalrevenueincltax").add(source.getBigDecimal("entryentity.totalrevenueincltax"));
                show.set("entryentity.totalrevenueincltax", (Object)trit);
            }
            if (showProp.containsKey((Object)"entryentity.totalrevenueexcltax") && sourceProp.containsKey((Object)"entryentity.totalrevenueexcltax")) {
                BigDecimal tret = show.getBigDecimal("entryentity.totalrevenueexcltax").add(source.getBigDecimal("entryentity.totalrevenueexcltax"));
                show.set("entryentity.totalrevenueexcltax", (Object)tret);
            }
            if (showProp.containsKey((Object)"entryentity.totalcostexcltax") && sourceProp.containsKey((Object)"entryentity.totalcostexcltax")) {
                BigDecimal tcet = show.getBigDecimal("entryentity.totalcostexcltax").add(source.getBigDecimal("entryentity.totalcostexcltax"));
                show.set("entryentity.totalcostexcltax", (Object)tcet);
            }
        }
    }
}

