/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.tcvat.business.service.subplugin.inputjzjztag.IInputJzjtTagListQuerySubPlugin;
import kd.taxc.tcvat.business.service.subplugin.inputjzjztag.args.AfterQueryDataSetFieldDataArgs;
import kd.taxc.tcvat.business.service.subplugin.inputjzjztag.args.BeforeQuerySetFieldsAndDataTypesArgs;
import kd.taxc.tcvat.business.service.subplugin.inputjzjztag.impl.DefaultInputJzjtTagListQuerySubPlugin;
import kd.taxc.tcvat.common.enums.InputInvoiceFilterEnum;

public class InputInvoiceSummaryQueryService {
    private static final String INPUT_INVOICE_SIGN_TABLE_NAME = "tcvat_input_invoice_sign";
    private static Log logger = LogFactory.getLog(InputInvoiceSummaryQueryService.class);
    private static final Map<String, String> INVOICE_TYPE_MAP = new LinkedHashMap<String, String>();

    public static List<QFilter> getFilterListByField(List<FilterItemInfo> commonFilterItemList) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (null != commonFilterItemList && commonFilterItemList.size() > 0) {
            for (int i = 0; i < commonFilterItemList.size(); ++i) {
                FilterItemInfo item = commonFilterItemList.get(i);
                String name = item.getPropName();
                Object value = item.getValue();
                String compareType = item.getCompareType();
                if (StringUtils.equals((CharSequence)"invoicetype.name", (CharSequence)name)) {
                    name = "invoice_type.name";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"invoicetype.id", (CharSequence)name)) {
                    name = "invoice_type";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"period", (CharSequence)name)) {
                    name = "tax_period";
                    qFilterList.add(new QFilter(name, compareType, value));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"orgs.id", (CharSequence)name) || StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name) || StringUtils.equals((CharSequence)"orgs", (CharSequence)name)) {
                    if (StringUtils.equals((CharSequence)"orgs.name", (CharSequence)name)) {
                        if (StringUtils.isNotBlank((Object)value)) {
                            DynamicObjectCollection dynamicObject = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"name", (Object)value));
                            if (null != dynamicObject && dynamicObject.size() > 0) {
                                value = ((DynamicObject)dynamicObject.get(0)).get("id");
                            }
                        } else {
                            name = "tax_org.name";
                            qFilterList.add(new QFilter(name, compareType, value));
                        }
                    }
                    if (!StringUtils.isNotBlank((Object)value)) continue;
                    name = "tax_org";
                    qFilterList.add(new QFilter(name, compareType, value instanceof String ? Long.valueOf(String.valueOf(value)) : value));
                    continue;
                }
                qFilterList.add(new QFilter(name, compareType, value));
            }
        }
        return qFilterList;
    }

    private static DataSet getSubDataSet(String type, DataSet dataSet, String algoKey) {
        PluginProxy pluginProxy = PluginProxy.create((Object)new DefaultInputJzjtTagListQuerySubPlugin(), IInputJzjtTagListQuerySubPlugin.class, (String)"kd.taxc.tcvat.business.service.subplugin.inputjzjztag.IInputJzjtTagListQuerySubPlugin", null);
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        long defaultPrimaryId = 0L;
        String orgName = "";
        String orgId = "";
        String invoiceType = "";
        String invoiceCode = "";
        String invoiceNo = "";
        String delete = "";
        String taxPeriod = "";
        String salerName = "";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("issystem", "=", (Object)"1")});
        Map<String, String> invoiceTypeMap = dynamicObjects.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("number")));
        QFilter signtype = new QFilter("signtype", "=", (Object)"1");
        QFilter signstatus = new QFilter("signstatus", "=", (Object)"1");
        QFilter dataTypeFilter = new QFilter("type", "!=", (Object)"1");
        DynamicObjectCollection subObject = QueryServiceHelper.query((String)INPUT_INVOICE_SIGN_TABLE_NAME, (String)"invoicepkid,id,currentsigntaxamount,consumertype,createtime", (QFilter[])new QFilter[]{dataTypeFilter, signtype, signstatus}, (String)"modifytime desc");
        for (Row row : dataSet) {
            BigDecimal[] signedtaxamount = new BigDecimal[]{BigDecimalUtil.setScale((Object)BigDecimal.ZERO)};
            String[] consumertype = new String[]{""};
            BigDecimal[] refundabletaxamount = new BigDecimal[]{BigDecimalUtil.setScale((Object)BigDecimal.ZERO)};
            BigDecimal[] undistinguishtaxamount = new BigDecimal[]{BigDecimalUtil.setScale((Object)BigDecimal.ZERO)};
            String invoicePrimaryId = row.getString("id");
            if (StringUtils.isBlank((CharSequence)invoicePrimaryId)) continue;
            orgName = row.getString("orgname");
            orgId = row.getString("org");
            String baseInvoiceTypeId = row.getString("baseinvoicetype");
            invoiceType = invoiceTypeMap.get(baseInvoiceTypeId);
            if (StringUtils.isBlank((CharSequence)type)) {
                type = invoiceType;
            }
            invoiceCode = row.getString("invoicecode");
            invoiceNo = row.getString("invoiceno");
            delete = row.getString("delete");
            String invoiceCodeAndNo = invoiceCode + invoiceNo;
            String selectresult = row.getString("selectresult");
            String certstatus = row.getString("certstatus");
            taxPeriod = DateUtils.formatMonth((Date)row.getDate("taxperiod"));
            salerName = row.getString("salername");
            BigDecimal invoiceamount = BigDecimalUtil.setScale((Object)row.getBigDecimal("invoiceamount"));
            BigDecimal taxamount = BigDecimalUtil.setScale((Object)row.getBigDecimal("taxamount"));
            BigDecimal totalamount = BigDecimalUtil.setScale((Object)row.getBigDecimal("totalamount"));
            BigDecimal effectivetaxamount = BigDecimalUtil.setScale((Object)row.getBigDecimal("effectivetaxamount"));
            AtomicReference createTime = new AtomicReference();
            if (subObject.size() > 0) {
                subObject.forEach(s -> {
                    if (invoiceCodeAndNo.equals(s.getString("invoicepkid"))) {
                        signedtaxamount[0] = signedtaxamount[0].add(BigDecimalUtil.setScale((Object)s.getBigDecimal("currentsigntaxamount")));
                        consumertype[0] = s.getString("consumertype");
                        if ("4".equals(s.getString("consumertype"))) {
                            refundabletaxamount[0] = refundabletaxamount[0].add(BigDecimalUtil.setScale((Object)s.getBigDecimal("currentsigntaxamount")));
                        } else if ("5".equals(s.getString("consumertype"))) {
                            undistinguishtaxamount[0] = undistinguishtaxamount[0].add(BigDecimalUtil.setScale((Object)s.getBigDecimal("currentsigntaxamount")));
                        }
                        if (null == createTime.get()) {
                            createTime.set(s.getDate("createtime"));
                        }
                    }
                });
            }
            BigDecimal avaliabletaxamount = BigDecimalUtil.setScale((Object)effectivetaxamount.subtract(signedtaxamount[0]));
            ArrayList dataShowList = Lists.newArrayList((Object[])new Object[]{defaultPrimaryId, orgId, orgName, invoiceType, invoiceCode, invoiceNo, delete, certstatus, selectresult, taxPeriod, salerName, "", totalamount, invoiceamount, taxamount, effectivetaxamount, avaliabletaxamount, signedtaxamount[0], consumertype[0], refundabletaxamount[0], undistinguishtaxamount[0], createTime.get()});
            AfterQueryDataSetFieldDataArgs afterQueryDataArgs = new AfterQueryDataSetFieldDataArgs();
            afterQueryDataArgs.setOneRowOfDataSet(row);
            afterQueryDataArgs.setDataShowList(dataShowList);
            pluginProxy.callAfter(p -> {
                p.afterQueryDataSetFieldData(afterQueryDataArgs);
                return null;
            });
            coll.add(dataShowList.toArray(new Object[dataShowList.size()]));
        }
        BeforeQuerySetFieldsAndDataTypesArgs args = new BeforeQuerySetFieldsAndDataTypesArgs();
        pluginProxy.callAfter(p -> {
            p.beforeQuerySetFieldsAndDataTypes(args);
            return null;
        });
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])args.getFieldNameList().toArray(new String[args.getFieldNameList().size()]), (DataType[])args.getDataTypeList().toArray(new DataType[args.getDataTypeList().size()]));
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)algoKey).createDataSet(new Input[]{inputs});
    }

    public static DataSet collectDateSet(List<QFilter> commonFilter, List<QFilter> fastOrPlanFilterItemList, String algoKey) {
        DataSet dataSet = null;
        HashSet set = new HashSet();
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>(commonFilter.size());
        for (Map.Entry<String, String> entry : INVOICE_TYPE_MAP.entrySet()) {
            if (set.contains(entry.getValue())) continue;
            set.add(entry.getValue());
            InputInvoiceFilterEnum invoiceTypeEnum2 = InputInvoiceFilterEnum.getInvoiceTypeEnum((String)entry.getValue());
            resultFilter.add(invoiceTypeEnum2.getFilter());
            resultFilter.addAll(commonFilter);
            DataSet newDateSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)((String)entry.getValue()), (String)"serial_no", (QFilter[])resultFilter.toArray(new QFilter[resultFilter.size()]), null);
            resultFilter.clear();
            if (null == dataSet) {
                dataSet = newDateSet;
                continue;
            }
            dataSet = dataSet.union(newDateSet);
        }
        if (null == dataSet) {
            return null;
        }
        ArrayList<String> invoiceSerialNoList = new ArrayList<String>();
        for (Row row : dataSet) {
            invoiceSerialNoList.add(row.getString("serial_no"));
        }
        resultFilter.add(new QFilter("serial_no", "in", invoiceSerialNoList));
        resultFilter.add(new QFilter("delete", "=", (Object)"1"));
        DataSet rimInvoiceDataSet = InputInvoiceSummaryQueryService.queryDataSet(resultFilter, "rim_invoice", "id,tax_org as org,tax_org.name as orgname,delete,invoice_type as baseinvoicetype,invoice_code as invoicecode,invoice_no as invoiceno,authenticate_flag as selectstatus,deduction_purpose as selectresult,authenticate_flag as certstatus,tax_period as taxperiod,saler_name as salername,total_amount as totalamount,invoice_amount as invoiceamount,total_tax_amount as taxamount,effective_tax_amount as effectivetaxamount", algoKey);
        if (fastOrPlanFilterItemList.size() > 0) {
            String filterStr = fastOrPlanFilterItemList.stream().map(o -> o.toString()).collect(Collectors.joining(" and "));
            rimInvoiceDataSet = rimInvoiceDataSet.where(filterStr);
        }
        return rimInvoiceDataSet;
    }

    private static DataSet queryDataSet(List<QFilter> qFilterList, String entity, String selectFields, String algoKey) {
        BeforeQuerySetFieldsAndDataTypesArgs args = new BeforeQuerySetFieldsAndDataTypesArgs();
        PluginProxy pluginProxy = PluginProxy.create((Object)new DefaultInputJzjtTagListQuerySubPlugin(), IInputJzjtTagListQuerySubPlugin.class, (String)"kd.taxc.tcvat.business.service.subplugin.inputjzjztag.IInputJzjtTagListQuerySubPlugin", null);
        pluginProxy.callReplace(p -> {
            p.beforeQuerySetFieldsAndDataTypes(args);
            return null;
        });
        if (!CollectionUtils.isEmpty(args.getFieldNameList())) {
            selectFields = selectFields + "," + String.join((CharSequence)",", args.getFieldNameList());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), null);
        return InputInvoiceSummaryQueryService.getSubDataSet(null, dataSet, algoKey);
    }

    static {
        INVOICE_TYPE_MAP.put("2", "rim_inv_special");
        INVOICE_TYPE_MAP.put("4", "rim_inv_special");
        INVOICE_TYPE_MAP.put("15", "rim_inv_toll");
        INVOICE_TYPE_MAP.put("12", "rim_inv_motor");
        INVOICE_TYPE_MAP.put("27", "rim_inv_electric");
        INVOICE_TYPE_MAP.put("9", "rim_inv_train");
        INVOICE_TYPE_MAP.put("10", "rim_inv_air");
        INVOICE_TYPE_MAP.put("16", "rim_inv_transport");
        INVOICE_TYPE_MAP.put("20", "rim_inv_transport");
        INVOICE_TYPE_MAP.put("21", "rim_inv_custom");
        INVOICE_TYPE_MAP.put("1", "rim_inv_ordinary");
        INVOICE_TYPE_MAP.put("26", "rim_inv_electric");
    }
}

