/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.IReportListModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class InvoiceIdentificationService {
    private static Log logger = LogFactory.getLog(InvoiceIdentificationService.class);
    private static final String TAX_PERIOD_FIELD = "taxperiod";
    private static final String ORG_FIELD = "org";
    private static final String FIELD_SEPARATER = ",";
    private static final String INPUT_INVOICE_SING_FORM_ID = "tcvat_invoice_sign_dialog";

    public static DynamicObjectCollection queryZzsSbb(DynamicObjectCollection rowCollection, IReportListModel model, String pageName, Map<String, String> taxPeriodMap, Map<String, DynamicObjectCollection> dataMap, Map<String, String> orgMap) {
        String currentTaxPeriod = taxPeriodMap.get("currentTaxPeriod");
        long start = System.currentTimeMillis();
        HashSet<String> orgSet = new HashSet<String>(rowCollection.size());
        Iterator iterator = rowCollection.iterator();
        while (iterator.hasNext()) {
            DynamicObjectCollection collection;
            DynamicObject dynamicObject;
            DynamicObject rowData = dynamicObject = (DynamicObject)iterator.next();
            currentTaxPeriod = "tcvat_rollout_sign_list".equals(pageName) ? rowData.getString("rollouttaxperiod") : rowData.getString(TAX_PERIOD_FIELD);
            DynamicObject orgDynObj = rowData.getDynamicObject(ORG_FIELD);
            if (null == orgDynObj) continue;
            String orgid = orgDynObj.getString("id");
            orgSet.add(orgid);
            orgMap.put(orgid, orgDynObj.getString("name"));
            if (null != dataMap.get(orgid + FIELD_SEPARATER + currentTaxPeriod) && dataMap.get(orgid + FIELD_SEPARATER + currentTaxPeriod).size() > 0) {
                collection = dataMap.get(orgid + FIELD_SEPARATER + currentTaxPeriod);
                collection.add((Object)rowData);
                dataMap.put(orgid + FIELD_SEPARATER + currentTaxPeriod, collection);
            } else {
                collection = new DynamicObjectCollection();
                collection.add((Object)rowData);
                dataMap.put(orgid + FIELD_SEPARATER + currentTaxPeriod, collection);
            }
            taxPeriodMap.put("currentTaxPeriod", currentTaxPeriod);
        }
        logger.info("exec InvoiceIdentificationService queryZzsSbb1\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        String startDate = DateUtils.getFirstDateOfMonthStr((Date)DateUtils.stringToDate((String)currentTaxPeriod, (String)"yyyy-MM"), (String)"yyyy-MM-dd");
        String endDate = DateUtils.getLastDateOfMonthStr((Date)DateUtils.stringToDate((String)currentTaxPeriod, (String)"yyyy-MM"), (String)"yyyy-MM-dd");
        DynamicObjectCollection declareDataCollection = YbnsrService.queryZzsSbb(new ArrayList(orgSet), (String)"zzsybnsr", (String)startDate, (String)endDate);
        logger.info("exec InvoiceIdentificationService queryZzsSbb2\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        return declareDataCollection;
    }

    public static Map<String, Object> buildCustomParams(String pageName, Map<String, DynamicObjectCollection> dataMap, String currentTaxPeriod) {
        long start = System.currentTimeMillis();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        BigDecimal effectivetaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal avaliabletaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        BigDecimal signedtaxamount = BigDecimalUtil.setScale((Object)BigDecimal.ZERO);
        ArrayList valueList = new ArrayList();
        String effectiveProperty = "effectivetaxamount";
        if ("tcvat_rollout_sign_list".equals(pageName)) {
            effectiveProperty = "rollouttaxamount";
        }
        int rowSize = 0;
        for (Map.Entry<String, DynamicObjectCollection> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            DynamicObjectCollection dataValue = entry.getValue();
            for (DynamicObject invoiceData : dataValue) {
                HashMap<String, String> invoice = new HashMap<String, String>();
                String invoicePkId = invoiceData.getString("invoicecode") + invoiceData.getString("invoiceno");
                effectivetaxamount = effectivetaxamount.add(BigDecimalUtil.setScale((Object)invoiceData.getBigDecimal(effectiveProperty)));
                avaliabletaxamount = avaliabletaxamount.add(BigDecimalUtil.setScale((Object)invoiceData.getBigDecimal("avaliabletaxamount")));
                signedtaxamount = signedtaxamount.add(BigDecimalUtil.setScale((Object)invoiceData.getBigDecimal("signedtaxamount")));
                invoice.put("invoicecode", invoiceData.getString("invoicecode"));
                invoice.put("invoiceno", invoiceData.getString("invoiceno"));
                invoice.put("invoicetype", invoiceData.getString("type"));
                invoice.put("taxamount", invoiceData.getString("taxamount"));
                invoice.put("effectivetaxamount", invoiceData.getString("effectivetaxamount"));
                invoice.put("signedtaxamount", invoiceData.getString("signedtaxamount"));
                invoice.put("avaliabletaxamount", invoiceData.getString("avaliabletaxamount"));
                invoice.put("invoicepkid", invoicePkId);
                invoice.put(ORG_FIELD, key.split(FIELD_SEPARATER)[0]);
                if ("tcvat_rollout_sign_list".equals(pageName)) {
                    invoice.put("rollouttaxperiod", key.split(FIELD_SEPARATER)[1]);
                    invoice.put("rollouttaxamount", invoiceData.getString("rollouttaxamount"));
                    invoice.put("rollouttype", invoiceData.getString("rollouttype"));
                    invoice.put("primaryid", invoiceData.getString("id"));
                } else {
                    invoice.put(TAX_PERIOD_FIELD, key.split(FIELD_SEPARATER)[1]);
                }
                valueList.add(invoice);
                ++rowSize;
            }
        }
        customParams.put("avaliabletaxamount", avaliabletaxamount);
        customParams.put("signedtaxamount", signedtaxamount);
        customParams.put("rowSize", rowSize);
        customParams.put("valueMap", JsonUtil.toJson(valueList));
        String subPageName = INPUT_INVOICE_SING_FORM_ID;
        if ("tcvat_rollout_sign_list".equals(pageName)) {
            customParams.put("rollouttaxperiod", currentTaxPeriod);
            customParams.put("rollouttaxamount", effectivetaxamount);
            subPageName = "tcvat_rollout_query_frame";
        } else {
            customParams.put(TAX_PERIOD_FIELD, currentTaxPeriod);
            customParams.put("effectivetaxamount", effectivetaxamount);
        }
        logger.info("exec InvoiceIdentificationService buildCustomParams\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        return customParams;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> undosign(DynamicObjectCollection rowCollection, String pageName) {
        DynamicObjectCollection invoiceCol;
        long start = System.currentTimeMillis();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        String currentTaxPeriod = DateUtils.format((Date)new Date(), (String)"yyyy-MM");
        ArrayList<String> invoicePkIdList = new ArrayList<String>();
        ArrayList<String> currentTaxPeriodList = new ArrayList<String>(16);
        ArrayList<Long> orgs = new ArrayList<Long>(16);
        ArrayList rowList = new ArrayList(16);
        for (DynamicObject dynamicObject : rowCollection) {
            DynamicObject rowData = dynamicObject;
            DynamicObject orgDynObj = rowData.getDynamicObject(ORG_FIELD);
            if (null == orgDynObj) continue;
            Long l = orgDynObj.getLong("id");
            String invoiceType = rowData.getString("type");
            currentTaxPeriod = "tcvat_rollout_sign_list".equals(pageName) ? rowData.getString("rollouttaxperiod") : rowData.getString(TAX_PERIOD_FIELD);
            currentTaxPeriodList.add(currentTaxPeriod);
            orgs.add(l);
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("currentTaxPeriod", currentTaxPeriod);
            map.put("orgid", l);
            map.put("invoiceType", invoiceType);
            map.put("invoiceno", rowData.getString("invoiceno"));
            map.put("invoicecode", rowData.getString("invoicecode"));
            rowList.add(map);
        }
        logger.info("exec InvoiceIdentificationService undosign1\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        Map<Long, List<Map<String, Date>>> result = InvoiceIdentificationService.batchQueryNsrxx(orgs, currentTaxPeriodList);
        logger.info("exec InvoiceIdentificationService undosign2\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        orgs = new ArrayList(16);
        currentTaxPeriodList = new ArrayList(16);
        ArrayList<String> idList = new ArrayList<String>(16);
        ArrayList<String> invoiceTypeList = new ArrayList<String>(16);
        for (Map map : rowList) {
            currentTaxPeriod = (String)map.get("currentTaxPeriod");
            Date currentPeriod = DateUtils.stringToDate((String)currentTaxPeriod, (String)"yyyy-MM");
            Long orgid = (Long)map.get("orgid");
            String invoiceType = (String)map.get("invoiceType");
            boolean flag = true;
            if (result.containsKey(orgid)) {
                List<Map<String, Date>> list = result.get(orgid);
                for (Map<String, Date> dateMap : list) {
                    Date skssqq = dateMap.get("skssqq");
                    Date skssqz = dateMap.get("skssqz");
                    if (skssqq.compareTo(currentPeriod) > 0 || skssqz.compareTo(currentPeriod) < 0) continue;
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            orgs.add(orgid);
            currentTaxPeriodList.add(currentTaxPeriod);
            String invoicepkid = (String)map.get("invoicecode") + (String)map.get("invoiceno");
            idList.add(invoicepkid);
            invoiceTypeList.add(invoiceType);
        }
        logger.info("exec InvoiceIdentificationService undosign3\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        if (orgs.size() > 0 && (invoiceCol = InvoiceIdentificationService.batchQueryInvoiceSign(orgs, invoiceTypeList, currentTaxPeriodList, idList)).size() > 0) {
            String string = "invoicepkid";
            if ("tcvat_rollout_sign_list".equals(pageName)) {
                String string2 = "rolloutid";
            }
            for (DynamicObject object : invoiceCol) {
                void var14_18;
                invoicePkIdList.add(object.getString((String)var14_18));
            }
        }
        logger.info("exec InvoiceIdentificationService undosign3\uff0c\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
        customParams.put("invoicePkIdList", invoicePkIdList);
        customParams.put("source", "undosign");
        return customParams;
    }

    private static Map<Long, List<Map<String, Date>>> batchQueryNsrxx(List<Long> orgs, List<String> currentTaxPeriodList) {
        HashMap<Long, List<Map<String, Date>>> result = new HashMap<Long, List<Map<String, Date>>>(16);
        if (currentTaxPeriodList != null && currentTaxPeriodList.size() > 0) {
            currentTaxPeriodList.sort((t1, t2) -> t1.compareTo((String)t2));
            String startDate = DateUtils.getFirstDateOfMonthStr((Date)DateUtils.stringToDate((String)currentTaxPeriodList.get(0), (String)"yyyy-MM"), (String)"yyyy-MM-dd");
            String endDate = DateUtils.getLastDateOfMonthStr((Date)DateUtils.stringToDate((String)currentTaxPeriodList.get(currentTaxPeriodList.size() - 1), (String)"yyyy-MM"), (String)"yyyy-MM-dd");
            QFilter orgidFilter = new QFilter(ORG_FIELD, "in", orgs);
            QFilter typeFilter = new QFilter("type", "=", (Object)"zzsybnsr");
            QFilter startDateFilter = new QFilter("skssqq", ">=", (Object)DateUtils.stringToDate((String)startDate));
            QFilter endDateFilter = new QFilter("skssqz", "<=", (Object)DateUtils.stringToDate((String)endDate));
            QFilter declareStatus = new QFilter("declarestatus", "=", (Object)"declared");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvoiceIdentificationService.class.getName(), (String)"tcvat_nsrxx", (String)"org,skssqq,skssqz", (QFilter[])new QFilter[]{orgidFilter, typeFilter, startDateFilter, endDateFilter, declareStatus}, (String)ORG_FIELD);
            ArrayList list = new ArrayList(16);
            for (Row row : dataSet) {
                Long orgid = row.getLong(ORG_FIELD);
                Date skssqq = row.getDate("skssqq");
                Date skssqz = row.getDate("skssqz");
                HashMap<String, Date> map = new HashMap<String, Date>(2);
                map.put("skssqq", skssqq);
                map.put("skssqz", skssqz);
                if (!result.containsKey(orgid)) {
                    list = new ArrayList(16);
                }
                list.add(map);
                result.put(orgid, list);
            }
        }
        return result;
    }

    private static DynamicObjectCollection batchQueryInvoiceSign(List<Long> orgs, List<String> invoiceTypeList, List<String> currentTaxPeriodList, List<String> invoicepkidList) {
        QFilter orgidFilter = new QFilter(ORG_FIELD, "in", orgs);
        QFilter periodFilter = new QFilter(TAX_PERIOD_FIELD, "in", currentTaxPeriodList);
        QFilter invoicetypeFilter = new QFilter("invoicetype", "in", invoiceTypeList);
        QFilter invoicepkidFilter = new QFilter("invoicepkid", "in", invoicepkidList);
        DynamicObjectCollection invoiceCol = QueryServiceHelper.query((String)"tcvat_input_invoice_sign", (String)"id,invoicepkid,rolloutid", (QFilter[])new QFilter[]{orgidFilter, invoicepkidFilter, periodFilter, invoicetypeFilter});
        return invoiceCol;
    }
}

