/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.identification.output;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.entity.report.FastFilter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.identification.output.OuputInvoiceJzjtSignListService;
import kd.taxc.tcvat.business.service.subplugin.inputjzjztag.args.AfterQueryDataSetFieldDataArgs;
import kd.taxc.tcvat.business.service.subplugin.inputjzjztag.args.BeforeQuerySetFieldsAndDataTypesArgs;
import kd.taxc.tcvat.business.service.subplugin.outputjzjztag.IOutputJzjtTagListQuerySubPlugin;
import kd.taxc.tcvat.business.service.subplugin.outputjzjztag.impl.DefaultOutputJzjtTagListQuerySubPlugin;
import kd.taxc.tcvat.common.enums.OutputJzjtSignFieldEnum;
import org.apache.commons.lang3.ObjectUtils;

public class OuputInvoiceJzjtSignQueryService {
    private static final String SIM_VATINVOICE = "sim_vatinvoice";
    private static final String TCVAT_OUTPUT_INVOICE_SIGN = "tcvat_output_invoice_sign";
    private static OuputInvoiceJzjtSignListService ouputInvoiceJzjtSignListService = new OuputInvoiceJzjtSignListService();
    private static String[] FIELDS = new String[]{"id", "field_subid", "field_mainid", "field_taxorg", "field_baseinvoicetype", "field_invoiceno", "field_invoicecode", "field_buyername", "field_issuetime", "field_invoicestatus", "field_goodsname", "field_specification", "field_taxrate", "field_currency", "field_amount", "field_tax", "field_jzjtsign", "field_signedtax", "field_jzjtproduct", "field_signtime", "field_operator"};
    private static DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.BigDecimalType, DataType.StringType, DataType.TimestampType, DataType.StringType};
    public static final String ALGO_KEY = "kd.taxc.tcvat.formplugin.identification.output.OuputInvoiceJzjtSignQueryPlugin";

    public Map<String, List<QFilter>> getInitFilterMap() {
        HashMap<String, List<QFilter>> map = new HashMap<String, List<QFilter>>();
        map.put(SIM_VATINVOICE, new ArrayList());
        map.put(TCVAT_OUTPUT_INVOICE_SIGN, new ArrayList());
        map.put("empty_invoice_sign", new ArrayList());
        map.put("time_invoice_sign", new ArrayList());
        map.put("allFastFilter", new ArrayList());
        map.put("ek_filter", new ArrayList());
        return map;
    }

    public Map<String, List<QFilter>> getFilterMap(FilterInfo filterInfo) {
        Map<String, List<QFilter>> map = this.getInitFilterMap();
        this.setPanelFilter2(filterInfo, map);
        this.setFastFilter(filterInfo, map);
        List<QFilter> ek_filter = map.get("ek_filter");
        PluginProxy<IOutputJzjtTagListQuerySubPlugin> pluginProxy = this.getPluginProxy();
        pluginProxy.callAfter(p -> {
            p.AfterFillQueryFilters(filterInfo, map, ek_filter);
            return null;
        });
        return map;
    }

    public void setPanelFilter2(FilterInfo filterInfo, Map<String, List<QFilter>> map) {
        List<OutputJzjtSignFieldEnum> mainInvoiceFieldList = OutputJzjtSignFieldEnum.getMainInvoiceFieldList();
        List<OutputJzjtSignFieldEnum> jzjtSignFieldList = OutputJzjtSignFieldEnum.getJzjtSignFieldList();
        List<QFilter> mainFilter = map.get(SIM_VATINVOICE);
        List<QFilter> signFilter = map.get(TCVAT_OUTPUT_INVOICE_SIGN);
        List<QFilter> emptyFilter = map.get("empty_invoice_sign");
        List<QFilter> timeFilter = map.get("time_invoice_sign");
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            String name = filterItem.getPropName().replace("items_", "items.");
            OutputJzjtSignFieldEnum instance = OutputJzjtSignFieldEnum.getInstance(name);
            if (jzjtSignFieldList.contains((Object)instance) && filterItem.getValue() instanceof QEmptyValue) {
                emptyFilter.add(new QFilter(name, filterItem.getCompareType(), (Object)instance.getType()));
            }
            if (!"signtime".equals(name) || null == filterItem.getValue() || filterItem.getValue() instanceof QEmptyValue) continue;
            timeFilter.add(new QFilter(name, filterItem.getCompareType(), (Object)DateUtils.format((Date)((Date)filterItem.getValue()))));
        }
        List qFilters = filterInfo.getQFilters();
        for (QFilter qFilter : qFilters) {
            List nests;
            String name = qFilter.getProperty().replace("items_", "items.");
            OutputJzjtSignFieldEnum instance = OutputJzjtSignFieldEnum.getInstance(name);
            if (OutputJzjtSignFieldEnum.DEFAULT == instance) continue;
            if ("signtime".equals(name) && null != qFilter.getValue()) {
                qFilter.__setValue((Object)"TimePlaceHolder");
                nests = qFilter.getNests(true);
                if (nests != null && !nests.isEmpty()) {
                    nests.stream().forEach(e -> e.getFilter().__setValue((Object)"TimePlaceHolder"));
                }
            }
            if (name.startsWith("items")) {
                qFilter.__setProperty(name);
                nests = qFilter.getNests(true);
                if (nests != null && !nests.isEmpty()) {
                    nests.stream().forEach(e -> e.getFilter().__setProperty(name));
                }
            }
            if (mainInvoiceFieldList.contains((Object)instance)) {
                mainFilter.add(qFilter);
                continue;
            }
            if (!jzjtSignFieldList.contains((Object)instance)) continue;
            signFilter.add(qFilter);
        }
    }

    public void setFastFilter(FilterInfo filterInfo, Map<String, List<QFilter>> map) {
        FastFilter fastFilter = filterInfo.getFastFilter();
        if (ObjectUtils.isNotEmpty((Object)fastFilter) && ObjectUtils.isNotEmpty((Object)fastFilter.getFastFilter())) {
            for (Map fastMap : fastFilter.getFastFilter()) {
                List fieldList = (List)fastMap.get("FieldName");
                List valueList = (List)fastMap.get("Value");
                List<QFilter> filters = null;
                String field = (String)fieldList.get(0);
                if (fieldList.size() > 1) {
                    filters = map.get("allFastFilter");
                } else if (field.contains("taxorg")) {
                    filters = map.get(SIM_VATINVOICE);
                } else if (field.contains("invoiceno")) {
                    filters = map.get(SIM_VATINVOICE);
                } else {
                    if (!field.contains("jzjtproduct")) continue;
                    filters = map.get(TCVAT_OUTPUT_INVOICE_SIGN);
                }
                if (valueList.isEmpty()) continue;
                QFilter qFilter = new QFilter("1", "!=", (Object)1);
                for (Object o : valueList) {
                    String value = (String)o;
                    if (fieldList.size() > 1) {
                        qFilter.or(new QFilter("taxorg.name", "like", (Object)("%" + value + "%")).or("invoiceno", "like", (Object)("%" + value + "%")).or("jzjtproduct.name", "like", (Object)("%" + value + "%")));
                        continue;
                    }
                    if (field.contains("taxorg")) {
                        qFilter.or(new QFilter("taxorg.name", "like", (Object)("%" + value + "%")));
                        continue;
                    }
                    if (field.contains("invoiceno")) {
                        qFilter.or(new QFilter("invoiceno", "like", (Object)("%" + value + "%")));
                        continue;
                    }
                    if (!field.contains("jzjtproduct")) continue;
                    qFilter.or(new QFilter("jzjtproduct.name", "like", (Object)("%" + value + "%")));
                }
                filters.add(qFilter);
            }
        }
    }

    public DataSet collectDataSet(Map<String, List<QFilter>> filterMap) {
        DataSet mainDataSet = this.queryIvoiceDataSet(filterMap.get(SIM_VATINVOICE));
        DataSet signDataSet = this.querySignDataSet(mainDataSet);
        DataSet dataSet = mainDataSet.join(signDataSet, JoinType.LEFT).on("subId", "subinvoiceid").select(new String[]{"subId", "mainId", "goodsname", "specification", "taxrate", "amount", "tax", "taxorg.id", "taxorg.name", "baseinvoicetype.id", "baseinvoicetype.name", "baseinvoicetype", "invoiceno", "invoicecode", "buyername", "issuetime", "invoicestatus"}, new String[]{"subinvoiceid", "jzjtsign", "signedtax", "signtime", "jzjtproduct", "jzjtproduct.id", "jzjtproduct.name", "operator", "operator.id", "operator.name"}).finish();
        if (!filterMap.get("allFastFilter").isEmpty()) {
            dataSet = dataSet.where(filterMap.get("allFastFilter").toString().replace("[", "").replace("]", "").replace(",", " and "));
        }
        String sql = filterMap.get(TCVAT_OUTPUT_INVOICE_SIGN).stream().map(Objects::toString).collect(Collectors.joining(" and ")).replace("[", "").replace("]", "");
        if (!filterMap.get("empty_invoice_sign").isEmpty()) {
            for (QFilter qFilter : filterMap.get("empty_invoice_sign")) {
                sql = sql.replaceFirst("'EMPTY'", this.getEmptyString(qFilter));
            }
        }
        if (!filterMap.get("time_invoice_sign").isEmpty()) {
            for (QFilter qFilter : filterMap.get("time_invoice_sign")) {
                sql = sql.replaceFirst("'TimePlaceHolder'", " to_date('" + qFilter.getValue() + "','yyyy-MM-dd') ");
            }
        }
        if (StringUtil.isNotBlank((CharSequence)sql)) {
            dataSet = dataSet.where(sql);
        }
        DataSet resultSet = this.packObject(dataSet);
        if (!filterMap.get("ek_filter").isEmpty()) {
            String ekSql = filterMap.get("ek_filter").stream().map(Objects::toString).collect(Collectors.joining(" and ")).replace("[", "").replace("]", "");
            resultSet = resultSet.where(ekSql);
        }
        return resultSet;
    }

    private String getEmptyString(QFilter qFilter) {
        if (DataType.StringType.equals(qFilter.getValue())) {
            return "'' or " + qFilter.getProperty() + " =' ' or " + qFilter.getProperty() + " is null";
        }
        if (DataType.LongType.equals(qFilter.getValue())) {
            return "0 or " + qFilter.getProperty() + " is null";
        }
        return "";
    }

    public DataSet queryIvoiceDataSet(List<QFilter> invoicefilter) {
        List list = new ArrayList();
        List<Long> permOrgs = ouputInvoiceJzjtSignListService.getAllPermOrgs();
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndIsTaxpayerAndIsYbnsr(permOrgs);
        if (result.isSuccess() && !ObjectUtils.isEmpty((Object)result.getData())) {
            list = (List)result.getData();
        }
        invoicefilter.add(new QFilter("invoicestatus", "in", Arrays.asList("0", "3")));
        invoicefilter.add(new QFilter("taxorg", "in", list));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)SIM_VATINVOICE, (String)"id mainId,taxorg,taxorg.id,taxorg.name,baseinvoicetype,baseinvoicetype.id,baseinvoicetype.name,invoiceno,invoicecode,buyername,issuetime,invoicestatus,items.id as subId,items.goodsname as goodsname,items.specification as specification,items.taxrate as taxrate,items.amount as amount,items.tax as tax", (QFilter[])invoicefilter.toArray(new QFilter[0]), null);
    }

    public DataSet querySignDataSet(DataSet subDataSet) {
        ArrayList<QFilter> signFilter = new ArrayList<QFilter>();
        signFilter.add(new QFilter("jzjtsign", "=", (Object)"1"));
        return QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)TCVAT_OUTPUT_INVOICE_SIGN, (String)"id,subinvoiceid,jzjtsign,signedtax,signtime,jzjtproduct,jzjtproduct.id,jzjtproduct.name,operator,operator.id,operator.name", (QFilter[])signFilter.toArray(new QFilter[0]), null);
    }

    private DataSet packObject(DataSet dataSet) {
        ArrayList<ArrayList> col2 = new ArrayList<ArrayList>();
        PluginProxy<IOutputJzjtTagListQuerySubPlugin> pluginProxy = this.getPluginProxy();
        for (Row row : dataSet) {
            Long id = 0L;
            Long subId = row.getLong("subId");
            Long mainId = row.getLong("mainId");
            Long taxorg = row.getLong("taxorg.id");
            Long baseinvoicetype = row.getLong("baseinvoicetype.id");
            String invoiceno = row.getString("invoiceno");
            String invoicecode = row.getString("invoicecode");
            String buyername = row.getString("buyername");
            Long issuetime = ObjectUtils.isNotEmpty((Object)row.getDate("issuetime")) ? row.getDate("issuetime").getTime() : 0L;
            String invoicestatus = row.getString("invoicestatus");
            String goodsname = row.getString("goodsname");
            String specification = row.getString("specification");
            String taxrate = row.getString("taxrate");
            Long currency = 1L;
            BigDecimal amount = row.getBigDecimal("amount");
            BigDecimal tax = row.getBigDecimal("tax");
            String jzjtsign = row.getString("jzjtsign");
            BigDecimal signedtax = row.getBigDecimal("signedtax");
            Long jzjtproduct = row.getLong("jzjtproduct.id");
            Date signtime = row.getDate("signtime");
            Long operator = Optional.ofNullable(row.getLong("operator.id")).orElse(-1L);
            ArrayList dataShowList = Lists.newArrayList((Object[])new Object[]{id, subId, mainId, taxorg, baseinvoicetype, invoiceno, invoicecode, buyername, issuetime, invoicestatus, goodsname, specification, taxrate, currency, amount, tax, jzjtsign, signedtax, jzjtproduct, signtime, operator});
            AfterQueryDataSetFieldDataArgs afterQueryDataArgs = new AfterQueryDataSetFieldDataArgs();
            afterQueryDataArgs.setOneRowOfDataSet(row);
            afterQueryDataArgs.setDataShowList(dataShowList);
            pluginProxy.callReplace(p -> {
                p.afterQueryDataSetFieldData(afterQueryDataArgs);
                return null;
            });
            col2.add(dataShowList);
        }
        BeforeQuerySetFieldsAndDataTypesArgs args = new BeforeQuerySetFieldsAndDataTypesArgs();
        pluginProxy.callAfter(p -> {
            p.beforeQuerySetFieldsAndDataTypes(args);
            return null;
        });
        List<String> fieldNameList = args.getFieldNameList();
        List<DataType> dataTypeList = args.getDataTypeList();
        pluginProxy.callReplace(p -> {
            p.afterQueryDataSetFieldDataBatch(col2, fieldNameList, dataTypeList);
            return null;
        });
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNameList.toArray(new String[fieldNameList.size()]), (DataType[])dataTypeList.toArray(new DataType[dataTypeList.size()]));
        Collection coll = col2.stream().map(a -> a.toArray()).collect(Collectors.toList());
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet result = Algo.create((String)ALGO_KEY).createDataSet(new Input[]{inputs});
        return result.orderBy(new String[]{"field_invoiceno desc"});
    }

    private PluginProxy<IOutputJzjtTagListQuerySubPlugin> getPluginProxy() {
        return PluginProxy.create((Object)new DefaultOutputJzjtTagListQuerySubPlugin(), IOutputJzjtTagListQuerySubPlugin.class, (String)"TAXC_TCVAT_OUTPUT_SIGN_REPORT_EXTPLUGIN", null);
    }
}

