/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.mq;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.mq.TaxRefundStatusHandler;

public class TaxRefundAccountConsumer
implements MessageConsumer {
    public static final Log logger = LogFactory.getLog(TaxRefundAccountConsumer.class);

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            String str = (String)message;
            logger.info("TaxRefundAccountConsumer message:" + str);
            DeclareMQMessage declareMQMessage = (DeclareMQMessage)SerializationUtils.fromJsonString((String)str, DeclareMQMessage.class);
            if (null == declareMQMessage) {
                acker.discard(messageId);
                return;
            }
            String pkValue = declareMQMessage.getSbbid();
            if (StringUtil.isNotBlank((CharSequence)pkValue)) {
                DynamicObject declareReport = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tcvat_zzs_declare_list");
                if (null == declareReport) {
                    acker.ack(messageId);
                    return;
                }
                String event = declareMQMessage.getEvent();
                TaxRefundStatusHandler taxRefundStatusHandler = new TaxRefundStatusHandler();
                if ("UNAUDIT".equals(event)) {
                    taxRefundStatusHandler.unauditHandler(declareReport);
                }
                if ("AUDIT".equals(event)) {
                    taxRefundStatusHandler.auditHandler(declareReport);
                }
            }
            acker.ack(messageId);
        }
        catch (Throwable throwable) {
            logger.error("TaxRefundAccountConsumer execute error", throwable);
            acker.discard(messageId);
        }
    }
}

