/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.mq;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQEvent;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQSender;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQType;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvat.business.service.taxrefund.AccountServiceHelper;
import kd.taxc.tcvat.business.service.taxrefund.StateInitDataService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAccountService;
import kd.taxc.tcvat.business.service.taxrefund.TaxRefundAssistService;

public class TaxRefundStatusHandler {
    public void unauditHandler(DynamicObject declareReport) {
        if (!StateInitDataService.TYPELIST.contains(declareReport.getString("type"))) {
            return;
        }
        TaxRefundAccountService taxRefundAccountService = new TaxRefundAccountService();
        ArrayList<DynamicObject> declareUpdateList = new ArrayList<DynamicObject>();
        declareReport.set("taxrefundstatus", (Object)"--");
        declareUpdateList.add(declareReport);
        SaveServiceHelper.save((DynamicObject[])declareUpdateList.toArray(new DynamicObject[0]));
        Long orgId = declareReport.getDynamicObject("org").getLong("id");
        Date skssqq = declareReport.getDate("skssqq");
        Date skssqz = declareReport.getDate("skssqz");
        DynamicObject dyos = QueryServiceHelper.queryOne((String)"tcvat_tax_refund_manage_a", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("skssqq", "=", (Object)skssqq), new QFilter("skssqz", "=", (Object)skssqz)});
        taxRefundAccountService.deleteTaxRefundAccount(null == dyos ? 0L : dyos.getLong("id"));
        taxRefundAccountService.deleteTaxRefundDetail(Collections.singletonList(declareReport.getLong("id")));
    }

    public void auditHandler(DynamicObject declareReport) {
        TaxRefundAccountService taxRefundAccountService = new TaxRefundAccountService();
        ArrayList<DynamicObject> declareUpdateList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> taxRefundStatusDetailCollection = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> taxRefundAccountList = new ArrayList<DynamicObject>();
        String taxrefundstatus = declareReport.getString("taxrefundstatus");
        String currentTaxRefundStatus = "--";
        if (!StateInitDataService.TYPELIST.contains(declareReport.getString("type"))) {
            if (!currentTaxRefundStatus.equals(taxrefundstatus)) {
                declareReport.set("taxrefundstatus", (Object)currentTaxRefundStatus);
                declareUpdateList.add(declareReport);
            }
        } else {
            Long orgId = declareReport.getDynamicObject("org").getLong("id");
            Date skssqq = declareReport.getDate("skssqq");
            Date skssqz = declareReport.getDate("skssqz");
            boolean existTotalData = AccountServiceHelper.existTotalData(orgId);
            if (!existTotalData) {
                currentTaxRefundStatus = "yc";
                taxRefundAccountService.createTaxRefundDetail(taxRefundStatusDetailCollection, declareReport, "datainit");
                if (!currentTaxRefundStatus.equals(taxrefundstatus)) {
                    declareReport.set("taxrefundstatus", (Object)currentTaxRefundStatus);
                    declareUpdateList.add(declareReport);
                }
            } else {
                DynamicObject taxRefundAccount = taxRefundAccountService.queryTaxRefundAccount(declareReport);
                if (null == taxRefundAccount) {
                    taxRefundAccount = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_tax_refund_manage_a");
                    taxRefundAccountService.createAccount(taxRefundAccount, declareReport, "audit");
                    taxRefundAccountList.add(taxRefundAccount);
                }
                this.setTaxRefundStatus(declareReport, taxRefundAccountService, declareUpdateList, taxRefundStatusDetailCollection, taxrefundstatus, orgId, skssqq, skssqz, taxRefundAccount);
            }
        }
        SaveServiceHelper.save((DynamicObject[])taxRefundAccountList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])declareUpdateList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])taxRefundStatusDetailCollection.toArray(new DynamicObject[0]));
        TaxRefundMQSender.sendMQ(taxRefundAccountList, (String)TaxRefundMQType.TAX_REFUND.name(), (String)TaxRefundMQEvent.NEW.name());
    }

    private void setTaxRefundStatus(DynamicObject declareReport, TaxRefundAccountService taxRefundAccountService, List<DynamicObject> declareUpdateList, List<DynamicObject> taxRefundStatusDetailCollection, String taxrefundstatus, Long orgId, Date skssqq, Date skssqz, DynamicObject taxRefundAccount) {
        String currentTaxRefundStatus;
        if (StringUtil.isBlank((CharSequence)taxRefundAccount.getString("sshydl"))) {
            currentTaxRefundStatus = "yc";
            taxRefundAccountService.createTaxRefundDetail(taxRefundStatusDetailCollection, declareReport, "sshydl");
            if (!currentTaxRefundStatus.equals(taxrefundstatus)) {
                declareReport.set("taxrefundstatus", (Object)currentTaxRefundStatus);
                declareUpdateList.add(declareReport);
            }
        }
        if (StringUtil.isBlank((CharSequence)taxRefundAccount.getString("nsxydj"))) {
            currentTaxRefundStatus = "yc";
            taxRefundAccountService.createTaxRefundDetail(taxRefundStatusDetailCollection, declareReport, "nsxydj");
            if (!currentTaxRefundStatus.equals(taxrefundstatus)) {
                declareReport.set("taxrefundstatus", (Object)currentTaxRefundStatus);
                declareUpdateList.add(declareReport);
            }
        }
        if (declareUpdateList.size() > 0) {
            return;
        }
        if (taxRefundAccount.getBigDecimal("bqksqthldtse").compareTo(BigDecimal.ZERO) == 0) {
            currentTaxRefundStatus = "wxsq";
            taxRefundAccountService.createTaxRefundDetail(taxRefundStatusDetailCollection, declareReport, currentTaxRefundStatus);
            if (!currentTaxRefundStatus.equals(taxrefundstatus)) {
                declareReport.set("taxrefundstatus", (Object)currentTaxRefundStatus);
                declareUpdateList.add(declareReport);
                return;
            }
        }
        if (taxRefundAccount.getBigDecimal("bqksqthldtse").compareTo(BigDecimal.ZERO) > 0) {
            DynamicObject taxRefundApply = TaxRefundAssistService.getTaxRefundApply(orgId, skssqq, skssqz);
            if (null == taxRefundApply) {
                currentTaxRefundStatus = "wsq";
                if (!currentTaxRefundStatus.equals(taxrefundstatus)) {
                    declareReport.set("taxrefundstatus", (Object)currentTaxRefundStatus);
                    declareUpdateList.add(declareReport);
                    return;
                }
            } else {
                currentTaxRefundStatus = ((DynamicObject)taxRefundApply.getDynamicObjectCollection("entryentity").get(0)).getString("bljd");
                if (!currentTaxRefundStatus.equals(taxrefundstatus)) {
                    declareReport.set("taxrefundstatus", (Object)currentTaxRefundStatus);
                    declareUpdateList.add(declareReport);
                }
            }
        }
    }
}

