/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.engine.xgmnsr;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.TaxDeclareHelper;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;

public class XgmPolicyEngine
implements IEngine<TcvatEngineModel> {
    private static final String POLICY_CONFIRM_PAGE = "tcvat_xgm_policy_confirm";

    public void deleteData(TcvatEngineModel model) {
        QFilter q1 = new QFilter("orgid", "=", (Object)Long.parseLong(model.getOrgId()));
        QFilter q2 = new QFilter("reportperiod", "=", (Object)DateUtils.stringToDate((String)model.getStartDate()));
        QFilter q3 = new QFilter("taxplayeraptitude", "=", (Object)"zzsxgmnsr");
        QFilter q4 = new QFilter("draftpurpose", "=", model.getCustom().get("draftpurpose"));
        DeleteServiceHelper.delete((String)POLICY_CONFIRM_PAGE, (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    public void runEngine(TcvatEngineModel model) {
        String draftPurpose = model.getDraftMetaDataDTO().getDraftPurpose();
        List data = (List)TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(model.getOrgId()))).getData();
        if (EmptyCheckUtils.isNotEmpty((Object)data)) {
            DynamicObject taxMain = (DynamicObject)data.get(0);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)POLICY_CONFIRM_PAGE);
            DynamicObject policy = new DynamicObject((DynamicObjectType)entityType);
            DynamicObject suborgObject = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(model.getOrgId()), (String)"bos_org");
            policy.set("orgid", (Object)suborgObject);
            policy.set("billstatus", (Object)"A");
            Date startDate = DateUtils.stringToDate((String)model.getStartDate());
            Date endDate = DateUtils.stringToDate((String)model.getEndDate());
            policy.set("reportperiod", (Object)startDate);
            policy.set("taxplayeraptitude", model.getCustom().get("taxPayerType"));
            policy.set("declaretype", (Object)"1");
            policy.set("draftpurpose", (Object)draftPurpose);
            policy.set("registertype", taxMain.get("registertype"));
            policy.set("codeandname", taxMain.get("codeandname"));
            DynamicObjectCollection categoryentryentity = taxMain.getDynamicObjectCollection("categoryentryentity");
            if (EmptyCheckUtils.isNotEmpty((Object)categoryentryentity)) {
                DynamicObject category = (DynamicObject)categoryentryentity.get(0);
                policy.set("levytype", (Object)category.getString("levytype"));
                policy.set("deadline", (Object)TaxDeclareHelper.getDeadLine(draftPurpose, model.getOrgId(), startDate, endDate));
            }
            String rulePurpose = (String)model.getCustom().get("rulePurpose");
            Map rules = RuleUtils.getSharingAndOrgRules((Long)Long.parseLong(model.getOrgId()), (RuleTypeEnum)RuleTypeEnum.ALL, (String)"xgmnsr", (String)rulePurpose);
            String ruledata = SerializationUtils.toJsonString((Object)rules);
            policy.set("ruledata_tag", (Object)ruledata);
            OperationServiceHelper.executeOperate((String)"save", (String)POLICY_CONFIRM_PAGE, (DynamicObject[])new DynamicObject[]{policy}, (OperateOption)OperateOption.create());
            String orgId = model.getOrgId();
            String startD = model.getStartDate();
            String endD = model.getEndDate();
            String templatetype = (String)model.getCustom().get("templatetype");
            new DraftService().setDefaultRiskInfoNoZlb(draftPurpose, orgId, startD, endD, templatetype);
        }
    }
}

