/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.engine.ybhz;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.TcvatDraftService;
import kd.taxc.tcvat.business.service.draft.strategy.TcvatStrategy;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.AbstractZlbEngine;
import kd.taxc.tcvat.business.service.zlb.YbhzTaxCalculateService;
import kd.taxc.tcvat.business.service.zlb.YbhzZlbCalculateService;
import kd.taxc.tcvat.business.service.zlb.ZlbService;

public class YbhzZlbEngine
extends AbstractZlbEngine
implements IEngine<TcvatEngineModel> {
    public void deleteData(TcvatEngineModel model) {
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        String draftPurpose = model.getDraftMetaDataDTO().getDraftPurpose();
        String templateType = "draft_zzsybnsr_ybhz";
        String orgid = model.getOrgId();
        String skssqq = model.getStartDate();
        String skssqz = model.getEndDate();
        if ("sjjt".equals(draftPurpose)) {
            templateType = "draft_zzsybnsr_ybhz_sjjt";
            ZlbService.updateJtynse(draftPurpose, templateType, BigDecimal.ZERO, orgid, skssqq, skssqz);
        }
        TemplateUtils.deleteReport((Long)Long.parseLong(model.getOrgId()), (String)templateType, (Date)startDate, (Date)endDate, null);
        if ("nssb".equals(draftPurpose)) {
            YbhzZlbCalculateService.deleteData(Long.parseLong(model.getOrgId()), startDate, endDate);
        }
        this.draftService.deleteRiskInfoByQueryDraft(orgid, skssqq, skssqz, draftPurpose, model.getDraftMetaDataDTO().getTemplateType());
    }

    public void runEngine(TcvatEngineModel model) {
        String declareType = model.getDeclareType();
        String draftPurpose = model.getDraftMetaDataDTO().getDraftPurpose();
        String zlbSbbTemplateType = "draft_zzsybnsr_ybhz";
        if ("sjjt".equals(draftPurpose)) {
            zlbSbbTemplateType = "draft_zzsybnsr_ybhz_sjjt";
        }
        String orgId = model.getOrgId();
        String startDate = model.getStartDate();
        String endDate = model.getEndDate();
        String draftTemplateType = (String)model.getCustom().get("templatetype");
        String draftpurpose = model.getCustom().getOrDefault("draftpurpose", "nssb");
        Map dataMap = FormulaService.query((IPageCache)model.getPageCache(), (String)zlbSbbTemplateType, (String)orgId, (String)startDate, (String)endDate, (boolean)true);
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)declareType);
        YbhzTaxCalculateService.calculate(dataMap, orgId, startDate, endDate, templateEnum.getDraftType());
        TcvatStrategy strategy = TcvatDraftService.getStrategy((String)model.getCustom().get("taxPayerType"), (String)model.getCustom().get("prelevyrate"));
        strategy.calculate(orgId, startDate, endDate, draftTemplateType, model.getPageCache());
        BigDecimal jtynsesum = "sjjt".equals(draftPurpose) ? ZlbService.calcHzSjjtYnseSum(dataMap) : ZlbService.calcHzjsYnseSum(dataMap);
        ZlbService.updateJtynse(draftpurpose, draftTemplateType, jtynsesum, orgId, startDate, endDate);
        this.draftService.calcDraftRiskInfo(orgId, startDate, endDate, draftpurpose, draftTemplateType, zlbSbbTemplateType, dataMap, model.getPageCache());
    }
}

