/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.onekeygenerate.engine.ybnsr;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.onekeygenerate.IEngine;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.draft.metadata.dto.DraftMetaDataDTO;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.onekeygenerate.engine.AbstractZlbEngine;
import kd.taxc.tcvat.business.service.zlb.ZlbService;

public class ZlbEngine
extends AbstractZlbEngine
implements IEngine<TcvatEngineModel> {
    public void deleteData(TcvatEngineModel model) {
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaData(model.getCustom().getOrDefault("draftpurpose", "nssb"), model.getCustom().getOrDefault("taxpayertype", "zzsybnsr"));
        Date startDate = DateUtils.stringToDate((String)model.getStartDate());
        Date endDate = DateUtils.stringToDate((String)model.getEndDate());
        TemplateUtils.deleteReport((Long)Long.parseLong(model.getOrgId()), (String)metaData.getTemplateType(), (Date)startDate, (Date)endDate, null);
        String draftpurpose = (String)model.getCustom().get("draftpurpose");
        String orgid = model.getOrgId();
        String skssqq = model.getStartDate();
        String skssqz = model.getEndDate();
        if ("sjjt".equals(draftpurpose)) {
            ZlbService.updateJtynse(draftpurpose, metaData.getTemplateType(), BigDecimal.ZERO, orgid, skssqq, skssqz);
        }
        this.draftService.deleteRiskInfoByQueryDraft(orgid, skssqq, skssqz, draftpurpose, model.getDraftMetaDataDTO().getTemplateType());
    }

    public void runEngine(TcvatEngineModel model) {
        String draftpurpose = model.getCustom().getOrDefault("draftpurpose", "nssb");
        String orgid = model.getOrgId();
        String skssqq = model.getStartDate();
        String skssqz = model.getEndDate();
        String templatetype = (String)model.getCustomValue("templatetype");
        DraftMetaDataDTO metaData = DraftMetaDataDTO.getMetaData(draftpurpose, model.getCustom().getOrDefault("taxpayertype", "zzsybnsr"));
        Map resultMap = FormulaService.query((IPageCache)model.getPageCache(), (String)metaData.getTemplateType(), (String)model.getOrgId(), (String)model.getStartDate(), (String)model.getEndDate(), (boolean)true);
        BigDecimal jtynsesum = ZlbService.calcYbnsrSjjtYnseSum(resultMap);
        ZlbService.updateJtynse(draftpurpose, templatetype, jtynsesum, orgid, skssqq, skssqz);
        this.draftService.calcDraftRiskInfo(orgid, skssqq, skssqz, draftpurpose, templatetype, templatetype, resultMap, model.getPageCache());
    }
}

