/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.outputtax.fdckf;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.declare.TaxDeclareEditService;
import kd.taxc.tcvat.business.service.draft.PeriodService;

public class EstateSalesConfirmLedgerService {
    public static final String BASTAX_TAXPROJECT = "bastax_taxproject";
    public static final String BASTAX_STAGE = "bastax_stage";
    private static final String TCVAT_FDC_XSQR_TZ = "tcvat_fdc_xsqr_tz";

    public static Long queryFirstProjectByOrg(Long orgid) {
        QFilter taxorg = new QFilter("taxorg", "=", (Object)orgid);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter qFilter = new QFilter("group.number", "=", (Object)"001");
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_TAXPROJECT, (String)"id", (QFilter[])new QFilter[]{taxorg, enable, status, qFilter}, (String)"number asc");
        return query.size() == 0 ? null : Long.valueOf(((DynamicObject)query.get(0)).getLong("id"));
    }

    public static DynamicObjectCollection queryProjectByIds(ArrayList<Long> projectids) {
        QFilter taxorg = new QFilter("id", "in", projectids);
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_TAXPROJECT, (String)"id,taxorg", (QFilter[])new QFilter[]{taxorg});
        return query;
    }

    public static DynamicObjectCollection queryStageByIds(List<Long> ids) {
        QFilter taxorg = new QFilter("id", "in", ids);
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_STAGE, (String)"id,taxproject", (QFilter[])new QFilter[]{taxorg});
        return query;
    }

    public static DynamicObjectCollection queryStageByProjectIds(List<Long> projectIds) {
        QFilter taxproject = new QFilter("taxproject", "in", projectIds);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection query = QueryServiceHelper.query((String)BASTAX_STAGE, (String)"id,taxproject,taxorg", (QFilter[])new QFilter[]{taxproject, enable});
        return query;
    }

    public static Map<String, Object> validSkssqTaxLimit(Date skssqq, Date skssqz, Long orgid, String name) {
        String deadLine;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", Boolean.TRUE.toString());
        if (orgid != null && (deadLine = PeriodService.getDeadLine(orgid.toString(), skssqq, skssqz)) != null) {
            boolean ok;
            Date lastDateOfMonthDay = DateUtils.getLastDateOfMonth((Date)skssqq);
            Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)skssqq);
            boolean bl = ok = "aysb".equals(deadLine) && DateUtils.format((Date)lastDateOfMonthDay).equals(DateUtils.format((Date)skssqz)) || "ajsb".equals(deadLine) && DateUtils.format((Date)lastDateOfSeason).equals(DateUtils.format((Date)skssqz));
            if (!ok) {
                result.put("msg", String.format(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0e%s\u7684\u7eb3\u7a0e\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EstateSalesConfirmLedgerService_0", (String)"taxc-tcvat", (Object[])new Object[0]), name));
                result.put("success", Boolean.FALSE.toString());
            }
        }
        return result;
    }

    public static Map<String, Object> validSkssq(Date skssqq, Date skssqz, Long orgid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", Boolean.TRUE.toString());
        if (skssqz != null && skssqq != null) {
            String deadLine;
            boolean adaptableDate = EstateSalesConfirmLedgerService.isAdaptableDate(skssqq, skssqz);
            if (skssqz.compareTo(skssqq) < 0) {
                result.put("msg", ResManager.loadKDString((String)"\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u201d\u4e0d\u80fd\u65e9\u4e8e\u201c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u201d\u3002", (String)"EstateSalesConfirmLedgerService_1", (String)"taxc-tcvat", (Object[])new Object[0]));
                result.put("success", Boolean.FALSE.toString());
            } else if (!adaptableDate) {
                result.put("msg", ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u9700\u4e3a\u81ea\u7136\u6708\u6216\u81ea\u7136\u5b63\u3002", (String)"EstateSalesConfirmLedgerService_2", (String)"taxc-tcvat", (Object[])new Object[0]));
                result.put("success", Boolean.FALSE.toString());
            } else if (orgid != null && (deadLine = PeriodService.getDeadLine(orgid.toString(), skssqq, skssqz)) != null) {
                boolean ok;
                Date lastDateOfMonthDay = DateUtils.getLastDateOfMonth((Date)skssqq);
                Date lastDateOfSeason = DateUtils.getLastDateOfSeason((Date)skssqq);
                boolean bl = ok = "aysb".equals(deadLine) && DateUtils.format((Date)lastDateOfMonthDay).equals(DateUtils.format((Date)skssqz)) || "ajsb".equals(deadLine) && DateUtils.format((Date)lastDateOfSeason).equals(DateUtils.format((Date)skssqz));
                if (!ok) {
                    result.put("msg", ResManager.loadKDString((String)"\u5f55\u5165\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0e\u8be5\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u671f\u9650\u4e0d\u7b26\u3002", (String)"EstateSalesConfirmLedgerService_3", (String)"taxc-tcvat", (Object[])new Object[0]));
                    result.put("success", Boolean.FALSE.toString());
                }
            }
        }
        return result;
    }

    public static List<Long> getPermOrgs(IFormView view) {
        TaxResult listTaxResult;
        List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        if (!hasPermOrgResult.hasAllOrgPerm() && hasPermOrgResult.getHasPermOrgs().size() > 0) {
            orgIds = hasPermOrgResult.getHasPermOrgs();
        }
        HashSet set1 = (listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayer()).getData() != null ? new HashSet((Collection)listTaxResult.getData()) : new HashSet();
        HashSet set2 = orgIds != null ? new HashSet(orgIds) : new HashSet();
        Sets.SetView intersection = Sets.intersection(set1, set2);
        return new ArrayList<Long>((Collection<Long>)intersection);
    }

    public static boolean isAdaptableDate(Date skssqq, Date skssqz) {
        if (skssqq == null || skssqz == null) {
            return false;
        }
        boolean b = DateUtils.validDateRange((String)"month", (Date)skssqq, (Date)skssqz);
        boolean b1 = DateUtils.validDateRange((String)"season", (Date)skssqq, (Date)skssqz);
        return b || b1;
    }

    public static List<DynamicObject> queryRooms(Long org, Long project, Long stage) {
        QFilter qFilter = new QFilter("taxorg", "=", (Object)org);
        QFilter qFilter1 = new QFilter("stage", "=", (Object)stage);
        QFilter qFilter2 = new QFilter("taxproject", "=", (Object)project);
        DynamicObjectCollection incomeDraft = QueryServiceHelper.query((String)"bastax_room", (String)"id,roomno,name,building,area", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2}, (String)"roomno asc");
        return incomeDraft;
    }

    public static List<DynamicObject> queryRooms(List<Long> org, List<Long> project, List<Long> stage) {
        QFilter qFilter = new QFilter("taxorg", "in", org);
        QFilter qFilter1 = new QFilter("stage", "in", stage);
        QFilter qFilter2 = new QFilter("taxproject", "in", project);
        DynamicObjectCollection incomeDraft = QueryServiceHelper.query((String)"bastax_room", (String)"id,taxorg,taxproject,stage,roomno,name,building,area", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2}, (String)"roomno asc");
        return incomeDraft;
    }

    public static List<Map<String, Object>> calcEntryDefaultData(Long orgid, Long projectId, Long stage, Date skssqq, Date skssqz) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        List<DynamicObject> rooms = EstateSalesConfirmLedgerService.queryRooms(orgid, projectId, stage);
        Map<Long, DynamicObject> prePeriodData = EstateSalesConfirmLedgerService.queryPrePeriodData(orgid, projectId, stage, skssqq, skssqz);
        for (int i = 0; i < rooms.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            long id = rooms.get(i).getLong("id");
            map.put("room", id);
            map.put("dsjrksmj", rooms.get(i).get("area"));
            DynamicObject dynamicObject = prePeriodData.get(id);
            if (dynamicObject != null) {
                BigDecimal wqkpxse = dynamicObject.getBigDecimal("ljkpxse");
                BigDecimal wqwkpxse = dynamicObject.getBigDecimal("ljwkpxse");
                map.put("wqkpxse", wqkpxse);
                map.put("wqwkpxse", wqwkpxse);
                map.put("ljkpxse", wqkpxse);
                map.put("ljwkpxse", wqwkpxse);
            }
            result.add(map);
        }
        return result;
    }

    public static boolean isDeclared(Date skssqq, Date skssqz, String orgid) {
        Date endDate;
        Date startDate;
        if (skssqq == null || skssqz == null) {
            return false;
        }
        int monthDiff = DateUtils.getMonthDiff((Date)skssqq, (Date)skssqz);
        if (monthDiff > 1) {
            startDate = DateUtils.getFirstDateOfSeason((Date)skssqq);
            endDate = DateUtils.getLastDateOfSeason((Date)skssqq);
        } else {
            startDate = DateUtils.getFirstDateOfMonth((Date)skssqq);
            endDate = DateUtils.getLastDateOfMonth((Date)skssqq);
        }
        DynamicObject nsrxx = TaxDeclareEditService.queryZzsNsrxx(orgid, startDate, endDate);
        return nsrxx != null && "declared".equals(nsrxx.getString("declarestatus"));
    }

    public static DynamicObjectCollection queryPeriodData(Long orgid, Long projectId, Long stage, Date skssqq, Date skssqz) {
        QFilter taxorg = new QFilter("org", "=", (Object)orgid);
        QFilter enable = new QFilter("project", "=", (Object)projectId);
        QFilter status = new QFilter("stage", "=", (Object)stage);
        QFilter qFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter qFilter1 = new QFilter("skssqz", "=", (Object)skssqz);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCVAT_FDC_XSQR_TZ, (String)"id,entryentity.id entryid,entryentity.dsjrksmj roomarea,entryentity.dqqrxsebl dqqrxsebl", (QFilter[])new QFilter[]{taxorg, enable, status, qFilter, qFilter1}, (String)"entryentity.room asc");
        return query;
    }

    private static Map<Long, DynamicObject> queryPrePeriodData(Long orgid, Long projectId, Long stage, Date skssqq, Date skssqz) {
        QFilter taxorg = new QFilter("org", "=", (Object)orgid);
        QFilter enable = new QFilter("project", "=", (Object)projectId);
        QFilter status = new QFilter("stage", "=", (Object)stage);
        Map<String, Date> map = PeriodService.preTaxPeriod(orgid.toString(), skssqq);
        Date startDate = map.get("startDate");
        Date endDate = DateUtils.trunc((Date)map.get("endDate"));
        QFilter qFilter = new QFilter("skssqq", "=", (Object)startDate);
        QFilter qFilter1 = new QFilter("skssqz", "=", (Object)endDate);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCVAT_FDC_XSQR_TZ, (String)"id,entryentity.id entryid,entryentity.room room,entryentity.ljwkpxse ljwkpxse,entryentity.ljkpxse ljkpxse", (QFilter[])new QFilter[]{taxorg, enable, status, qFilter, qFilter1}, (String)"entryentity.room asc");
        Map<Long, DynamicObject> resultmap = query.stream().collect(Collectors.toMap(a -> a.getLong("room"), b -> b, (m, n) -> m));
        return resultmap;
    }
}

