/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.PrepayStatusService;
import kd.taxc.bdtaxr.common.taxdeclare.TaxStepsConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvat.business.service.engine.TcvatEngineModel;
import kd.taxc.tcvat.business.service.prepay.engine.util.PrepayEngineUtils;

public class PrepayAccountListService {
    public static void initAccount(Date start, Date end, String orgid, Map<String, Object> customParams, IFormView getView) {
        TcvatEngineModel engineModel = new TcvatEngineModel(orgid, DateUtils.format((Date)start), DateUtils.format((Date)end));
        engineModel.addCustom("projectid", customParams.get("projectid"));
        engineModel.addCustom("taxpayertype", customParams.get("taxPayerType"));
        engineModel.addCustom("taxorg", customParams.get("taxorg"));
        engineModel.addCustom("declareserialno", customParams.get("declareserialno"));
        engineModel.addCustom("applyid", customParams.get("applyid"));
        try (TXHandle h = TX.requiresNew();){
            try {
                PrepayEngineUtils.execute(RequestContext.getOrCreate(), engineModel);
                new PrepayStatusService().updateStatus(orgid, (String)customParams.get("skssqq"), (String)customParams.get("skssqz"), "1", (String)customParams.get("projectid"), (String)customParams.get("declareserialno"));
                DeclareStepsUtils.resetParentSteps((int)TaxStepsConstant.getTcvatDraftYbnsr().size(), (String)"1", (String)"1", (IFormView)getView);
            }
            catch (Throwable t) {
                h.markRollback();
                throw new RuntimeException(t);
            }
        }
    }

    public static boolean havePrepayApplication(Map<String, Object> customParams) {
        String prepaytype = (String)customParams.get("prepaytype");
        String applyid = (String)customParams.get("applyid");
        if ("VAT_YJXMLX_001".equals(prepaytype) || "VAT_YJXMLX_002".equals(prepaytype)) {
            return applyid != null;
        }
        return false;
    }

    public static void setPrepareNumber(String applyid, String declareserialno) {
        DynamicObject perpayApplication = BusinessDataServiceHelper.loadSingle((Object)applyid, (String)"tcvat_prepay_application");
        perpayApplication.set("declarenumber", (Object)declareserialno);
        SaveServiceHelper.update((DynamicObject)perpayApplication);
    }
}

