/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvat.business.service.prepay;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class PrepayProjectService {
    public static final String ENTITY_PROJECT_INFO = "tcvat_prepay_project_info";
    public static final String AMOUNT = "amount";
    public static final String PROJECT_FILEDS = "contractentity.amount as amount,id,name,number,levytype";
    public static final String ID = "id";
    public static final String PROJECTID = "projectid";
    public static final String COMMA = ",";
    public static final String TCVAT_PREPAY_PROJECT_INFO = "tcvat_prepay_project_info";
    public static final String SIM_VATINVOICE_OUTPUT_SIG = "sim_vatinvoice_output_sig";

    public static DynamicObjectCollection getProjects(List<Long> projectids) {
        return QueryServiceHelper.query((String)"tcvat_prepay_project_info", (String)PROJECT_FILEDS, (QFilter[])new QFilter[]{new QFilter(ID, "in", projectids)});
    }

    public static Map<Long, Object> getProjectAmount(List<Long> projectids, String algoKey) {
        HashMap<Long, Object> objectObjectHashMap = new HashMap<Long, Object>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"tcvat_prepay_project_info", (String)PROJECT_FILEDS, (QFilter[])new QFilter[]{new QFilter(ID, "in", projectids)}, (String)ID);
        GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{ID}).sum(AMOUNT);
        DataSet finish = groupbyDataSet.finish();
        while (finish.hasNext()) {
            Row next = finish.next();
            Long id = next.getLong(ID);
            BigDecimal amount = next.getBigDecimal(AMOUNT) == null ? BigDecimal.ZERO : next.getBigDecimal(AMOUNT);
            objectObjectHashMap.put(id, amount);
        }
        return objectObjectHashMap;
    }

    public static boolean isSameProjects(List<DynamicObject> selectRowsData) {
        Boolean isSame = Boolean.TRUE;
        DynamicObject dynamicObject = selectRowsData.get(0);
        String projectid = dynamicObject.getString(PROJECTID);
        String[] projectids = projectid.split(COMMA);
        Set collectSet = Arrays.stream(projectids).collect(Collectors.toSet());
        HashSet result = new HashSet();
        for (int i = 0; i < selectRowsData.size(); ++i) {
            String id;
            if (i <= 0 || StringUtil.equals((CharSequence)(id = selectRowsData.get(i).getString(PROJECTID)), (CharSequence)projectid)) continue;
            if (StringUtil.isEmpty((CharSequence)id) || StringUtil.isEmpty((CharSequence)projectid)) {
                isSame = Boolean.FALSE;
                break;
            }
            String[] projects = id.split(COMMA);
            Set projectSet = Arrays.stream(projects).collect(Collectors.toSet());
            if (projectSet.size() != collectSet.size()) {
                isSame = Boolean.FALSE;
                break;
            }
            result.clear();
            result.addAll(collectSet);
            result.removeAll(projectSet);
            if (result.size() <= 0) continue;
            isSame = Boolean.FALSE;
            break;
        }
        return isSame;
    }

    public static ListShowParameter openProjectList(Object[] pkids) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tcvat_prepay_project_info", (boolean)false, (int)2);
        DynamicObjectCollection query = QueryServiceHelper.query((String)SIM_VATINVOICE_OUTPUT_SIG, (String)"orgid", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)pkids)});
        List ids = query.stream().map(e -> e.getLong("orgid")).collect(Collectors.toList());
        QFilter idFliter = new QFilter("org", "in", ids).and("projectstatus", "!=", (Object)"close");
        ListFilterParameter filterParameter = new ListFilterParameter(Collections.singletonList(idFliter), null);
        parameter.setListFilterParameter(filterParameter);
        parameter.setCustomParam("access", (Object)SIM_VATINVOICE_OUTPUT_SIG);
        return parameter;
    }
}

